# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class StoragePolicySettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'supports_all_valid_entity_types': 'bool',
        'disk_iops_max': 'int',
        'disk_iops_per_gb_max': 'int',
        'disk_iops_default': 'int',
        'storage_policy_iops_limit': 'int',
        'is_iops_limiting_enabled': 'bool',
        'ignore_iops_placement': 'bool'
    }

    attribute_map = {
        'supports_all_valid_entity_types': 'supportsAllValidEntityTypes',
        'disk_iops_max': 'diskIopsMax',
        'disk_iops_per_gb_max': 'diskIopsPerGbMax',
        'disk_iops_default': 'diskIopsDefault',
        'storage_policy_iops_limit': 'storagePolicyIopsLimit',
        'is_iops_limiting_enabled': 'isIopsLimitingEnabled',
        'ignore_iops_placement': 'ignoreIopsPlacement'
    }

    def __init__(self, supports_all_valid_entity_types=True, disk_iops_max=0, disk_iops_per_gb_max=0, disk_iops_default=0, storage_policy_iops_limit=0, is_iops_limiting_enabled=False, ignore_iops_placement=False):
        """
        StoragePolicySettings - a model defined in Swagger
        """

        self._supports_all_valid_entity_types = None
        self._disk_iops_max = None
        self._disk_iops_per_gb_max = None
        self._disk_iops_default = None
        self._storage_policy_iops_limit = None
        self._is_iops_limiting_enabled = None
        self._ignore_iops_placement = None

        if supports_all_valid_entity_types is not None:
          self.supports_all_valid_entity_types = supports_all_valid_entity_types
        if disk_iops_max is not None:
          self.disk_iops_max = disk_iops_max
        if disk_iops_per_gb_max is not None:
          self.disk_iops_per_gb_max = disk_iops_per_gb_max
        if disk_iops_default is not None:
          self.disk_iops_default = disk_iops_default
        if storage_policy_iops_limit is not None:
          self.storage_policy_iops_limit = storage_policy_iops_limit
        if is_iops_limiting_enabled is not None:
          self.is_iops_limiting_enabled = is_iops_limiting_enabled
        if ignore_iops_placement is not None:
          self.ignore_iops_placement = ignore_iops_placement

    @property
    def supports_all_valid_entity_types(self):
        """
        Gets the supports_all_valid_entity_types of this StoragePolicySettings.
        If true, designates that this storage policy can be used with all valid entity types

        :return: The supports_all_valid_entity_types of this StoragePolicySettings.
        :rtype: bool
        """
        return self._supports_all_valid_entity_types

    @supports_all_valid_entity_types.setter
    def supports_all_valid_entity_types(self, supports_all_valid_entity_types):
        """
        Sets the supports_all_valid_entity_types of this StoragePolicySettings.
        If true, designates that this storage policy can be used with all valid entity types

        :param supports_all_valid_entity_types: The supports_all_valid_entity_types of this StoragePolicySettings.
        :type: bool
        """

        self._supports_all_valid_entity_types = supports_all_valid_entity_types

    @property
    def disk_iops_max(self):
        """
        Gets the disk_iops_max of this StoragePolicySettings.
        Maximum IOPS for any disk associated with this storage policy.

        :return: The disk_iops_max of this StoragePolicySettings.
        :rtype: int
        """
        return self._disk_iops_max

    @disk_iops_max.setter
    def disk_iops_max(self, disk_iops_max):
        """
        Sets the disk_iops_max of this StoragePolicySettings.
        Maximum IOPS for any disk associated with this storage policy.

        :param disk_iops_max: The disk_iops_max of this StoragePolicySettings.
        :type: int
        """
        if disk_iops_max is not None and disk_iops_max < 0:
            raise ValueError("Invalid value for `disk_iops_max`, must be a value greater than or equal to `0`")

        self._disk_iops_max = disk_iops_max

    @property
    def disk_iops_per_gb_max(self):
        """
        Gets the disk_iops_per_gb_max of this StoragePolicySettings.
        Maximum IOPS that can be assigned to any disk associated with this storage policy based on the size of the disk (in GB). This is also the default IOPS value used for any disk associated with this policy. If set to zero, Default Disk IOPS is used as the default IOPS to be assigned to any disk associated with this storage policy. 

        :return: The disk_iops_per_gb_max of this StoragePolicySettings.
        :rtype: int
        """
        return self._disk_iops_per_gb_max

    @disk_iops_per_gb_max.setter
    def disk_iops_per_gb_max(self, disk_iops_per_gb_max):
        """
        Sets the disk_iops_per_gb_max of this StoragePolicySettings.
        Maximum IOPS that can be assigned to any disk associated with this storage policy based on the size of the disk (in GB). This is also the default IOPS value used for any disk associated with this policy. If set to zero, Default Disk IOPS is used as the default IOPS to be assigned to any disk associated with this storage policy. 

        :param disk_iops_per_gb_max: The disk_iops_per_gb_max of this StoragePolicySettings.
        :type: int
        """
        if disk_iops_per_gb_max is not None and disk_iops_per_gb_max < 0:
            raise ValueError("Invalid value for `disk_iops_per_gb_max`, must be a value greater than or equal to `0`")

        self._disk_iops_per_gb_max = disk_iops_per_gb_max

    @property
    def disk_iops_default(self):
        """
        Gets the disk_iops_default of this StoragePolicySettings.
        Default IOPS value to use for any disk associated with the storage policy. This default is only used when Disk IOPS Per GB Max is set to zero. 

        :return: The disk_iops_default of this StoragePolicySettings.
        :rtype: int
        """
        return self._disk_iops_default

    @disk_iops_default.setter
    def disk_iops_default(self, disk_iops_default):
        """
        Sets the disk_iops_default of this StoragePolicySettings.
        Default IOPS value to use for any disk associated with the storage policy. This default is only used when Disk IOPS Per GB Max is set to zero. 

        :param disk_iops_default: The disk_iops_default of this StoragePolicySettings.
        :type: int
        """
        if disk_iops_default is not None and disk_iops_default < 0:
            raise ValueError("Invalid value for `disk_iops_default`, must be a value greater than or equal to `0`")

        self._disk_iops_default = disk_iops_default

    @property
    def storage_policy_iops_limit(self):
        """
        Gets the storage_policy_iops_limit of this StoragePolicySettings.
        The sum of IOPS across all disks associated with this policy will be limited to this value. 

        :return: The storage_policy_iops_limit of this StoragePolicySettings.
        :rtype: int
        """
        return self._storage_policy_iops_limit

    @storage_policy_iops_limit.setter
    def storage_policy_iops_limit(self, storage_policy_iops_limit):
        """
        Sets the storage_policy_iops_limit of this StoragePolicySettings.
        The sum of IOPS across all disks associated with this policy will be limited to this value. 

        :param storage_policy_iops_limit: The storage_policy_iops_limit of this StoragePolicySettings.
        :type: int
        """
        if storage_policy_iops_limit is not None and storage_policy_iops_limit < 0:
            raise ValueError("Invalid value for `storage_policy_iops_limit`, must be a value greater than or equal to `0`")

        self._storage_policy_iops_limit = storage_policy_iops_limit

    @property
    def is_iops_limiting_enabled(self):
        """
        Gets the is_iops_limiting_enabled of this StoragePolicySettings.
        Whether IOPS limiting is enabled.

        :return: The is_iops_limiting_enabled of this StoragePolicySettings.
        :rtype: bool
        """
        return self._is_iops_limiting_enabled

    @is_iops_limiting_enabled.setter
    def is_iops_limiting_enabled(self, is_iops_limiting_enabled):
        """
        Sets the is_iops_limiting_enabled of this StoragePolicySettings.
        Whether IOPS limiting is enabled.

        :param is_iops_limiting_enabled: The is_iops_limiting_enabled of this StoragePolicySettings.
        :type: bool
        """

        self._is_iops_limiting_enabled = is_iops_limiting_enabled

    @property
    def ignore_iops_placement(self):
        """
        Gets the ignore_iops_placement of this StoragePolicySettings.
        Whether VCD IOPS placement should be ignored for disks using this policy.

        :return: The ignore_iops_placement of this StoragePolicySettings.
        :rtype: bool
        """
        return self._ignore_iops_placement

    @ignore_iops_placement.setter
    def ignore_iops_placement(self, ignore_iops_placement):
        """
        Sets the ignore_iops_placement of this StoragePolicySettings.
        Whether VCD IOPS placement should be ignored for disks using this policy.

        :param ignore_iops_placement: The ignore_iops_placement of this StoragePolicySettings.
        :type: bool
        """

        self._ignore_iops_placement = ignore_iops_placement

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, StoragePolicySettings):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
