# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class StorageContainer(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'datastore_type': 'str',
        'is_datastore_cluster': 'bool',
        'is_enabled': 'bool',
        'is_deleted': 'bool',
        'moref': 'str',
        'vc_ref': 'EntityReference',
        'total_storage_mb': 'int',
        'used_storage_mb': 'int',
        'provisioned_storage_mb': 'int',
        'iops_capacity': 'int'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'datastore_type': 'datastoreType',
        'is_datastore_cluster': 'isDatastoreCluster',
        'is_enabled': 'isEnabled',
        'is_deleted': 'isDeleted',
        'moref': 'moref',
        'vc_ref': 'vcRef',
        'total_storage_mb': 'totalStorageMb',
        'used_storage_mb': 'usedStorageMb',
        'provisioned_storage_mb': 'provisionedStorageMb',
        'iops_capacity': 'iopsCapacity'
    }

    def __init__(self, id=None, name=None, datastore_type=None, is_datastore_cluster=None, is_enabled=None, is_deleted=None, moref=None, vc_ref=None, total_storage_mb=None, used_storage_mb=None, provisioned_storage_mb=None, iops_capacity=None):
        """
        StorageContainer - a model defined in Swagger
        """

        self._id = None
        self._name = None
        self._datastore_type = None
        self._is_datastore_cluster = None
        self._is_enabled = None
        self._is_deleted = None
        self._moref = None
        self._vc_ref = None
        self._total_storage_mb = None
        self._used_storage_mb = None
        self._provisioned_storage_mb = None
        self._iops_capacity = None

        if id is not None:
          self.id = id
        if name is not None:
          self.name = name
        if datastore_type is not None:
          self.datastore_type = datastore_type
        if is_datastore_cluster is not None:
          self.is_datastore_cluster = is_datastore_cluster
        if is_enabled is not None:
          self.is_enabled = is_enabled
        if is_deleted is not None:
          self.is_deleted = is_deleted
        if moref is not None:
          self.moref = moref
        if vc_ref is not None:
          self.vc_ref = vc_ref
        if total_storage_mb is not None:
          self.total_storage_mb = total_storage_mb
        if used_storage_mb is not None:
          self.used_storage_mb = used_storage_mb
        if provisioned_storage_mb is not None:
          self.provisioned_storage_mb = provisioned_storage_mb
        if iops_capacity is not None:
          self.iops_capacity = iops_capacity

    @property
    def id(self):
        """
        Gets the id of this StorageContainer.
        Unique VCD Id for the Storage Container.

        :return: The id of this StorageContainer.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this StorageContainer.
        Unique VCD Id for the Storage Container.

        :param id: The id of this StorageContainer.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this StorageContainer.
        Name for the Storage Container.

        :return: The name of this StorageContainer.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this StorageContainer.
        Name for the Storage Container.

        :param name: The name of this StorageContainer.
        :type: str
        """

        self._name = name

    @property
    def datastore_type(self):
        """
        Gets the datastore_type of this StorageContainer.
        Datastore Type of the Storage Container.

        :return: The datastore_type of this StorageContainer.
        :rtype: str
        """
        return self._datastore_type

    @datastore_type.setter
    def datastore_type(self, datastore_type):
        """
        Sets the datastore_type of this StorageContainer.
        Datastore Type of the Storage Container.

        :param datastore_type: The datastore_type of this StorageContainer.
        :type: str
        """

        self._datastore_type = datastore_type

    @property
    def is_datastore_cluster(self):
        """
        Gets the is_datastore_cluster of this StorageContainer.
        True if this Storage Container is a Datastore Cluster.

        :return: The is_datastore_cluster of this StorageContainer.
        :rtype: bool
        """
        return self._is_datastore_cluster

    @is_datastore_cluster.setter
    def is_datastore_cluster(self, is_datastore_cluster):
        """
        Sets the is_datastore_cluster of this StorageContainer.
        True if this Storage Container is a Datastore Cluster.

        :param is_datastore_cluster: The is_datastore_cluster of this StorageContainer.
        :type: bool
        """

        self._is_datastore_cluster = is_datastore_cluster

    @property
    def is_enabled(self):
        """
        Gets the is_enabled of this StorageContainer.
        True if this Storage Container is enabled. Unset if this storage container is part of a Datastore Cluster

        :return: The is_enabled of this StorageContainer.
        :rtype: bool
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """
        Sets the is_enabled of this StorageContainer.
        True if this Storage Container is enabled. Unset if this storage container is part of a Datastore Cluster

        :param is_enabled: The is_enabled of this StorageContainer.
        :type: bool
        """

        self._is_enabled = is_enabled

    @property
    def is_deleted(self):
        """
        Gets the is_deleted of this StorageContainer.
        Deleted state of the Storage Container.

        :return: The is_deleted of this StorageContainer.
        :rtype: bool
        """
        return self._is_deleted

    @is_deleted.setter
    def is_deleted(self, is_deleted):
        """
        Sets the is_deleted of this StorageContainer.
        Deleted state of the Storage Container.

        :param is_deleted: The is_deleted of this StorageContainer.
        :type: bool
        """

        self._is_deleted = is_deleted

    @property
    def moref(self):
        """
        Gets the moref of this StorageContainer.
        Unique Id in Virtual Center of the Storage Container.

        :return: The moref of this StorageContainer.
        :rtype: str
        """
        return self._moref

    @moref.setter
    def moref(self, moref):
        """
        Sets the moref of this StorageContainer.
        Unique Id in Virtual Center of the Storage Container.

        :param moref: The moref of this StorageContainer.
        :type: str
        """

        self._moref = moref

    @property
    def vc_ref(self):
        """
        Gets the vc_ref of this StorageContainer.
        The VC that this Storage Container belongs to.

        :return: The vc_ref of this StorageContainer.
        :rtype: EntityReference
        """
        return self._vc_ref

    @vc_ref.setter
    def vc_ref(self, vc_ref):
        """
        Sets the vc_ref of this StorageContainer.
        The VC that this Storage Container belongs to.

        :param vc_ref: The vc_ref of this StorageContainer.
        :type: EntityReference
        """

        self._vc_ref = vc_ref

    @property
    def total_storage_mb(self):
        """
        Gets the total_storage_mb of this StorageContainer.
        Total storage in MB for this Storage Container.

        :return: The total_storage_mb of this StorageContainer.
        :rtype: int
        """
        return self._total_storage_mb

    @total_storage_mb.setter
    def total_storage_mb(self, total_storage_mb):
        """
        Sets the total_storage_mb of this StorageContainer.
        Total storage in MB for this Storage Container.

        :param total_storage_mb: The total_storage_mb of this StorageContainer.
        :type: int
        """

        self._total_storage_mb = total_storage_mb

    @property
    def used_storage_mb(self):
        """
        Gets the used_storage_mb of this StorageContainer.
        Total used storage in MB for this Storage Container.

        :return: The used_storage_mb of this StorageContainer.
        :rtype: int
        """
        return self._used_storage_mb

    @used_storage_mb.setter
    def used_storage_mb(self, used_storage_mb):
        """
        Sets the used_storage_mb of this StorageContainer.
        Total used storage in MB for this Storage Container.

        :param used_storage_mb: The used_storage_mb of this StorageContainer.
        :type: int
        """

        self._used_storage_mb = used_storage_mb

    @property
    def provisioned_storage_mb(self):
        """
        Gets the provisioned_storage_mb of this StorageContainer.
        Total provisioned storage in MB for this Storage Container.

        :return: The provisioned_storage_mb of this StorageContainer.
        :rtype: int
        """
        return self._provisioned_storage_mb

    @provisioned_storage_mb.setter
    def provisioned_storage_mb(self, provisioned_storage_mb):
        """
        Sets the provisioned_storage_mb of this StorageContainer.
        Total provisioned storage in MB for this Storage Container.

        :param provisioned_storage_mb: The provisioned_storage_mb of this StorageContainer.
        :type: int
        """

        self._provisioned_storage_mb = provisioned_storage_mb

    @property
    def iops_capacity(self):
        """
        Gets the iops_capacity of this StorageContainer.
        Total IOPS capacity for this Storage Container.

        :return: The iops_capacity of this StorageContainer.
        :rtype: int
        """
        return self._iops_capacity

    @iops_capacity.setter
    def iops_capacity(self, iops_capacity):
        """
        Sets the iops_capacity of this StorageContainer.
        Total IOPS capacity for this Storage Container.

        :param iops_capacity: The iops_capacity of this StorageContainer.
        :type: int
        """

        self._iops_capacity = iops_capacity

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, StorageContainer):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
