# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ProxyConfiguration(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'id': 'str',
        'description': 'str',
        'auth_type': 'str',
        'username': 'str',
        'password': 'str',
        'token': 'str',
        'host': 'str',
        'port': 'int'
    }

    attribute_map = {
        'name': 'name',
        'id': 'id',
        'description': 'description',
        'auth_type': 'authType',
        'username': 'username',
        'password': 'password',
        'token': 'token',
        'host': 'host',
        'port': 'port'
    }

    def __init__(self, name=None, id=None, description=None, auth_type=None, username=None, password=None, token=None, host=None, port=None):
        """
        ProxyConfiguration - a model defined in Swagger
        """

        self._name = None
        self._id = None
        self._description = None
        self._auth_type = None
        self._username = None
        self._password = None
        self._token = None
        self._host = None
        self._port = None

        self.name = name
        if id is not None:
          self.id = id
        if description is not None:
          self.description = description
        self.auth_type = auth_type
        if username is not None:
          self.username = username
        self.password = password
        if token is not None:
          self.token = token
        self.host = host
        self.port = port

    @property
    def name(self):
        """
        Gets the name of this ProxyConfiguration.

        :return: The name of this ProxyConfiguration.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ProxyConfiguration.

        :param name: The name of this ProxyConfiguration.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        if name is not None and not re.search('.*[\\S].*', name):
            raise ValueError("Invalid value for `name`, must be a follow pattern or equal to `/.*[\\S].*/`")

        self._name = name

    @property
    def id(self):
        """
        Gets the id of this ProxyConfiguration.

        :return: The id of this ProxyConfiguration.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ProxyConfiguration.

        :param id: The id of this ProxyConfiguration.
        :type: str
        """

        self._id = id

    @property
    def description(self):
        """
        Gets the description of this ProxyConfiguration.
        Optional description.

        :return: The description of this ProxyConfiguration.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ProxyConfiguration.
        Optional description.

        :param description: The description of this ProxyConfiguration.
        :type: str
        """

        self._description = description

    @property
    def auth_type(self):
        """
        Gets the auth_type of this ProxyConfiguration.

        :return: The auth_type of this ProxyConfiguration.
        :rtype: str
        """
        return self._auth_type

    @auth_type.setter
    def auth_type(self, auth_type):
        """
        Sets the auth_type of this ProxyConfiguration.

        :param auth_type: The auth_type of this ProxyConfiguration.
        :type: str
        """
        if auth_type is None:
            raise ValueError("Invalid value for `auth_type`, must not be `None`")
        allowed_values = ["BASIC", "BEARER"]
        if auth_type not in allowed_values:
            raise ValueError(
                "Invalid value for `auth_type` ({0}), must be one of {1}"
                .format(auth_type, allowed_values)
            )

        self._auth_type = auth_type

    @property
    def username(self):
        """
        Gets the username of this ProxyConfiguration.
        username to connect to the proxy server.

        :return: The username of this ProxyConfiguration.
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """
        Sets the username of this ProxyConfiguration.
        username to connect to the proxy server.

        :param username: The username of this ProxyConfiguration.
        :type: str
        """

        self._username = username

    @property
    def password(self):
        """
        Gets the password of this ProxyConfiguration.
        password to connect to the proxy server, when auth type is Basic.

        :return: The password of this ProxyConfiguration.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this ProxyConfiguration.
        password to connect to the proxy server, when auth type is Basic.

        :param password: The password of this ProxyConfiguration.
        :type: str
        """
        if password is None:
            raise ValueError("Invalid value for `password`, must not be `None`")

        self._password = password

    @property
    def token(self):
        """
        Gets the token of this ProxyConfiguration.
        authentication token to connect to the proxy server, when auth type is Bearer.

        :return: The token of this ProxyConfiguration.
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """
        Sets the token of this ProxyConfiguration.
        authentication token to connect to the proxy server, when auth type is Bearer.

        :param token: The token of this ProxyConfiguration.
        :type: str
        """

        self._token = token

    @property
    def host(self):
        """
        Gets the host of this ProxyConfiguration.
        hostname of the proxy server.

        :return: The host of this ProxyConfiguration.
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """
        Sets the host of this ProxyConfiguration.
        hostname of the proxy server.

        :param host: The host of this ProxyConfiguration.
        :type: str
        """
        if host is None:
            raise ValueError("Invalid value for `host`, must not be `None`")

        self._host = host

    @property
    def port(self):
        """
        Gets the port of this ProxyConfiguration.
        port of the proxy server.

        :return: The port of this ProxyConfiguration.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this ProxyConfiguration.
        port of the proxy server.

        :param port: The port of this ProxyConfiguration.
        :type: int
        """
        if port is None:
            raise ValueError("Invalid value for `port`, must not be `None`")

        self._port = port

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ProxyConfiguration):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
