# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ProbeResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'result': 'str',
        'resolved_ip': 'str',
        'can_connect': 'bool',
        'ssl_handshake': 'bool',
        'certificate_chain': 'str',
        'additional_ca_issuers': 'list[str]'
    }

    attribute_map = {
        'result': 'result',
        'resolved_ip': 'resolvedIp',
        'can_connect': 'canConnect',
        'ssl_handshake': 'sslHandshake',
        'certificate_chain': 'certificateChain',
        'additional_ca_issuers': 'additionalCAIssuers'
    }

    def __init__(self, result=None, resolved_ip=None, can_connect=None, ssl_handshake=None, certificate_chain=None, additional_ca_issuers=None):
        """
        ProbeResult - a model defined in Swagger
        """

        self._result = None
        self._resolved_ip = None
        self._can_connect = None
        self._ssl_handshake = None
        self._certificate_chain = None
        self._additional_ca_issuers = None

        if result is not None:
          self.result = result
        if resolved_ip is not None:
          self.resolved_ip = resolved_ip
        if can_connect is not None:
          self.can_connect = can_connect
        if ssl_handshake is not None:
          self.ssl_handshake = ssl_handshake
        if certificate_chain is not None:
          self.certificate_chain = certificate_chain
        if additional_ca_issuers is not None:
          self.additional_ca_issuers = additional_ca_issuers

    @property
    def result(self):
        """
        Gets the result of this ProbeResult.
        Localized message describing the connection result stating success or an error message with a brief summary.

        :return: The result of this ProbeResult.
        :rtype: str
        """
        return self._result

    @result.setter
    def result(self, result):
        """
        Sets the result of this ProbeResult.
        Localized message describing the connection result stating success or an error message with a brief summary.

        :param result: The result of this ProbeResult.
        :type: str
        """

        self._result = result

    @property
    def resolved_ip(self):
        """
        Gets the resolved_ip of this ProbeResult.
        The IP address the host was resolved to.

        :return: The resolved_ip of this ProbeResult.
        :rtype: str
        """
        return self._resolved_ip

    @resolved_ip.setter
    def resolved_ip(self, resolved_ip):
        """
        Sets the resolved_ip of this ProbeResult.
        The IP address the host was resolved to.

        :param resolved_ip: The resolved_ip of this ProbeResult.
        :type: str
        """

        self._resolved_ip = resolved_ip

    @property
    def can_connect(self):
        """
        Gets the can_connect of this ProbeResult.
        If vCD can establish a connection on the specified port.

        :return: The can_connect of this ProbeResult.
        :rtype: bool
        """
        return self._can_connect

    @can_connect.setter
    def can_connect(self, can_connect):
        """
        Sets the can_connect of this ProbeResult.
        If vCD can establish a connection on the specified port.

        :param can_connect: The can_connect of this ProbeResult.
        :type: bool
        """

        self._can_connect = can_connect

    @property
    def ssl_handshake(self):
        """
        Gets the ssl_handshake of this ProbeResult.
        If an SSL Handshake succeeded (secure requests only).

        :return: The ssl_handshake of this ProbeResult.
        :rtype: bool
        """
        return self._ssl_handshake

    @ssl_handshake.setter
    def ssl_handshake(self, ssl_handshake):
        """
        Sets the ssl_handshake of this ProbeResult.
        If an SSL Handshake succeeded (secure requests only).

        :param ssl_handshake: The ssl_handshake of this ProbeResult.
        :type: bool
        """

        self._ssl_handshake = ssl_handshake

    @property
    def certificate_chain(self):
        """
        Gets the certificate_chain of this ProbeResult.
        The SSL certificate chain presented by the server if a secure connection was made.

        :return: The certificate_chain of this ProbeResult.
        :rtype: str
        """
        return self._certificate_chain

    @certificate_chain.setter
    def certificate_chain(self, certificate_chain):
        """
        Sets the certificate_chain of this ProbeResult.
        The SSL certificate chain presented by the server if a secure connection was made.

        :param certificate_chain: The certificate_chain of this ProbeResult.
        :type: str
        """

        self._certificate_chain = certificate_chain

    @property
    def additional_ca_issuers(self):
        """
        Gets the additional_ca_issuers of this ProbeResult.
        URLs supplied by Certificate Authorities to retrieve signing certificates, when those certificates are not included in the chain. These URLs are the locations for the 'caIssuers' access method in the 'Authority Info Access' extension (as described in <a href=\"https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.2.1\">RFC 5280 Section 4.2.2.1</a>) of the certificates and gives the caller an indication where additional CA certificates may be retrieved from, to complete the chain to the trust anchor. 

        :return: The additional_ca_issuers of this ProbeResult.
        :rtype: list[str]
        """
        return self._additional_ca_issuers

    @additional_ca_issuers.setter
    def additional_ca_issuers(self, additional_ca_issuers):
        """
        Sets the additional_ca_issuers of this ProbeResult.
        URLs supplied by Certificate Authorities to retrieve signing certificates, when those certificates are not included in the chain. These URLs are the locations for the 'caIssuers' access method in the 'Authority Info Access' extension (as described in <a href=\"https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.2.1\">RFC 5280 Section 4.2.2.1</a>) of the certificates and gives the caller an indication where additional CA certificates may be retrieved from, to complete the chain to the trust anchor. 

        :param additional_ca_issuers: The additional_ca_issuers of this ProbeResult.
        :type: list[str]
        """

        self._additional_ca_issuers = additional_ca_issuers

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ProbeResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
