# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class PresentationExecution(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'description': 'str',
        'id': 'str',
        'name': 'str',
        'object_id': 'str',
        'parameters': 'list[WsParameter]',
        'start_date': 'datetime',
        'started_by': 'str',
        'steps': 'list[StepInfo]',
        'valid': 'bool'
    }

    attribute_map = {
        'description': 'description',
        'id': 'id',
        'name': 'name',
        'object_id': 'objectId',
        'parameters': 'parameters',
        'start_date': 'startDate',
        'started_by': 'startedBy',
        'steps': 'steps',
        'valid': 'valid'
    }

    def __init__(self, description=None, id=None, name=None, object_id=None, parameters=None, start_date=None, started_by=None, steps=None, valid=None):
        """
        PresentationExecution - a model defined in Swagger
        """

        self._description = None
        self._id = None
        self._name = None
        self._object_id = None
        self._parameters = None
        self._start_date = None
        self._started_by = None
        self._steps = None
        self._valid = None

        if description is not None:
          self.description = description
        if id is not None:
          self.id = id
        if name is not None:
          self.name = name
        if object_id is not None:
          self.object_id = object_id
        if parameters is not None:
          self.parameters = parameters
        if start_date is not None:
          self.start_date = start_date
        if started_by is not None:
          self.started_by = started_by
        if steps is not None:
          self.steps = steps
        if valid is not None:
          self.valid = valid

    @property
    def description(self):
        """
        Gets the description of this PresentationExecution.

        :return: The description of this PresentationExecution.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this PresentationExecution.

        :param description: The description of this PresentationExecution.
        :type: str
        """

        self._description = description

    @property
    def id(self):
        """
        Gets the id of this PresentationExecution.

        :return: The id of this PresentationExecution.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PresentationExecution.

        :param id: The id of this PresentationExecution.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this PresentationExecution.

        :return: The name of this PresentationExecution.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this PresentationExecution.

        :param name: The name of this PresentationExecution.
        :type: str
        """

        self._name = name

    @property
    def object_id(self):
        """
        Gets the object_id of this PresentationExecution.

        :return: The object_id of this PresentationExecution.
        :rtype: str
        """
        return self._object_id

    @object_id.setter
    def object_id(self, object_id):
        """
        Sets the object_id of this PresentationExecution.

        :param object_id: The object_id of this PresentationExecution.
        :type: str
        """

        self._object_id = object_id

    @property
    def parameters(self):
        """
        Gets the parameters of this PresentationExecution.

        :return: The parameters of this PresentationExecution.
        :rtype: list[WsParameter]
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters):
        """
        Sets the parameters of this PresentationExecution.

        :param parameters: The parameters of this PresentationExecution.
        :type: list[WsParameter]
        """

        self._parameters = parameters

    @property
    def start_date(self):
        """
        Gets the start_date of this PresentationExecution.

        :return: The start_date of this PresentationExecution.
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """
        Sets the start_date of this PresentationExecution.

        :param start_date: The start_date of this PresentationExecution.
        :type: datetime
        """

        self._start_date = start_date

    @property
    def started_by(self):
        """
        Gets the started_by of this PresentationExecution.

        :return: The started_by of this PresentationExecution.
        :rtype: str
        """
        return self._started_by

    @started_by.setter
    def started_by(self, started_by):
        """
        Sets the started_by of this PresentationExecution.

        :param started_by: The started_by of this PresentationExecution.
        :type: str
        """

        self._started_by = started_by

    @property
    def steps(self):
        """
        Gets the steps of this PresentationExecution.

        :return: The steps of this PresentationExecution.
        :rtype: list[StepInfo]
        """
        return self._steps

    @steps.setter
    def steps(self, steps):
        """
        Sets the steps of this PresentationExecution.

        :param steps: The steps of this PresentationExecution.
        :type: list[StepInfo]
        """

        self._steps = steps

    @property
    def valid(self):
        """
        Gets the valid of this PresentationExecution.

        :return: The valid of this PresentationExecution.
        :rtype: bool
        """
        return self._valid

    @valid.setter
    def valid(self, valid):
        """
        Sets the valid of this PresentationExecution.

        :param valid: The valid of this PresentationExecution.
        :type: bool
        """

        self._valid = valid

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, PresentationExecution):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
