# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Org(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'display_name': 'str',
        'description': 'str',
        'is_enabled': 'bool',
        'org_vdc_count': 'int',
        'catalog_count': 'int',
        'vapp_count': 'int',
        'running_vm_count': 'int',
        'user_count': 'int',
        'can_publish': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'display_name': 'displayName',
        'description': 'description',
        'is_enabled': 'isEnabled',
        'org_vdc_count': 'orgVdcCount',
        'catalog_count': 'catalogCount',
        'vapp_count': 'vappCount',
        'running_vm_count': 'runningVMCount',
        'user_count': 'userCount',
        'can_publish': 'canPublish'
    }

    def __init__(self, id=None, name=None, display_name=None, description='', is_enabled=False, org_vdc_count=None, catalog_count=None, vapp_count=None, running_vm_count=None, user_count=None, can_publish=None):
        """
        Org - a model defined in Swagger
        """

        self._id = None
        self._name = None
        self._display_name = None
        self._description = None
        self._is_enabled = None
        self._org_vdc_count = None
        self._catalog_count = None
        self._vapp_count = None
        self._running_vm_count = None
        self._user_count = None
        self._can_publish = None

        if id is not None:
          self.id = id
        self.name = name
        self.display_name = display_name
        if description is not None:
          self.description = description
        if is_enabled is not None:
          self.is_enabled = is_enabled
        if org_vdc_count is not None:
          self.org_vdc_count = org_vdc_count
        if catalog_count is not None:
          self.catalog_count = catalog_count
        if vapp_count is not None:
          self.vapp_count = vapp_count
        if running_vm_count is not None:
          self.running_vm_count = running_vm_count
        if user_count is not None:
          self.user_count = user_count
        if can_publish is not None:
          self.can_publish = can_publish

    @property
    def id(self):
        """
        Gets the id of this Org.
        A unique identifier for the organization.

        :return: The id of this Org.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Org.
        A unique identifier for the organization.

        :param id: The id of this Org.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Org.
        Name of the organization.

        :return: The name of this Org.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Org.
        Name of the organization.

        :param name: The name of this Org.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        if name is not None and len(name) > 128:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `128`")
        if name is not None and not re.search('^[a-zA-Z0-9_\\-\\.\\!\\\'\\(\\),\\$]+$', name):
            raise ValueError("Invalid value for `name`, must be a follow pattern or equal to `/^[a-zA-Z0-9_\\-\\.\\!\\'\\(\\),\\$]+$/`")

        self._name = name

    @property
    def display_name(self):
        """
        Gets the display_name of this Org.
        Full display name of the organization.

        :return: The display_name of this Org.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Org.
        Full display name of the organization.

        :param display_name: The display_name of this Org.
        :type: str
        """
        if display_name is None:
            raise ValueError("Invalid value for `display_name`, must not be `None`")
        if display_name is not None and len(display_name) > 128:
            raise ValueError("Invalid value for `display_name`, length must be less than or equal to `128`")
        if display_name is not None and not re.search('[\\s\\S]*\\S[\\s\\S]*', display_name):
            raise ValueError("Invalid value for `display_name`, must be a follow pattern or equal to `/[\\s\\S]*\\S[\\s\\S]*/`")

        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this Org.
        Description of the organization.

        :return: The description of this Org.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Org.
        Description of the organization.

        :param description: The description of this Org.
        :type: str
        """
        if description is not None and len(description) > 256:
            raise ValueError("Invalid value for `description`, length must be less than or equal to `256`")

        self._description = description

    @property
    def is_enabled(self):
        """
        Gets the is_enabled of this Org.
        Whether the organization is enabled or not.

        :return: The is_enabled of this Org.
        :rtype: bool
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """
        Sets the is_enabled of this Org.
        Whether the organization is enabled or not.

        :param is_enabled: The is_enabled of this Org.
        :type: bool
        """

        self._is_enabled = is_enabled

    @property
    def org_vdc_count(self):
        """
        Gets the org_vdc_count of this Org.
        The number of VDCs in the org.

        :return: The org_vdc_count of this Org.
        :rtype: int
        """
        return self._org_vdc_count

    @org_vdc_count.setter
    def org_vdc_count(self, org_vdc_count):
        """
        Sets the org_vdc_count of this Org.
        The number of VDCs in the org.

        :param org_vdc_count: The org_vdc_count of this Org.
        :type: int
        """

        self._org_vdc_count = org_vdc_count

    @property
    def catalog_count(self):
        """
        Gets the catalog_count of this Org.
        The number of catalogs in the org.

        :return: The catalog_count of this Org.
        :rtype: int
        """
        return self._catalog_count

    @catalog_count.setter
    def catalog_count(self, catalog_count):
        """
        Sets the catalog_count of this Org.
        The number of catalogs in the org.

        :param catalog_count: The catalog_count of this Org.
        :type: int
        """

        self._catalog_count = catalog_count

    @property
    def vapp_count(self):
        """
        Gets the vapp_count of this Org.
        The number of vApps in the org.

        :return: The vapp_count of this Org.
        :rtype: int
        """
        return self._vapp_count

    @vapp_count.setter
    def vapp_count(self, vapp_count):
        """
        Sets the vapp_count of this Org.
        The number of vApps in the org.

        :param vapp_count: The vapp_count of this Org.
        :type: int
        """

        self._vapp_count = vapp_count

    @property
    def running_vm_count(self):
        """
        Gets the running_vm_count of this Org.
        The number of running VMs in the org.

        :return: The running_vm_count of this Org.
        :rtype: int
        """
        return self._running_vm_count

    @running_vm_count.setter
    def running_vm_count(self, running_vm_count):
        """
        Sets the running_vm_count of this Org.
        The number of running VMs in the org.

        :param running_vm_count: The running_vm_count of this Org.
        :type: int
        """

        self._running_vm_count = running_vm_count

    @property
    def user_count(self):
        """
        Gets the user_count of this Org.
        The number of users in the org.

        :return: The user_count of this Org.
        :rtype: int
        """
        return self._user_count

    @user_count.setter
    def user_count(self, user_count):
        """
        Sets the user_count of this Org.
        The number of users in the org.

        :param user_count: The user_count of this Org.
        :type: int
        """

        self._user_count = user_count

    @property
    def can_publish(self):
        """
        Gets the can_publish of this Org.
        Whether the organization can publish catalogs externally.

        :return: The can_publish of this Org.
        :rtype: bool
        """
        return self._can_publish

    @can_publish.setter
    def can_publish(self, can_publish):
        """
        Sets the can_publish of this Org.
        Whether the organization can publish catalogs externally.

        :param can_publish: The can_publish of this Org.
        :type: bool
        """

        self._can_publish = can_publish

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Org):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
