# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ExternalService(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'id': 'str',
        'version': 'str',
        'vendor': 'str',
        'priority': 'int',
        'enabled': 'bool',
        'authorization_enabled': 'bool',
        'description': 'str',
        'mqtt_topics': 'dict(str, str)'
    }

    attribute_map = {
        'name': 'name',
        'id': 'id',
        'version': 'version',
        'vendor': 'vendor',
        'priority': 'priority',
        'enabled': 'enabled',
        'authorization_enabled': 'authorizationEnabled',
        'description': 'description',
        'mqtt_topics': 'mqttTopics'
    }

    def __init__(self, name=None, id=None, version=None, vendor=None, priority=50, enabled=None, authorization_enabled=False, description=None, mqtt_topics=None):
        """
        ExternalService - a model defined in Swagger
        """

        self._name = None
        self._id = None
        self._version = None
        self._vendor = None
        self._priority = None
        self._enabled = None
        self._authorization_enabled = None
        self._description = None
        self._mqtt_topics = None

        self.name = name
        if id is not None:
          self.id = id
        self.version = version
        self.vendor = vendor
        if priority is not None:
          self.priority = priority
        self.enabled = enabled
        if authorization_enabled is not None:
          self.authorization_enabled = authorization_enabled
        if description is not None:
          self.description = description
        if mqtt_topics is not None:
          self.mqtt_topics = mqtt_topics

    @property
    def name(self):
        """
        Gets the name of this ExternalService.
        The name of the external service.

        :return: The name of this ExternalService.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ExternalService.
        The name of the external service.

        :param name: The name of this ExternalService.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")

        self._name = name

    @property
    def id(self):
        """
        Gets the id of this ExternalService.
        The unique id of the external service.

        :return: The id of this ExternalService.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ExternalService.
        The unique id of the external service.

        :param id: The id of this ExternalService.
        :type: str
        """

        self._id = id

    @property
    def version(self):
        """
        Gets the version of this ExternalService.
        The extension's version. The version should follow semantic versioning rules. The combination of vendor-namespace-version must be unique. 

        :return: The version of this ExternalService.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this ExternalService.
        The extension's version. The version should follow semantic versioning rules. The combination of vendor-namespace-version must be unique. 

        :param version: The version of this ExternalService.
        :type: str
        """
        if version is None:
            raise ValueError("Invalid value for `version`, must not be `None`")

        self._version = version

    @property
    def vendor(self):
        """
        Gets the vendor of this ExternalService.
        The vendor name. The combination of vendor-namespace-version must be unique. 

        :return: The vendor of this ExternalService.
        :rtype: str
        """
        return self._vendor

    @vendor.setter
    def vendor(self, vendor):
        """
        Sets the vendor of this ExternalService.
        The vendor name. The combination of vendor-namespace-version must be unique. 

        :param vendor: The vendor of this ExternalService.
        :type: str
        """
        if vendor is None:
            raise ValueError("Invalid value for `vendor`, must not be `None`")

        self._vendor = vendor

    @property
    def priority(self):
        """
        Gets the priority of this ExternalService.
        Extension service priority. An integer between 0-100. A value of 50 denotes a neutral priority. 

        :return: The priority of this ExternalService.
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """
        Sets the priority of this ExternalService.
        Extension service priority. An integer between 0-100. A value of 50 denotes a neutral priority. 

        :param priority: The priority of this ExternalService.
        :type: int
        """
        if priority is not None and priority > 100:
            raise ValueError("Invalid value for `priority`, must be a value less than or equal to `100`")
        if priority is not None and priority < 0:
            raise ValueError("Invalid value for `priority`, must be a value greater than or equal to `0`")

        self._priority = priority

    @property
    def enabled(self):
        """
        Gets the enabled of this ExternalService.
        Whether the extension is enabled or not.

        :return: The enabled of this ExternalService.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this ExternalService.
        Whether the extension is enabled or not.

        :param enabled: The enabled of this ExternalService.
        :type: bool
        """
        if enabled is None:
            raise ValueError("Invalid value for `enabled`, must not be `None`")

        self._enabled = enabled

    @property
    def authorization_enabled(self):
        """
        Gets the authorization_enabled of this ExternalService.
        Whether authorization is enabled for the service.

        :return: The authorization_enabled of this ExternalService.
        :rtype: bool
        """
        return self._authorization_enabled

    @authorization_enabled.setter
    def authorization_enabled(self, authorization_enabled):
        """
        Sets the authorization_enabled of this ExternalService.
        Whether authorization is enabled for the service.

        :param authorization_enabled: The authorization_enabled of this ExternalService.
        :type: bool
        """

        self._authorization_enabled = authorization_enabled

    @property
    def description(self):
        """
        Gets the description of this ExternalService.

        :return: The description of this ExternalService.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ExternalService.

        :param description: The description of this ExternalService.
        :type: str
        """

        self._description = description

    @property
    def mqtt_topics(self):
        """
        Gets the mqtt_topics of this ExternalService.
        The map of MQTT topics this extension will communicate through. 

        :return: The mqtt_topics of this ExternalService.
        :rtype: dict(str, str)
        """
        return self._mqtt_topics

    @mqtt_topics.setter
    def mqtt_topics(self, mqtt_topics):
        """
        Sets the mqtt_topics of this ExternalService.
        The map of MQTT topics this extension will communicate through. 

        :param mqtt_topics: The mqtt_topics of this ExternalService.
        :type: dict(str, str)
        """

        self._mqtt_topics = mqtt_topics

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ExternalService):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
