# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EmailSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'default_smtp_server': 'bool',
        'default_org_email': 'bool',
        'smtp_server': 'SmtpServerSpec',
        'sender_email_address': 'str',
        'default_email_subject_prefix': 'str',
        'alert_email_to_all_admins': 'bool',
        'alert_email_to': 'str'
    }

    attribute_map = {
        'default_smtp_server': 'defaultSmtpServer',
        'default_org_email': 'defaultOrgEmail',
        'smtp_server': 'smtpServer',
        'sender_email_address': 'senderEmailAddress',
        'default_email_subject_prefix': 'defaultEmailSubjectPrefix',
        'alert_email_to_all_admins': 'alertEmailToAllAdmins',
        'alert_email_to': 'alertEmailTo'
    }

    def __init__(self, default_smtp_server=None, default_org_email=None, smtp_server=None, sender_email_address=None, default_email_subject_prefix=None, alert_email_to_all_admins=None, alert_email_to=None):
        """
        EmailSettings - a model defined in Swagger
        """

        self._default_smtp_server = None
        self._default_org_email = None
        self._smtp_server = None
        self._sender_email_address = None
        self._default_email_subject_prefix = None
        self._alert_email_to_all_admins = None
        self._alert_email_to = None

        if default_smtp_server is not None:
          self.default_smtp_server = default_smtp_server
        if default_org_email is not None:
          self.default_org_email = default_org_email
        if smtp_server is not None:
          self.smtp_server = smtp_server
        if sender_email_address is not None:
          self.sender_email_address = sender_email_address
        if default_email_subject_prefix is not None:
          self.default_email_subject_prefix = default_email_subject_prefix
        if alert_email_to_all_admins is not None:
          self.alert_email_to_all_admins = alert_email_to_all_admins
        if alert_email_to is not None:
          self.alert_email_to = alert_email_to

    @property
    def default_smtp_server(self):
        """
        Gets the default_smtp_server of this EmailSettings.
        Flag indicating if the smtp server settings are system default (true) or a particular organization (false) 

        :return: The default_smtp_server of this EmailSettings.
        :rtype: bool
        """
        return self._default_smtp_server

    @default_smtp_server.setter
    def default_smtp_server(self, default_smtp_server):
        """
        Sets the default_smtp_server of this EmailSettings.
        Flag indicating if the smtp server settings are system default (true) or a particular organization (false) 

        :param default_smtp_server: The default_smtp_server of this EmailSettings.
        :type: bool
        """

        self._default_smtp_server = default_smtp_server

    @property
    def default_org_email(self):
        """
        Gets the default_org_email of this EmailSettings.
        Flag indicating if the email settings are system default (true) or for a particular organization (false) 

        :return: The default_org_email of this EmailSettings.
        :rtype: bool
        """
        return self._default_org_email

    @default_org_email.setter
    def default_org_email(self, default_org_email):
        """
        Sets the default_org_email of this EmailSettings.
        Flag indicating if the email settings are system default (true) or for a particular organization (false) 

        :param default_org_email: The default_org_email of this EmailSettings.
        :type: bool
        """

        self._default_org_email = default_org_email

    @property
    def smtp_server(self):
        """
        Gets the smtp_server of this EmailSettings.

        :return: The smtp_server of this EmailSettings.
        :rtype: SmtpServerSpec
        """
        return self._smtp_server

    @smtp_server.setter
    def smtp_server(self, smtp_server):
        """
        Sets the smtp_server of this EmailSettings.

        :param smtp_server: The smtp_server of this EmailSettings.
        :type: SmtpServerSpec
        """

        self._smtp_server = smtp_server

    @property
    def sender_email_address(self):
        """
        Gets the sender_email_address of this EmailSettings.
        Sender email address in an email notification or alert 

        :return: The sender_email_address of this EmailSettings.
        :rtype: str
        """
        return self._sender_email_address

    @sender_email_address.setter
    def sender_email_address(self, sender_email_address):
        """
        Sets the sender_email_address of this EmailSettings.
        Sender email address in an email notification or alert 

        :param sender_email_address: The sender_email_address of this EmailSettings.
        :type: str
        """

        self._sender_email_address = sender_email_address

    @property
    def default_email_subject_prefix(self):
        """
        Gets the default_email_subject_prefix of this EmailSettings.
        The prefix used in the email subject line for all email notifications and alerts from the system 

        :return: The default_email_subject_prefix of this EmailSettings.
        :rtype: str
        """
        return self._default_email_subject_prefix

    @default_email_subject_prefix.setter
    def default_email_subject_prefix(self, default_email_subject_prefix):
        """
        Sets the default_email_subject_prefix of this EmailSettings.
        The prefix used in the email subject line for all email notifications and alerts from the system 

        :param default_email_subject_prefix: The default_email_subject_prefix of this EmailSettings.
        :type: str
        """

        self._default_email_subject_prefix = default_email_subject_prefix

    @property
    def alert_email_to_all_admins(self):
        """
        Gets the alert_email_to_all_admins of this EmailSettings.
        A flag to indicate the choice between sending alert emails to all system administrators in the system and designated list of email recipients 

        :return: The alert_email_to_all_admins of this EmailSettings.
        :rtype: bool
        """
        return self._alert_email_to_all_admins

    @alert_email_to_all_admins.setter
    def alert_email_to_all_admins(self, alert_email_to_all_admins):
        """
        Sets the alert_email_to_all_admins of this EmailSettings.
        A flag to indicate the choice between sending alert emails to all system administrators in the system and designated list of email recipients 

        :param alert_email_to_all_admins: The alert_email_to_all_admins of this EmailSettings.
        :type: bool
        """

        self._alert_email_to_all_admins = alert_email_to_all_admins

    @property
    def alert_email_to(self):
        """
        Gets the alert_email_to of this EmailSettings.
        A comma separated email addresses to send all alert messages to 

        :return: The alert_email_to of this EmailSettings.
        :rtype: str
        """
        return self._alert_email_to

    @alert_email_to.setter
    def alert_email_to(self, alert_email_to):
        """
        Sets the alert_email_to of this EmailSettings.
        A comma separated email addresses to send all alert messages to 

        :param alert_email_to: The alert_email_to of this EmailSettings.
        :type: str
        """

        self._alert_email_to = alert_email_to

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, EmailSettings):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
