# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EgressPoint(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'vdc_ref': 'EntityReference',
        'gateway_ref': 'EntityReference',
        'network_provider_scope': 'str',
        'is_used_for_routing': 'bool',
        'status': 'VdcGroupEntityStatus',
        'error_message': 'str'
    }

    attribute_map = {
        'id': 'id',
        'vdc_ref': 'vdcRef',
        'gateway_ref': 'gatewayRef',
        'network_provider_scope': 'networkProviderScope',
        'is_used_for_routing': 'isUsedForRouting',
        'status': 'status',
        'error_message': 'errorMessage'
    }

    def __init__(self, id=None, vdc_ref=None, gateway_ref=None, network_provider_scope=None, is_used_for_routing=None, status=None, error_message=None):
        """
        EgressPoint - a model defined in Swagger
        """

        self._id = None
        self._vdc_ref = None
        self._gateway_ref = None
        self._network_provider_scope = None
        self._is_used_for_routing = None
        self._status = None
        self._error_message = None

        if id is not None:
          self.id = id
        if vdc_ref is not None:
          self.vdc_ref = vdc_ref
        if gateway_ref is not None:
          self.gateway_ref = gateway_ref
        if network_provider_scope is not None:
          self.network_provider_scope = network_provider_scope
        if is_used_for_routing is not None:
          self.is_used_for_routing = is_used_for_routing
        if status is not None:
          self.status = status
        if error_message is not None:
          self.error_message = error_message

    @property
    def id(self):
        """
        Gets the id of this EgressPoint.
        The unique ID for the Universal Egress Point (read-only).

        :return: The id of this EgressPoint.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this EgressPoint.
        The unique ID for the Universal Egress Point (read-only).

        :param id: The id of this EgressPoint.
        :type: str
        """

        self._id = id

    @property
    def vdc_ref(self):
        """
        Gets the vdc_ref of this EgressPoint.
        The Org vDC the Universal Egress Point belongs to.

        :return: The vdc_ref of this EgressPoint.
        :rtype: EntityReference
        """
        return self._vdc_ref

    @vdc_ref.setter
    def vdc_ref(self, vdc_ref):
        """
        Sets the vdc_ref of this EgressPoint.
        The Org vDC the Universal Egress Point belongs to.

        :param vdc_ref: The vdc_ref of this EgressPoint.
        :type: EntityReference
        """

        self._vdc_ref = vdc_ref

    @property
    def gateway_ref(self):
        """
        Gets the gateway_ref of this EgressPoint.
        The Edge Gateway the Egress Point is referring to.

        :return: The gateway_ref of this EgressPoint.
        :rtype: EntityReference
        """
        return self._gateway_ref

    @gateway_ref.setter
    def gateway_ref(self, gateway_ref):
        """
        Sets the gateway_ref of this EgressPoint.
        The Edge Gateway the Egress Point is referring to.

        :param gateway_ref: The gateway_ref of this EgressPoint.
        :type: EntityReference
        """

        self._gateway_ref = gateway_ref

    @property
    def network_provider_scope(self):
        """
        Gets the network_provider_scope of this EgressPoint.
        Read-only field that specifies the network provider scope of the Universal Egress Point (inherited from the Org vDC).

        :return: The network_provider_scope of this EgressPoint.
        :rtype: str
        """
        return self._network_provider_scope

    @network_provider_scope.setter
    def network_provider_scope(self, network_provider_scope):
        """
        Sets the network_provider_scope of this EgressPoint.
        Read-only field that specifies the network provider scope of the Universal Egress Point (inherited from the Org vDC).

        :param network_provider_scope: The network_provider_scope of this EgressPoint.
        :type: str
        """

        self._network_provider_scope = network_provider_scope

    @property
    def is_used_for_routing(self):
        """
        Gets the is_used_for_routing of this EgressPoint.
        Specifies whether the egress point is being used for Universal Routing. This is a read-only field.

        :return: The is_used_for_routing of this EgressPoint.
        :rtype: bool
        """
        return self._is_used_for_routing

    @is_used_for_routing.setter
    def is_used_for_routing(self, is_used_for_routing):
        """
        Sets the is_used_for_routing of this EgressPoint.
        Specifies whether the egress point is being used for Universal Routing. This is a read-only field.

        :param is_used_for_routing: The is_used_for_routing of this EgressPoint.
        :type: bool
        """

        self._is_used_for_routing = is_used_for_routing

    @property
    def status(self):
        """
        Gets the status of this EgressPoint.
        The status of the Universal Egress Point.

        :return: The status of this EgressPoint.
        :rtype: VdcGroupEntityStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this EgressPoint.
        The status of the Universal Egress Point.

        :param status: The status of this EgressPoint.
        :type: VdcGroupEntityStatus
        """

        self._status = status

    @property
    def error_message(self):
        """
        Gets the error_message of this EgressPoint.

        :return: The error_message of this EgressPoint.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """
        Sets the error_message of this EgressPoint.

        :param error_message: The error_message of this EgressPoint.
        :type: str
        """

        self._error_message = error_message

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, EgressPoint):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
