# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EdgeLoadBalancerAnalyticReport(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gateway_id': 'str',
        'component_id': 'str',
        'metric': 'str',
        'units': 'str',
        'statistics': 'EdgeLoadBalancerMetricSummaryStats',
        'data': 'list[EdgeLoadBalancerMetricData]'
    }

    attribute_map = {
        'gateway_id': 'gatewayId',
        'component_id': 'componentId',
        'metric': 'metric',
        'units': 'units',
        'statistics': 'statistics',
        'data': 'data'
    }

    def __init__(self, gateway_id=None, component_id=None, metric=None, units=None, statistics=None, data=None):
        """
        EdgeLoadBalancerAnalyticReport - a model defined in Swagger
        """

        self._gateway_id = None
        self._component_id = None
        self._metric = None
        self._units = None
        self._statistics = None
        self._data = None

        if gateway_id is not None:
          self.gateway_id = gateway_id
        if component_id is not None:
          self.component_id = component_id
        if metric is not None:
          self.metric = metric
        if units is not None:
          self.units = units
        if statistics is not None:
          self.statistics = statistics
        if data is not None:
          self.data = data

    @property
    def gateway_id(self):
        """
        Gets the gateway_id of this EdgeLoadBalancerAnalyticReport.
        The gateway URN identier.

        :return: The gateway_id of this EdgeLoadBalancerAnalyticReport.
        :rtype: str
        """
        return self._gateway_id

    @gateway_id.setter
    def gateway_id(self, gateway_id):
        """
        Sets the gateway_id of this EdgeLoadBalancerAnalyticReport.
        The gateway URN identier.

        :param gateway_id: The gateway_id of this EdgeLoadBalancerAnalyticReport.
        :type: str
        """

        self._gateway_id = gateway_id

    @property
    def component_id(self):
        """
        Gets the component_id of this EdgeLoadBalancerAnalyticReport.
        The virtual service or pool URN identifier.

        :return: The component_id of this EdgeLoadBalancerAnalyticReport.
        :rtype: str
        """
        return self._component_id

    @component_id.setter
    def component_id(self, component_id):
        """
        Sets the component_id of this EdgeLoadBalancerAnalyticReport.
        The virtual service or pool URN identifier.

        :param component_id: The component_id of this EdgeLoadBalancerAnalyticReport.
        :type: str
        """

        self._component_id = component_id

    @property
    def metric(self):
        """
        Gets the metric of this EdgeLoadBalancerAnalyticReport.
        The metric for this specific report.  Supported metrics can be determined by using the supported metrics API.

        :return: The metric of this EdgeLoadBalancerAnalyticReport.
        :rtype: str
        """
        return self._metric

    @metric.setter
    def metric(self, metric):
        """
        Sets the metric of this EdgeLoadBalancerAnalyticReport.
        The metric for this specific report.  Supported metrics can be determined by using the supported metrics API.

        :param metric: The metric of this EdgeLoadBalancerAnalyticReport.
        :type: str
        """

        self._metric = metric

    @property
    def units(self):
        """
        Gets the units of this EdgeLoadBalancerAnalyticReport.
        The units for this specific report.  Units may be one of the following <ul> <li>PER_SECOND <li>METRIC_COUNT <li>BITS_PER_SECOND <li>BYTES_PER_SECOND <li>MILLISECONDS <li>PERCENT </ul> Units are derived from the reported metric. 

        :return: The units of this EdgeLoadBalancerAnalyticReport.
        :rtype: str
        """
        return self._units

    @units.setter
    def units(self, units):
        """
        Sets the units of this EdgeLoadBalancerAnalyticReport.
        The units for this specific report.  Units may be one of the following <ul> <li>PER_SECOND <li>METRIC_COUNT <li>BITS_PER_SECOND <li>BYTES_PER_SECOND <li>MILLISECONDS <li>PERCENT </ul> Units are derived from the reported metric. 

        :param units: The units of this EdgeLoadBalancerAnalyticReport.
        :type: str
        """

        self._units = units

    @property
    def statistics(self):
        """
        Gets the statistics of this EdgeLoadBalancerAnalyticReport.

        :return: The statistics of this EdgeLoadBalancerAnalyticReport.
        :rtype: EdgeLoadBalancerMetricSummaryStats
        """
        return self._statistics

    @statistics.setter
    def statistics(self, statistics):
        """
        Sets the statistics of this EdgeLoadBalancerAnalyticReport.

        :param statistics: The statistics of this EdgeLoadBalancerAnalyticReport.
        :type: EdgeLoadBalancerMetricSummaryStats
        """

        self._statistics = statistics

    @property
    def data(self):
        """
        Gets the data of this EdgeLoadBalancerAnalyticReport.
        The metric timeseries of data for this report.

        :return: The data of this EdgeLoadBalancerAnalyticReport.
        :rtype: list[EdgeLoadBalancerMetricData]
        """
        return self._data

    @data.setter
    def data(self, data):
        """
        Sets the data of this EdgeLoadBalancerAnalyticReport.
        The metric timeseries of data for this report.

        :param data: The data of this EdgeLoadBalancerAnalyticReport.
        :type: list[EdgeLoadBalancerMetricData]
        """

        self._data = data

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, EdgeLoadBalancerAnalyticReport):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
