# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EdgeL2VpnTunnelStatistics(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'bum_bytes_in': 'int',
        'bum_bytes_out': 'int',
        'bum_packets_in': 'int',
        'bum_packets_out': 'int',
        'bytes_in': 'int',
        'bytes_out': 'int',
        'packets_in': 'int',
        'packets_out': 'int',
        'packets_receive_error': 'int',
        'packets_sent_error': 'int',
        'segment_path': 'str'
    }

    attribute_map = {
        'bum_bytes_in': 'bumBytesIn',
        'bum_bytes_out': 'bumBytesOut',
        'bum_packets_in': 'bumPacketsIn',
        'bum_packets_out': 'bumPacketsOut',
        'bytes_in': 'bytesIn',
        'bytes_out': 'bytesOut',
        'packets_in': 'packetsIn',
        'packets_out': 'packetsOut',
        'packets_receive_error': 'packetsReceiveError',
        'packets_sent_error': 'packetsSentError',
        'segment_path': 'segmentPath'
    }

    def __init__(self, bum_bytes_in=None, bum_bytes_out=None, bum_packets_in=None, bum_packets_out=None, bytes_in=None, bytes_out=None, packets_in=None, packets_out=None, packets_receive_error=None, packets_sent_error=None, segment_path=None):
        """
        EdgeL2VpnTunnelStatistics - a model defined in Swagger
        """

        self._bum_bytes_in = None
        self._bum_bytes_out = None
        self._bum_packets_in = None
        self._bum_packets_out = None
        self._bytes_in = None
        self._bytes_out = None
        self._packets_in = None
        self._packets_out = None
        self._packets_receive_error = None
        self._packets_sent_error = None
        self._segment_path = None

        if bum_bytes_in is not None:
          self.bum_bytes_in = bum_bytes_in
        if bum_bytes_out is not None:
          self.bum_bytes_out = bum_bytes_out
        if bum_packets_in is not None:
          self.bum_packets_in = bum_packets_in
        if bum_packets_out is not None:
          self.bum_packets_out = bum_packets_out
        if bytes_in is not None:
          self.bytes_in = bytes_in
        if bytes_out is not None:
          self.bytes_out = bytes_out
        if packets_in is not None:
          self.packets_in = packets_in
        if packets_out is not None:
          self.packets_out = packets_out
        if packets_receive_error is not None:
          self.packets_receive_error = packets_receive_error
        if packets_sent_error is not None:
          self.packets_sent_error = packets_sent_error
        if segment_path is not None:
          self.segment_path = segment_path

    @property
    def bum_bytes_in(self):
        """
        Gets the bum_bytes_in of this EdgeL2VpnTunnelStatistics.
        Broadcast, Unknown unicast, and Multicast (BUM) bytes in.

        :return: The bum_bytes_in of this EdgeL2VpnTunnelStatistics.
        :rtype: int
        """
        return self._bum_bytes_in

    @bum_bytes_in.setter
    def bum_bytes_in(self, bum_bytes_in):
        """
        Sets the bum_bytes_in of this EdgeL2VpnTunnelStatistics.
        Broadcast, Unknown unicast, and Multicast (BUM) bytes in.

        :param bum_bytes_in: The bum_bytes_in of this EdgeL2VpnTunnelStatistics.
        :type: int
        """

        self._bum_bytes_in = bum_bytes_in

    @property
    def bum_bytes_out(self):
        """
        Gets the bum_bytes_out of this EdgeL2VpnTunnelStatistics.
        Broadcast, Unknown unicast, and Multicast (BUM) bytes out.

        :return: The bum_bytes_out of this EdgeL2VpnTunnelStatistics.
        :rtype: int
        """
        return self._bum_bytes_out

    @bum_bytes_out.setter
    def bum_bytes_out(self, bum_bytes_out):
        """
        Sets the bum_bytes_out of this EdgeL2VpnTunnelStatistics.
        Broadcast, Unknown unicast, and Multicast (BUM) bytes out.

        :param bum_bytes_out: The bum_bytes_out of this EdgeL2VpnTunnelStatistics.
        :type: int
        """

        self._bum_bytes_out = bum_bytes_out

    @property
    def bum_packets_in(self):
        """
        Gets the bum_packets_in of this EdgeL2VpnTunnelStatistics.
        Broadcast, Unknown unicast, and Multicast (BUM) packets in.

        :return: The bum_packets_in of this EdgeL2VpnTunnelStatistics.
        :rtype: int
        """
        return self._bum_packets_in

    @bum_packets_in.setter
    def bum_packets_in(self, bum_packets_in):
        """
        Sets the bum_packets_in of this EdgeL2VpnTunnelStatistics.
        Broadcast, Unknown unicast, and Multicast (BUM) packets in.

        :param bum_packets_in: The bum_packets_in of this EdgeL2VpnTunnelStatistics.
        :type: int
        """

        self._bum_packets_in = bum_packets_in

    @property
    def bum_packets_out(self):
        """
        Gets the bum_packets_out of this EdgeL2VpnTunnelStatistics.
        Broadcast, Unknown unicast, and Multicast (BUM) packets out.

        :return: The bum_packets_out of this EdgeL2VpnTunnelStatistics.
        :rtype: int
        """
        return self._bum_packets_out

    @bum_packets_out.setter
    def bum_packets_out(self, bum_packets_out):
        """
        Sets the bum_packets_out of this EdgeL2VpnTunnelStatistics.
        Broadcast, Unknown unicast, and Multicast (BUM) packets out.

        :param bum_packets_out: The bum_packets_out of this EdgeL2VpnTunnelStatistics.
        :type: int
        """

        self._bum_packets_out = bum_packets_out

    @property
    def bytes_in(self):
        """
        Gets the bytes_in of this EdgeL2VpnTunnelStatistics.
        Total number of incoming bytes.

        :return: The bytes_in of this EdgeL2VpnTunnelStatistics.
        :rtype: int
        """
        return self._bytes_in

    @bytes_in.setter
    def bytes_in(self, bytes_in):
        """
        Sets the bytes_in of this EdgeL2VpnTunnelStatistics.
        Total number of incoming bytes.

        :param bytes_in: The bytes_in of this EdgeL2VpnTunnelStatistics.
        :type: int
        """

        self._bytes_in = bytes_in

    @property
    def bytes_out(self):
        """
        Gets the bytes_out of this EdgeL2VpnTunnelStatistics.
        Total number of outgoing bytes.

        :return: The bytes_out of this EdgeL2VpnTunnelStatistics.
        :rtype: int
        """
        return self._bytes_out

    @bytes_out.setter
    def bytes_out(self, bytes_out):
        """
        Sets the bytes_out of this EdgeL2VpnTunnelStatistics.
        Total number of outgoing bytes.

        :param bytes_out: The bytes_out of this EdgeL2VpnTunnelStatistics.
        :type: int
        """

        self._bytes_out = bytes_out

    @property
    def packets_in(self):
        """
        Gets the packets_in of this EdgeL2VpnTunnelStatistics.
        Total number of incoming packets.

        :return: The packets_in of this EdgeL2VpnTunnelStatistics.
        :rtype: int
        """
        return self._packets_in

    @packets_in.setter
    def packets_in(self, packets_in):
        """
        Sets the packets_in of this EdgeL2VpnTunnelStatistics.
        Total number of incoming packets.

        :param packets_in: The packets_in of this EdgeL2VpnTunnelStatistics.
        :type: int
        """

        self._packets_in = packets_in

    @property
    def packets_out(self):
        """
        Gets the packets_out of this EdgeL2VpnTunnelStatistics.
        Total number of outgoing packets.

        :return: The packets_out of this EdgeL2VpnTunnelStatistics.
        :rtype: int
        """
        return self._packets_out

    @packets_out.setter
    def packets_out(self, packets_out):
        """
        Sets the packets_out of this EdgeL2VpnTunnelStatistics.
        Total number of outgoing packets.

        :param packets_out: The packets_out of this EdgeL2VpnTunnelStatistics.
        :type: int
        """

        self._packets_out = packets_out

    @property
    def packets_receive_error(self):
        """
        Gets the packets_receive_error of this EdgeL2VpnTunnelStatistics.
        Total number of incoming packets dropped.

        :return: The packets_receive_error of this EdgeL2VpnTunnelStatistics.
        :rtype: int
        """
        return self._packets_receive_error

    @packets_receive_error.setter
    def packets_receive_error(self, packets_receive_error):
        """
        Sets the packets_receive_error of this EdgeL2VpnTunnelStatistics.
        Total number of incoming packets dropped.

        :param packets_receive_error: The packets_receive_error of this EdgeL2VpnTunnelStatistics.
        :type: int
        """

        self._packets_receive_error = packets_receive_error

    @property
    def packets_sent_error(self):
        """
        Gets the packets_sent_error of this EdgeL2VpnTunnelStatistics.
        Total number of packets dropped while sending for any reason.

        :return: The packets_sent_error of this EdgeL2VpnTunnelStatistics.
        :rtype: int
        """
        return self._packets_sent_error

    @packets_sent_error.setter
    def packets_sent_error(self, packets_sent_error):
        """
        Sets the packets_sent_error of this EdgeL2VpnTunnelStatistics.
        Total number of packets dropped while sending for any reason.

        :param packets_sent_error: The packets_sent_error of this EdgeL2VpnTunnelStatistics.
        :type: int
        """

        self._packets_sent_error = packets_sent_error

    @property
    def segment_path(self):
        """
        Gets the segment_path of this EdgeL2VpnTunnelStatistics.
        Policy path referencing the segment on which stats are gathered.

        :return: The segment_path of this EdgeL2VpnTunnelStatistics.
        :rtype: str
        """
        return self._segment_path

    @segment_path.setter
    def segment_path(self, segment_path):
        """
        Sets the segment_path of this EdgeL2VpnTunnelStatistics.
        Policy path referencing the segment on which stats are gathered.

        :param segment_path: The segment_path of this EdgeL2VpnTunnelStatistics.
        :type: str
        """

        self._segment_path = segment_path

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, EdgeL2VpnTunnelStatistics):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
