# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EdgeIpSecVpnTunnelStatistics(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'local_subnet': 'str',
        'peer_subnet': 'str',
        'packets_in': 'int',
        'packets_out': 'int',
        'bytes_in': 'int',
        'bytes_out': 'int',
        'packets_sent_error': 'int',
        'packets_received_error': 'int',
        'packets_in_dropped': 'int',
        'packets_out_dropped': 'int',
        'encryption_errors': 'int',
        'decryption_errors': 'int',
        'overflow_errors': 'int',
        'replay_errors': 'int',
        'integrity_errors': 'int',
        'sa_mismatch_in_errors': 'int',
        'sa_mismatch_out_errors': 'int',
        'no_matching_policy_errors': 'int'
    }

    attribute_map = {
        'local_subnet': 'localSubnet',
        'peer_subnet': 'peerSubnet',
        'packets_in': 'packetsIn',
        'packets_out': 'packetsOut',
        'bytes_in': 'bytesIn',
        'bytes_out': 'bytesOut',
        'packets_sent_error': 'packetsSentError',
        'packets_received_error': 'packetsReceivedError',
        'packets_in_dropped': 'packetsInDropped',
        'packets_out_dropped': 'packetsOutDropped',
        'encryption_errors': 'encryptionErrors',
        'decryption_errors': 'decryptionErrors',
        'overflow_errors': 'overflowErrors',
        'replay_errors': 'replayErrors',
        'integrity_errors': 'integrityErrors',
        'sa_mismatch_in_errors': 'saMismatchInErrors',
        'sa_mismatch_out_errors': 'saMismatchOutErrors',
        'no_matching_policy_errors': 'noMatchingPolicyErrors'
    }

    def __init__(self, local_subnet=None, peer_subnet=None, packets_in=None, packets_out=None, bytes_in=None, bytes_out=None, packets_sent_error=None, packets_received_error=None, packets_in_dropped=None, packets_out_dropped=None, encryption_errors=None, decryption_errors=None, overflow_errors=None, replay_errors=None, integrity_errors=None, sa_mismatch_in_errors=None, sa_mismatch_out_errors=None, no_matching_policy_errors=None):
        """
        EdgeIpSecVpnTunnelStatistics - a model defined in Swagger
        """

        self._local_subnet = None
        self._peer_subnet = None
        self._packets_in = None
        self._packets_out = None
        self._bytes_in = None
        self._bytes_out = None
        self._packets_sent_error = None
        self._packets_received_error = None
        self._packets_in_dropped = None
        self._packets_out_dropped = None
        self._encryption_errors = None
        self._decryption_errors = None
        self._overflow_errors = None
        self._replay_errors = None
        self._integrity_errors = None
        self._sa_mismatch_in_errors = None
        self._sa_mismatch_out_errors = None
        self._no_matching_policy_errors = None

        if local_subnet is not None:
          self.local_subnet = local_subnet
        if peer_subnet is not None:
          self.peer_subnet = peer_subnet
        if packets_in is not None:
          self.packets_in = packets_in
        if packets_out is not None:
          self.packets_out = packets_out
        if bytes_in is not None:
          self.bytes_in = bytes_in
        if bytes_out is not None:
          self.bytes_out = bytes_out
        if packets_sent_error is not None:
          self.packets_sent_error = packets_sent_error
        if packets_received_error is not None:
          self.packets_received_error = packets_received_error
        if packets_in_dropped is not None:
          self.packets_in_dropped = packets_in_dropped
        if packets_out_dropped is not None:
          self.packets_out_dropped = packets_out_dropped
        if encryption_errors is not None:
          self.encryption_errors = encryption_errors
        if decryption_errors is not None:
          self.decryption_errors = decryption_errors
        if overflow_errors is not None:
          self.overflow_errors = overflow_errors
        if replay_errors is not None:
          self.replay_errors = replay_errors
        if integrity_errors is not None:
          self.integrity_errors = integrity_errors
        if sa_mismatch_in_errors is not None:
          self.sa_mismatch_in_errors = sa_mismatch_in_errors
        if sa_mismatch_out_errors is not None:
          self.sa_mismatch_out_errors = sa_mismatch_out_errors
        if no_matching_policy_errors is not None:
          self.no_matching_policy_errors = no_matching_policy_errors

    @property
    def local_subnet(self):
        """
        Gets the local_subnet of this EdgeIpSecVpnTunnelStatistics.
        Local subnet to which a tunnel belongs.

        :return: The local_subnet of this EdgeIpSecVpnTunnelStatistics.
        :rtype: str
        """
        return self._local_subnet

    @local_subnet.setter
    def local_subnet(self, local_subnet):
        """
        Sets the local_subnet of this EdgeIpSecVpnTunnelStatistics.
        Local subnet to which a tunnel belongs.

        :param local_subnet: The local_subnet of this EdgeIpSecVpnTunnelStatistics.
        :type: str
        """

        self._local_subnet = local_subnet

    @property
    def peer_subnet(self):
        """
        Gets the peer_subnet of this EdgeIpSecVpnTunnelStatistics.
        Peer subnet to which a tunnel belongs.

        :return: The peer_subnet of this EdgeIpSecVpnTunnelStatistics.
        :rtype: str
        """
        return self._peer_subnet

    @peer_subnet.setter
    def peer_subnet(self, peer_subnet):
        """
        Sets the peer_subnet of this EdgeIpSecVpnTunnelStatistics.
        Peer subnet to which a tunnel belongs.

        :param peer_subnet: The peer_subnet of this EdgeIpSecVpnTunnelStatistics.
        :type: str
        """

        self._peer_subnet = peer_subnet

    @property
    def packets_in(self):
        """
        Gets the packets_in of this EdgeIpSecVpnTunnelStatistics.
        Number of packets received.

        :return: The packets_in of this EdgeIpSecVpnTunnelStatistics.
        :rtype: int
        """
        return self._packets_in

    @packets_in.setter
    def packets_in(self, packets_in):
        """
        Sets the packets_in of this EdgeIpSecVpnTunnelStatistics.
        Number of packets received.

        :param packets_in: The packets_in of this EdgeIpSecVpnTunnelStatistics.
        :type: int
        """

        self._packets_in = packets_in

    @property
    def packets_out(self):
        """
        Gets the packets_out of this EdgeIpSecVpnTunnelStatistics.
        Number of packets sent.

        :return: The packets_out of this EdgeIpSecVpnTunnelStatistics.
        :rtype: int
        """
        return self._packets_out

    @packets_out.setter
    def packets_out(self, packets_out):
        """
        Sets the packets_out of this EdgeIpSecVpnTunnelStatistics.
        Number of packets sent.

        :param packets_out: The packets_out of this EdgeIpSecVpnTunnelStatistics.
        :type: int
        """

        self._packets_out = packets_out

    @property
    def bytes_in(self):
        """
        Gets the bytes_in of this EdgeIpSecVpnTunnelStatistics.
        Number of bytes received.

        :return: The bytes_in of this EdgeIpSecVpnTunnelStatistics.
        :rtype: int
        """
        return self._bytes_in

    @bytes_in.setter
    def bytes_in(self, bytes_in):
        """
        Sets the bytes_in of this EdgeIpSecVpnTunnelStatistics.
        Number of bytes received.

        :param bytes_in: The bytes_in of this EdgeIpSecVpnTunnelStatistics.
        :type: int
        """

        self._bytes_in = bytes_in

    @property
    def bytes_out(self):
        """
        Gets the bytes_out of this EdgeIpSecVpnTunnelStatistics.
        Number of bytes sent.

        :return: The bytes_out of this EdgeIpSecVpnTunnelStatistics.
        :rtype: int
        """
        return self._bytes_out

    @bytes_out.setter
    def bytes_out(self, bytes_out):
        """
        Sets the bytes_out of this EdgeIpSecVpnTunnelStatistics.
        Number of bytes sent.

        :param bytes_out: The bytes_out of this EdgeIpSecVpnTunnelStatistics.
        :type: int
        """

        self._bytes_out = bytes_out

    @property
    def packets_sent_error(self):
        """
        Gets the packets_sent_error of this EdgeIpSecVpnTunnelStatistics.
        Number of packets sent with errors.

        :return: The packets_sent_error of this EdgeIpSecVpnTunnelStatistics.
        :rtype: int
        """
        return self._packets_sent_error

    @packets_sent_error.setter
    def packets_sent_error(self, packets_sent_error):
        """
        Sets the packets_sent_error of this EdgeIpSecVpnTunnelStatistics.
        Number of packets sent with errors.

        :param packets_sent_error: The packets_sent_error of this EdgeIpSecVpnTunnelStatistics.
        :type: int
        """

        self._packets_sent_error = packets_sent_error

    @property
    def packets_received_error(self):
        """
        Gets the packets_received_error of this EdgeIpSecVpnTunnelStatistics.
        Number of packets reveived with errors.

        :return: The packets_received_error of this EdgeIpSecVpnTunnelStatistics.
        :rtype: int
        """
        return self._packets_received_error

    @packets_received_error.setter
    def packets_received_error(self, packets_received_error):
        """
        Sets the packets_received_error of this EdgeIpSecVpnTunnelStatistics.
        Number of packets reveived with errors.

        :param packets_received_error: The packets_received_error of this EdgeIpSecVpnTunnelStatistics.
        :type: int
        """

        self._packets_received_error = packets_received_error

    @property
    def packets_in_dropped(self):
        """
        Gets the packets_in_dropped of this EdgeIpSecVpnTunnelStatistics.
        Number of packets dropped while receiving.

        :return: The packets_in_dropped of this EdgeIpSecVpnTunnelStatistics.
        :rtype: int
        """
        return self._packets_in_dropped

    @packets_in_dropped.setter
    def packets_in_dropped(self, packets_in_dropped):
        """
        Sets the packets_in_dropped of this EdgeIpSecVpnTunnelStatistics.
        Number of packets dropped while receiving.

        :param packets_in_dropped: The packets_in_dropped of this EdgeIpSecVpnTunnelStatistics.
        :type: int
        """

        self._packets_in_dropped = packets_in_dropped

    @property
    def packets_out_dropped(self):
        """
        Gets the packets_out_dropped of this EdgeIpSecVpnTunnelStatistics.
        Number of packets dropped while sending.

        :return: The packets_out_dropped of this EdgeIpSecVpnTunnelStatistics.
        :rtype: int
        """
        return self._packets_out_dropped

    @packets_out_dropped.setter
    def packets_out_dropped(self, packets_out_dropped):
        """
        Sets the packets_out_dropped of this EdgeIpSecVpnTunnelStatistics.
        Number of packets dropped while sending.

        :param packets_out_dropped: The packets_out_dropped of this EdgeIpSecVpnTunnelStatistics.
        :type: int
        """

        self._packets_out_dropped = packets_out_dropped

    @property
    def encryption_errors(self):
        """
        Gets the encryption_errors of this EdgeIpSecVpnTunnelStatistics.
        Number of encryption errors.

        :return: The encryption_errors of this EdgeIpSecVpnTunnelStatistics.
        :rtype: int
        """
        return self._encryption_errors

    @encryption_errors.setter
    def encryption_errors(self, encryption_errors):
        """
        Sets the encryption_errors of this EdgeIpSecVpnTunnelStatistics.
        Number of encryption errors.

        :param encryption_errors: The encryption_errors of this EdgeIpSecVpnTunnelStatistics.
        :type: int
        """

        self._encryption_errors = encryption_errors

    @property
    def decryption_errors(self):
        """
        Gets the decryption_errors of this EdgeIpSecVpnTunnelStatistics.
        Number of decryption errors.

        :return: The decryption_errors of this EdgeIpSecVpnTunnelStatistics.
        :rtype: int
        """
        return self._decryption_errors

    @decryption_errors.setter
    def decryption_errors(self, decryption_errors):
        """
        Sets the decryption_errors of this EdgeIpSecVpnTunnelStatistics.
        Number of decryption errors.

        :param decryption_errors: The decryption_errors of this EdgeIpSecVpnTunnelStatistics.
        :type: int
        """

        self._decryption_errors = decryption_errors

    @property
    def overflow_errors(self):
        """
        Gets the overflow_errors of this EdgeIpSecVpnTunnelStatistics.
        Number of errors due to overflow.

        :return: The overflow_errors of this EdgeIpSecVpnTunnelStatistics.
        :rtype: int
        """
        return self._overflow_errors

    @overflow_errors.setter
    def overflow_errors(self, overflow_errors):
        """
        Sets the overflow_errors of this EdgeIpSecVpnTunnelStatistics.
        Number of errors due to overflow.

        :param overflow_errors: The overflow_errors of this EdgeIpSecVpnTunnelStatistics.
        :type: int
        """

        self._overflow_errors = overflow_errors

    @property
    def replay_errors(self):
        """
        Gets the replay_errors of this EdgeIpSecVpnTunnelStatistics.
        Number of replay errors.

        :return: The replay_errors of this EdgeIpSecVpnTunnelStatistics.
        :rtype: int
        """
        return self._replay_errors

    @replay_errors.setter
    def replay_errors(self, replay_errors):
        """
        Sets the replay_errors of this EdgeIpSecVpnTunnelStatistics.
        Number of replay errors.

        :param replay_errors: The replay_errors of this EdgeIpSecVpnTunnelStatistics.
        :type: int
        """

        self._replay_errors = replay_errors

    @property
    def integrity_errors(self):
        """
        Gets the integrity_errors of this EdgeIpSecVpnTunnelStatistics.
        Number of integrity check errors.

        :return: The integrity_errors of this EdgeIpSecVpnTunnelStatistics.
        :rtype: int
        """
        return self._integrity_errors

    @integrity_errors.setter
    def integrity_errors(self, integrity_errors):
        """
        Sets the integrity_errors of this EdgeIpSecVpnTunnelStatistics.
        Number of integrity check errors.

        :param integrity_errors: The integrity_errors of this EdgeIpSecVpnTunnelStatistics.
        :type: int
        """

        self._integrity_errors = integrity_errors

    @property
    def sa_mismatch_in_errors(self):
        """
        Gets the sa_mismatch_in_errors of this EdgeIpSecVpnTunnelStatistics.
        Number of SA mismatch errors while receiving.

        :return: The sa_mismatch_in_errors of this EdgeIpSecVpnTunnelStatistics.
        :rtype: int
        """
        return self._sa_mismatch_in_errors

    @sa_mismatch_in_errors.setter
    def sa_mismatch_in_errors(self, sa_mismatch_in_errors):
        """
        Sets the sa_mismatch_in_errors of this EdgeIpSecVpnTunnelStatistics.
        Number of SA mismatch errors while receiving.

        :param sa_mismatch_in_errors: The sa_mismatch_in_errors of this EdgeIpSecVpnTunnelStatistics.
        :type: int
        """

        self._sa_mismatch_in_errors = sa_mismatch_in_errors

    @property
    def sa_mismatch_out_errors(self):
        """
        Gets the sa_mismatch_out_errors of this EdgeIpSecVpnTunnelStatistics.
        Number of SA mismatch errors while sending.

        :return: The sa_mismatch_out_errors of this EdgeIpSecVpnTunnelStatistics.
        :rtype: int
        """
        return self._sa_mismatch_out_errors

    @sa_mismatch_out_errors.setter
    def sa_mismatch_out_errors(self, sa_mismatch_out_errors):
        """
        Sets the sa_mismatch_out_errors of this EdgeIpSecVpnTunnelStatistics.
        Number of SA mismatch errors while sending.

        :param sa_mismatch_out_errors: The sa_mismatch_out_errors of this EdgeIpSecVpnTunnelStatistics.
        :type: int
        """

        self._sa_mismatch_out_errors = sa_mismatch_out_errors

    @property
    def no_matching_policy_errors(self):
        """
        Gets the no_matching_policy_errors of this EdgeIpSecVpnTunnelStatistics.
        Number of packets dropped because of no matching policy is available.

        :return: The no_matching_policy_errors of this EdgeIpSecVpnTunnelStatistics.
        :rtype: int
        """
        return self._no_matching_policy_errors

    @no_matching_policy_errors.setter
    def no_matching_policy_errors(self, no_matching_policy_errors):
        """
        Sets the no_matching_policy_errors of this EdgeIpSecVpnTunnelStatistics.
        Number of packets dropped because of no matching policy is available.

        :param no_matching_policy_errors: The no_matching_policy_errors of this EdgeIpSecVpnTunnelStatistics.
        :type: int
        """

        self._no_matching_policy_errors = no_matching_policy_errors

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, EdgeIpSecVpnTunnelStatistics):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
