# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EdgeIpSecVpnTunnelConnectionProperties(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'security_type': 'str',
        'ike_configuration': 'IkeConfig',
        'tunnel_configuration': 'TunnelConfig',
        'dpd_configuration': 'DpdConfig'
    }

    attribute_map = {
        'security_type': 'securityType',
        'ike_configuration': 'ikeConfiguration',
        'tunnel_configuration': 'tunnelConfiguration',
        'dpd_configuration': 'dpdConfiguration'
    }

    def __init__(self, security_type='DEFAULT', ike_configuration=None, tunnel_configuration=None, dpd_configuration=None):
        """
        EdgeIpSecVpnTunnelConnectionProperties - a model defined in Swagger
        """

        self._security_type = None
        self._ike_configuration = None
        self._tunnel_configuration = None
        self._dpd_configuration = None

        if security_type is not None:
          self.security_type = security_type
        if ike_configuration is not None:
          self.ike_configuration = ike_configuration
        if tunnel_configuration is not None:
          self.tunnel_configuration = tunnel_configuration
        if dpd_configuration is not None:
          self.dpd_configuration = dpd_configuration

    @property
    def security_type(self):
        """
        Gets the security_type of this EdgeIpSecVpnTunnelConnectionProperties.
        This is the security type used for the IPSec Tunnel. If nothing is specified, this will be set to 'DEFAULT' in which the default settings in NSX will be used. If 'CUSTOM' is specified, then ike, tunnel, and dpd configurations can be set. 

        :return: The security_type of this EdgeIpSecVpnTunnelConnectionProperties.
        :rtype: str
        """
        return self._security_type

    @security_type.setter
    def security_type(self, security_type):
        """
        Sets the security_type of this EdgeIpSecVpnTunnelConnectionProperties.
        This is the security type used for the IPSec Tunnel. If nothing is specified, this will be set to 'DEFAULT' in which the default settings in NSX will be used. If 'CUSTOM' is specified, then ike, tunnel, and dpd configurations can be set. 

        :param security_type: The security_type of this EdgeIpSecVpnTunnelConnectionProperties.
        :type: str
        """

        self._security_type = security_type

    @property
    def ike_configuration(self):
        """
        Gets the ike_configuration of this EdgeIpSecVpnTunnelConnectionProperties.
        The IKE Configuration to be used for the tunnel. If nothing is explictly set, the system defaults will be used. 

        :return: The ike_configuration of this EdgeIpSecVpnTunnelConnectionProperties.
        :rtype: IkeConfig
        """
        return self._ike_configuration

    @ike_configuration.setter
    def ike_configuration(self, ike_configuration):
        """
        Sets the ike_configuration of this EdgeIpSecVpnTunnelConnectionProperties.
        The IKE Configuration to be used for the tunnel. If nothing is explictly set, the system defaults will be used. 

        :param ike_configuration: The ike_configuration of this EdgeIpSecVpnTunnelConnectionProperties.
        :type: IkeConfig
        """

        self._ike_configuration = ike_configuration

    @property
    def tunnel_configuration(self):
        """
        Gets the tunnel_configuration of this EdgeIpSecVpnTunnelConnectionProperties.
        The Tunnel Configuration, which contains parameters such as encryption algorithm to be used. If nothing is explicitly set, the system defaults will be used. 

        :return: The tunnel_configuration of this EdgeIpSecVpnTunnelConnectionProperties.
        :rtype: TunnelConfig
        """
        return self._tunnel_configuration

    @tunnel_configuration.setter
    def tunnel_configuration(self, tunnel_configuration):
        """
        Sets the tunnel_configuration of this EdgeIpSecVpnTunnelConnectionProperties.
        The Tunnel Configuration, which contains parameters such as encryption algorithm to be used. If nothing is explicitly set, the system defaults will be used. 

        :param tunnel_configuration: The tunnel_configuration of this EdgeIpSecVpnTunnelConnectionProperties.
        :type: TunnelConfig
        """

        self._tunnel_configuration = tunnel_configuration

    @property
    def dpd_configuration(self):
        """
        Gets the dpd_configuration of this EdgeIpSecVpnTunnelConnectionProperties.
        The Dead Peer Detection configuration. If nothing is explictly set, the system defaults will be used. 

        :return: The dpd_configuration of this EdgeIpSecVpnTunnelConnectionProperties.
        :rtype: DpdConfig
        """
        return self._dpd_configuration

    @dpd_configuration.setter
    def dpd_configuration(self, dpd_configuration):
        """
        Sets the dpd_configuration of this EdgeIpSecVpnTunnelConnectionProperties.
        The Dead Peer Detection configuration. If nothing is explictly set, the system defaults will be used. 

        :param dpd_configuration: The dpd_configuration of this EdgeIpSecVpnTunnelConnectionProperties.
        :type: DpdConfig
        """

        self._dpd_configuration = dpd_configuration

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, EdgeIpSecVpnTunnelConnectionProperties):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
