# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EdgeGatewayUplink(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'uplink_id': 'str',
        'uplink_name': 'str',
        'subnets': 'EdgeGatewaySubnets',
        'connected': 'bool',
        'quick_add_allocated_ip_count': 'int',
        'dedicated': 'bool',
        'vrf_lite_backed': 'bool'
    }

    attribute_map = {
        'uplink_id': 'uplinkId',
        'uplink_name': 'uplinkName',
        'subnets': 'subnets',
        'connected': 'connected',
        'quick_add_allocated_ip_count': 'quickAddAllocatedIpCount',
        'dedicated': 'dedicated',
        'vrf_lite_backed': 'vrfLiteBacked'
    }

    def __init__(self, uplink_id=None, uplink_name=None, subnets=None, connected=True, quick_add_allocated_ip_count=None, dedicated=False, vrf_lite_backed=None):
        """
        EdgeGatewayUplink - a model defined in Swagger
        """

        self._uplink_id = None
        self._uplink_name = None
        self._subnets = None
        self._connected = None
        self._quick_add_allocated_ip_count = None
        self._dedicated = None
        self._vrf_lite_backed = None

        if uplink_id is not None:
          self.uplink_id = uplink_id
        if uplink_name is not None:
          self.uplink_name = uplink_name
        if subnets is not None:
          self.subnets = subnets
        if connected is not None:
          self.connected = connected
        if quick_add_allocated_ip_count is not None:
          self.quick_add_allocated_ip_count = quick_add_allocated_ip_count
        if dedicated is not None:
          self.dedicated = dedicated
        if vrf_lite_backed is not None:
          self.vrf_lite_backed = vrf_lite_backed

    @property
    def uplink_id(self):
        """
        Gets the uplink_id of this EdgeGatewayUplink.
        The identifier of the external network this edge gateway is connected to.

        :return: The uplink_id of this EdgeGatewayUplink.
        :rtype: str
        """
        return self._uplink_id

    @uplink_id.setter
    def uplink_id(self, uplink_id):
        """
        Sets the uplink_id of this EdgeGatewayUplink.
        The identifier of the external network this edge gateway is connected to.

        :param uplink_id: The uplink_id of this EdgeGatewayUplink.
        :type: str
        """

        self._uplink_id = uplink_id

    @property
    def uplink_name(self):
        """
        Gets the uplink_name of this EdgeGatewayUplink.
        The name of the external network this edge gateway is connected to.

        :return: The uplink_name of this EdgeGatewayUplink.
        :rtype: str
        """
        return self._uplink_name

    @uplink_name.setter
    def uplink_name(self, uplink_name):
        """
        Sets the uplink_name of this EdgeGatewayUplink.
        The name of the external network this edge gateway is connected to.

        :param uplink_name: The uplink_name of this EdgeGatewayUplink.
        :type: str
        """

        self._uplink_name = uplink_name

    @property
    def subnets(self):
        """
        Gets the subnets of this EdgeGatewayUplink.
        Set of subnets this edge will have access to. 

        :return: The subnets of this EdgeGatewayUplink.
        :rtype: EdgeGatewaySubnets
        """
        return self._subnets

    @subnets.setter
    def subnets(self, subnets):
        """
        Sets the subnets of this EdgeGatewayUplink.
        Set of subnets this edge will have access to. 

        :param subnets: The subnets of this EdgeGatewayUplink.
        :type: EdgeGatewaySubnets
        """

        self._subnets = subnets

    @property
    def connected(self):
        """
        Gets the connected of this EdgeGatewayUplink.
        Whether or not the gateway is connected to this uplink. This value defaults to true if it is not set. When filtering by this field, if the filter is false, all gateways that have 0 connected uplinks will be returned, while if it is true, all gateways with at least one connected uplink will be returned.

        :return: The connected of this EdgeGatewayUplink.
        :rtype: bool
        """
        return self._connected

    @connected.setter
    def connected(self, connected):
        """
        Sets the connected of this EdgeGatewayUplink.
        Whether or not the gateway is connected to this uplink. This value defaults to true if it is not set. When filtering by this field, if the filter is false, all gateways that have 0 connected uplinks will be returned, while if it is true, all gateways with at least one connected uplink will be returned.

        :param connected: The connected of this EdgeGatewayUplink.
        :type: bool
        """

        self._connected = connected

    @property
    def quick_add_allocated_ip_count(self):
        """
        Gets the quick_add_allocated_ip_count of this EdgeGatewayUplink.
        If set on create or update api calls, the specified number of IP addresses will be additionally allocated for this uplink. IPs will be allocated from multiple subnets if needed.

        :return: The quick_add_allocated_ip_count of this EdgeGatewayUplink.
        :rtype: int
        """
        return self._quick_add_allocated_ip_count

    @quick_add_allocated_ip_count.setter
    def quick_add_allocated_ip_count(self, quick_add_allocated_ip_count):
        """
        Sets the quick_add_allocated_ip_count of this EdgeGatewayUplink.
        If set on create or update api calls, the specified number of IP addresses will be additionally allocated for this uplink. IPs will be allocated from multiple subnets if needed.

        :param quick_add_allocated_ip_count: The quick_add_allocated_ip_count of this EdgeGatewayUplink.
        :type: int
        """

        self._quick_add_allocated_ip_count = quick_add_allocated_ip_count

    @property
    def dedicated(self):
        """
        Gets the dedicated of this EdgeGatewayUplink.
        If set to true, then the associated external network is exclusively used by this edge gateway.

        :return: The dedicated of this EdgeGatewayUplink.
        :rtype: bool
        """
        return self._dedicated

    @dedicated.setter
    def dedicated(self, dedicated):
        """
        Sets the dedicated of this EdgeGatewayUplink.
        If set to true, then the associated external network is exclusively used by this edge gateway.

        :param dedicated: The dedicated of this EdgeGatewayUplink.
        :type: bool
        """

        self._dedicated = dedicated

    @property
    def vrf_lite_backed(self):
        """
        Gets the vrf_lite_backed of this EdgeGatewayUplink.
        Whether the associated external network is backed by a NSX-T VRF-Lite Tier-0.

        :return: The vrf_lite_backed of this EdgeGatewayUplink.
        :rtype: bool
        """
        return self._vrf_lite_backed

    @vrf_lite_backed.setter
    def vrf_lite_backed(self, vrf_lite_backed):
        """
        Sets the vrf_lite_backed of this EdgeGatewayUplink.
        Whether the associated external network is backed by a NSX-T VRF-Lite Tier-0.

        :param vrf_lite_backed: The vrf_lite_backed of this EdgeGatewayUplink.
        :type: bool
        """

        self._vrf_lite_backed = vrf_lite_backed

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, EdgeGatewayUplink):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
