# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class VroWorkflowPresentationApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_workflow_presenation_instance(self, workflow_id, presentation_execution_id, **kwargs):
        """
        Delete workflow presentation execution
        Cancels the execution of a workflow presentation instance. This API call cancels only the workflow presentation execution. To cancel the workflow execution, use APIs under <b>/cloudapi/workflows/{workflowId}/instances</b>.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workflow_presenation_instance(workflow_id, presentation_execution_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :param str presentation_execution_id: presentationExecutionId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_workflow_presenation_instance_with_http_info(workflow_id, presentation_execution_id, **kwargs)
        else:
            (data) = self.delete_workflow_presenation_instance_with_http_info(workflow_id, presentation_execution_id, **kwargs)
            return data

    def delete_workflow_presenation_instance_with_http_info(self, workflow_id, presentation_execution_id, **kwargs):
        """
        Delete workflow presentation execution
        Cancels the execution of a workflow presentation instance. This API call cancels only the workflow presentation execution. To cancel the workflow execution, use APIs under <b>/cloudapi/workflows/{workflowId}/instances</b>.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workflow_presenation_instance_with_http_info(workflow_id, presentation_execution_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :param str presentation_execution_id: presentationExecutionId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'presentation_execution_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workflow_presenation_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params) or (params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `delete_workflow_presenation_instance`")
        # verify the required parameter 'presentation_execution_id' is set
        if ('presentation_execution_id' not in params) or (params['presentation_execution_id'] is None):
            raise ValueError("Missing the required parameter `presentation_execution_id` when calling `delete_workflow_presenation_instance`")


        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']
        if 'presentation_execution_id' in params:
            path_params['presentationExecutionId'] = params['presentation_execution_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/workflows/{workflowId}/presentation/instances/{presentationExecutionId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_all_workflow_presentation_instances(self, workflow_id, **kwargs):
        """
        Get all presentations
        Retrieves a list of the presentation instances for a workflow that you specify. To retrieve the list of workflow presentations, make an HTTP GET request at the workflow presentations list URL. The returned list contains all of the currently running workflow presentation instances, and all completed instances based on the data from the workflow executions. If the user has admin rights, all presentation instances for all users are returned.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_all_workflow_presentation_instances(workflow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :return: PresentationExecutionsList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_all_workflow_presentation_instances_with_http_info(workflow_id, **kwargs)
        else:
            (data) = self.get_all_workflow_presentation_instances_with_http_info(workflow_id, **kwargs)
            return data

    def get_all_workflow_presentation_instances_with_http_info(self, workflow_id, **kwargs):
        """
        Get all presentations
        Retrieves a list of the presentation instances for a workflow that you specify. To retrieve the list of workflow presentations, make an HTTP GET request at the workflow presentations list URL. The returned list contains all of the currently running workflow presentation instances, and all completed instances based on the data from the workflow executions. If the user has admin rights, all presentation instances for all users are returned.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_all_workflow_presentation_instances_with_http_info(workflow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :return: PresentationExecutionsList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_workflow_presentation_instances" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params) or (params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `get_all_workflow_presentation_instances`")


        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/workflows/{workflowId}/presentation/instances', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PresentationExecutionsList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_workflow_presentation(self, workflow_id, **kwargs):
        """
        Get presentation
        Retrieves the definition of a workflow presentation. To retrieve the workflow presentation definition localized, add Accept-Language header, with the appropriate locale. In advance, localization resource should be present for the workflow, otherwise it defaults to the standard workflow presentation definition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workflow_presentation(workflow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :return: Presentation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_workflow_presentation_with_http_info(workflow_id, **kwargs)
        else:
            (data) = self.get_workflow_presentation_with_http_info(workflow_id, **kwargs)
            return data

    def get_workflow_presentation_with_http_info(self, workflow_id, **kwargs):
        """
        Get presentation
        Retrieves the definition of a workflow presentation. To retrieve the workflow presentation definition localized, add Accept-Language header, with the appropriate locale. In advance, localization resource should be present for the workflow, otherwise it defaults to the standard workflow presentation definition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workflow_presentation_with_http_info(workflow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :return: Presentation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_presentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params) or (params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `get_workflow_presentation`")


        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/workflows/{workflowId}/presentation', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Presentation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_workflow_presentation_instance(self, workflow_id, presentation_execution_id, **kwargs):
        """
        Load Execution
        Retrieves a specific workflow presentation instance. Presentation instances are removed after the workflow starts. If the presentation instance under requested <b>executionId</b> does not exists, a new presentation instance is created by using the parameters from the workflow execution with the same ID. To retrieve the workflow presentation localized, add Accept-Language header, with the appropriate locale. In advance, localization resource should be present for the workflow, otherwise it defaults to the standard workflow presentation.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workflow_presentation_instance(workflow_id, presentation_execution_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :param str presentation_execution_id: presentationExecutionId (required)
        :return: PresentationExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_workflow_presentation_instance_with_http_info(workflow_id, presentation_execution_id, **kwargs)
        else:
            (data) = self.get_workflow_presentation_instance_with_http_info(workflow_id, presentation_execution_id, **kwargs)
            return data

    def get_workflow_presentation_instance_with_http_info(self, workflow_id, presentation_execution_id, **kwargs):
        """
        Load Execution
        Retrieves a specific workflow presentation instance. Presentation instances are removed after the workflow starts. If the presentation instance under requested <b>executionId</b> does not exists, a new presentation instance is created by using the parameters from the workflow execution with the same ID. To retrieve the workflow presentation localized, add Accept-Language header, with the appropriate locale. In advance, localization resource should be present for the workflow, otherwise it defaults to the standard workflow presentation.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workflow_presentation_instance_with_http_info(workflow_id, presentation_execution_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :param str presentation_execution_id: presentationExecutionId (required)
        :return: PresentationExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'presentation_execution_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_presentation_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params) or (params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `get_workflow_presentation_instance`")
        # verify the required parameter 'presentation_execution_id' is set
        if ('presentation_execution_id' not in params) or (params['presentation_execution_id'] is None):
            raise ValueError("Missing the required parameter `presentation_execution_id` when calling `get_workflow_presentation_instance`")


        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']
        if 'presentation_execution_id' in params:
            path_params['presentationExecutionId'] = params['presentation_execution_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/workflows/{workflowId}/presentation/instances/{presentationExecutionId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PresentationExecution',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def start_workflow_presentation(self, workflow_id, execution_context, **kwargs):
        """
        Start presentation
         Creates a new instance of the presentation of a workflow, by using the passed parameters. To create a new instance of a workflow presentation, make an HTTP GET request at the URL that contains the instances of the workflow presentation. Presentation's fields are populated with input parameter values and are validated. If there are any validation errors, they are collected and attached to each field. The presentation is marked as invalid. In order the returned workflow presentation to be localized, add Accept-Language header, with the appropriate locale. In advance, localization resource should be present for the workflow, otherwise it defaults to the standard workflow presentation.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.start_workflow_presentation(workflow_id, execution_context, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :param ExecutionContext execution_context: executionContext (required)
        :return: PresentationExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.start_workflow_presentation_with_http_info(workflow_id, execution_context, **kwargs)
        else:
            (data) = self.start_workflow_presentation_with_http_info(workflow_id, execution_context, **kwargs)
            return data

    def start_workflow_presentation_with_http_info(self, workflow_id, execution_context, **kwargs):
        """
        Start presentation
         Creates a new instance of the presentation of a workflow, by using the passed parameters. To create a new instance of a workflow presentation, make an HTTP GET request at the URL that contains the instances of the workflow presentation. Presentation's fields are populated with input parameter values and are validated. If there are any validation errors, they are collected and attached to each field. The presentation is marked as invalid. In order the returned workflow presentation to be localized, add Accept-Language header, with the appropriate locale. In advance, localization resource should be present for the workflow, otherwise it defaults to the standard workflow presentation.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.start_workflow_presentation_with_http_info(workflow_id, execution_context, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :param ExecutionContext execution_context: executionContext (required)
        :return: PresentationExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'execution_context']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_workflow_presentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params) or (params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `start_workflow_presentation`")
        # verify the required parameter 'execution_context' is set
        if ('execution_context' not in params) or (params['execution_context'] is None):
            raise ValueError("Missing the required parameter `execution_context` when calling `start_workflow_presentation`")


        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'execution_context' in params:
            body_params = params['execution_context']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/workflows/{workflowId}/presentation/instances', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PresentationExecution',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_workflow_presentation_instance(self, workflow_id, presentation_execution_id, execution_context, **kwargs):
        """
        Update presentation
        Update a specific workflow presentation instance. Presentation fields are populated with input parameter values and are validated. If there are any validation errors, they are collected and attached to each field. The presentation is marked as invalid. If the parameter's 'updated' flag is set to true, the dependent field values are recalculated.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_workflow_presentation_instance(workflow_id, presentation_execution_id, execution_context, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :param str presentation_execution_id: presentationExecutionId (required)
        :param ExecutionContext execution_context: executionContext (required)
        :return: PresentationExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_workflow_presentation_instance_with_http_info(workflow_id, presentation_execution_id, execution_context, **kwargs)
        else:
            (data) = self.update_workflow_presentation_instance_with_http_info(workflow_id, presentation_execution_id, execution_context, **kwargs)
            return data

    def update_workflow_presentation_instance_with_http_info(self, workflow_id, presentation_execution_id, execution_context, **kwargs):
        """
        Update presentation
        Update a specific workflow presentation instance. Presentation fields are populated with input parameter values and are validated. If there are any validation errors, they are collected and attached to each field. The presentation is marked as invalid. If the parameter's 'updated' flag is set to true, the dependent field values are recalculated.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_workflow_presentation_instance_with_http_info(workflow_id, presentation_execution_id, execution_context, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :param str presentation_execution_id: presentationExecutionId (required)
        :param ExecutionContext execution_context: executionContext (required)
        :return: PresentationExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'presentation_execution_id', 'execution_context']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_workflow_presentation_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params) or (params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `update_workflow_presentation_instance`")
        # verify the required parameter 'presentation_execution_id' is set
        if ('presentation_execution_id' not in params) or (params['presentation_execution_id'] is None):
            raise ValueError("Missing the required parameter `presentation_execution_id` when calling `update_workflow_presentation_instance`")
        # verify the required parameter 'execution_context' is set
        if ('execution_context' not in params) or (params['execution_context'] is None):
            raise ValueError("Missing the required parameter `execution_context` when calling `update_workflow_presentation_instance`")


        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']
        if 'presentation_execution_id' in params:
            path_params['presentationExecutionId'] = params['presentation_execution_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'execution_context' in params:
            body_params = params['execution_context']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/workflows/{workflowId}/presentation/instances/{presentationExecutionId}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PresentationExecution',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
