# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class VirtualCenterApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def attach_virtual_center(self, vimserver, **kwargs):
        """
        Attach a Virtual Center server
        Attach a Virtual Center server.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.attach_virtual_center(vimserver, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param VCenterServer vimserver: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.attach_virtual_center_with_http_info(vimserver, **kwargs)
        else:
            (data) = self.attach_virtual_center_with_http_info(vimserver, **kwargs)
            return data

    def attach_virtual_center_with_http_info(self, vimserver, **kwargs):
        """
        Attach a Virtual Center server
        Attach a Virtual Center server.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.attach_virtual_center_with_http_info(vimserver, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param VCenterServer vimserver: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vimserver']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method attach_virtual_center" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vimserver' is set
        if ('vimserver' not in params) or (params['vimserver'] is None):
            raise ValueError("Missing the required parameter `vimserver` when calling `attach_virtual_center`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vimserver' in params:
            body_params = params['vimserver']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/virtualCenters', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_virtual_center(self, vc_urn, **kwargs):
        """
        Detach the specified Virtual Center server
        Unregister a vCenter server. This operation is asynchronous and returns a task that you can monitor to track the progress of the request. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_virtual_center(vc_urn, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_virtual_center_with_http_info(vc_urn, **kwargs)
        else:
            (data) = self.delete_virtual_center_with_http_info(vc_urn, **kwargs)
            return data

    def delete_virtual_center_with_http_info(self, vc_urn, **kwargs):
        """
        Detach the specified Virtual Center server
        Unregister a vCenter server. This operation is asynchronous and returns a task that you can monitor to track the progress of the request. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_virtual_center_with_http_info(vc_urn, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vc_urn']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_virtual_center" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vc_urn' is set
        if ('vc_urn' not in params) or (params['vc_urn'] is None):
            raise ValueError("Missing the required parameter `vc_urn` when calling `delete_virtual_center`")


        collection_formats = {}

        path_params = {}
        if 'vc_urn' in params:
            path_params['vcUrn'] = params['vc_urn']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/virtualCenters/{vcUrn}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_child_resource_pools(self, vc_urn, moref, page, page_size, **kwargs):
        """
        Get resource pools of a VC
        Get list of child resource pools of the specified parent. If a resource pool is ineligible, but is in the response, this means it has children, which are eligible. A resource pool will be ineligible, unless the cluster has an ESXi host on it. The list will be sorted by name, case insensitive. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_child_resource_pools(vc_urn, moref, page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :param str moref: (required)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :return: ResourcePools
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_child_resource_pools_with_http_info(vc_urn, moref, page, page_size, **kwargs)
        else:
            (data) = self.get_child_resource_pools_with_http_info(vc_urn, moref, page, page_size, **kwargs)
            return data

    def get_child_resource_pools_with_http_info(self, vc_urn, moref, page, page_size, **kwargs):
        """
        Get resource pools of a VC
        Get list of child resource pools of the specified parent. If a resource pool is ineligible, but is in the response, this means it has children, which are eligible. A resource pool will be ineligible, unless the cluster has an ESXi host on it. The list will be sorted by name, case insensitive. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_child_resource_pools_with_http_info(vc_urn, moref, page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :param str moref: (required)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :return: ResourcePools
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vc_urn', 'moref', 'page', 'page_size']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_child_resource_pools" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vc_urn' is set
        if ('vc_urn' not in params) or (params['vc_urn'] is None):
            raise ValueError("Missing the required parameter `vc_urn` when calling `get_child_resource_pools`")
        # verify the required parameter 'moref' is set
        if ('moref' not in params) or (params['moref'] is None):
            raise ValueError("Missing the required parameter `moref` when calling `get_child_resource_pools`")
        # verify the required parameter 'page' is set
        if ('page' not in params) or (params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_child_resource_pools`")
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params) or (params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_child_resource_pools`")

        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `get_child_resource_pools`, must be a value greater than or equal to `1`")
        if 'page_size' in params and params['page_size'] > 128:
            raise ValueError("Invalid value for parameter `page_size` when calling `get_child_resource_pools`, must be a value less than or equal to `128`")
        if 'page_size' in params and params['page_size'] < 0:
            raise ValueError("Invalid value for parameter `page_size` when calling `get_child_resource_pools`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}
        if 'vc_urn' in params:
            path_params['vcUrn'] = params['vc_urn']
        if 'moref' in params:
            path_params['moref'] = params['moref']

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/virtualCenters/{vcUrn}/resourcePools/browse/{moref}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ResourcePools',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_nsx_v_manager_settings(self, vc_urn, **kwargs):
        """
        Get Virtual Center server network settings
        Retrieve the networking configuration of a registered vCenter server. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_nsx_v_manager_settings(vc_urn, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :return: NsxVManagerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_nsx_v_manager_settings_with_http_info(vc_urn, **kwargs)
        else:
            (data) = self.get_nsx_v_manager_settings_with_http_info(vc_urn, **kwargs)
            return data

    def get_nsx_v_manager_settings_with_http_info(self, vc_urn, **kwargs):
        """
        Get Virtual Center server network settings
        Retrieve the networking configuration of a registered vCenter server. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_nsx_v_manager_settings_with_http_info(vc_urn, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :return: NsxVManagerSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vc_urn']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nsx_v_manager_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vc_urn' is set
        if ('vc_urn' not in params) or (params['vc_urn'] is None):
            raise ValueError("Missing the required parameter `vc_urn` when calling `get_nsx_v_manager_settings`")


        collection_formats = {}

        path_params = {}
        if 'vc_urn' in params:
            path_params['vcUrn'] = params['vc_urn']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/virtualCenters/{vcUrn}/nsxVSettings', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='NsxVManagerSettings',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_resource_pool_kubernetes_config(self, vc_urn, moref, **kwargs):
        """
        Get kubernetes configuration for a resource pool.
        Get kubernetes configuration for a resource pool which is backed by a kubernetes enabled cluster. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_resource_pool_kubernetes_config(vc_urn, moref, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :param str moref: (required)
        :return: ResourcePoolKubernetesConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_resource_pool_kubernetes_config_with_http_info(vc_urn, moref, **kwargs)
        else:
            (data) = self.get_resource_pool_kubernetes_config_with_http_info(vc_urn, moref, **kwargs)
            return data

    def get_resource_pool_kubernetes_config_with_http_info(self, vc_urn, moref, **kwargs):
        """
        Get kubernetes configuration for a resource pool.
        Get kubernetes configuration for a resource pool which is backed by a kubernetes enabled cluster. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_resource_pool_kubernetes_config_with_http_info(vc_urn, moref, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :param str moref: (required)
        :return: ResourcePoolKubernetesConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vc_urn', 'moref']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_resource_pool_kubernetes_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vc_urn' is set
        if ('vc_urn' not in params) or (params['vc_urn'] is None):
            raise ValueError("Missing the required parameter `vc_urn` when calling `get_resource_pool_kubernetes_config`")
        # verify the required parameter 'moref' is set
        if ('moref' not in params) or (params['moref'] is None):
            raise ValueError("Missing the required parameter `moref` when calling `get_resource_pool_kubernetes_config`")


        collection_formats = {}

        path_params = {}
        if 'vc_urn' in params:
            path_params['vcUrn'] = params['vc_urn']
        if 'moref' in params:
            path_params['moref'] = params['moref']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/virtualCenters/{vcUrn}/resourcePools/{moref}/kubernetesConfig', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ResourcePoolKubernetesConfig',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_root_resource_pools(self, vc_urn, page, page_size, **kwargs):
        """
        Get resource pools of a VC
        Get a list of all root resource pools. If a resource pool is ineligible, but is in the response, this means it has children, which are eligible. A resource pool will be ineligible, unless the cluster has an ESXi host on it. The list will be sorted by name, case insensitive. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_root_resource_pools(vc_urn, page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :return: ResourcePools
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_root_resource_pools_with_http_info(vc_urn, page, page_size, **kwargs)
        else:
            (data) = self.get_root_resource_pools_with_http_info(vc_urn, page, page_size, **kwargs)
            return data

    def get_root_resource_pools_with_http_info(self, vc_urn, page, page_size, **kwargs):
        """
        Get resource pools of a VC
        Get a list of all root resource pools. If a resource pool is ineligible, but is in the response, this means it has children, which are eligible. A resource pool will be ineligible, unless the cluster has an ESXi host on it. The list will be sorted by name, case insensitive. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_root_resource_pools_with_http_info(vc_urn, page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :return: ResourcePools
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vc_urn', 'page', 'page_size']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_root_resource_pools" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vc_urn' is set
        if ('vc_urn' not in params) or (params['vc_urn'] is None):
            raise ValueError("Missing the required parameter `vc_urn` when calling `get_root_resource_pools`")
        # verify the required parameter 'page' is set
        if ('page' not in params) or (params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_root_resource_pools`")
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params) or (params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_root_resource_pools`")

        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `get_root_resource_pools`, must be a value greater than or equal to `1`")
        if 'page_size' in params and params['page_size'] > 128:
            raise ValueError("Invalid value for parameter `page_size` when calling `get_root_resource_pools`, must be a value less than or equal to `128`")
        if 'page_size' in params and params['page_size'] < 0:
            raise ValueError("Invalid value for parameter `page_size` when calling `get_root_resource_pools`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}
        if 'vc_urn' in params:
            path_params['vcUrn'] = params['vc_urn']

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/virtualCenters/{vcUrn}/resourcePools/browse', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ResourcePools',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_storage_profiles(self, vc_urn, page, page_size, **kwargs):
        """
        Get storage profiles of a VC
        Get a list of all storage profiles for a VC. Supported contexts are: Resource Pool Moref (_context==moref) - | Returns all the storage profiles which are related to a specific Resoure Pool. Example: /cloudapi/{ver}/virtualCenters/{urn}/storageProfiles?filter=_context==resgroup-N 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_storage_profiles(vc_urn, page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: StorageProfiles
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_storage_profiles_with_http_info(vc_urn, page, page_size, **kwargs)
        else:
            (data) = self.get_storage_profiles_with_http_info(vc_urn, page, page_size, **kwargs)
            return data

    def get_storage_profiles_with_http_info(self, vc_urn, page, page_size, **kwargs):
        """
        Get storage profiles of a VC
        Get a list of all storage profiles for a VC. Supported contexts are: Resource Pool Moref (_context==moref) - | Returns all the storage profiles which are related to a specific Resoure Pool. Example: /cloudapi/{ver}/virtualCenters/{urn}/storageProfiles?filter=_context==resgroup-N 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_storage_profiles_with_http_info(vc_urn, page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: StorageProfiles
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vc_urn', 'page', 'page_size', 'filter', 'sort_asc', 'sort_desc']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_storage_profiles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vc_urn' is set
        if ('vc_urn' not in params) or (params['vc_urn'] is None):
            raise ValueError("Missing the required parameter `vc_urn` when calling `get_storage_profiles`")
        # verify the required parameter 'page' is set
        if ('page' not in params) or (params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_storage_profiles`")
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params) or (params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_storage_profiles`")

        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `get_storage_profiles`, must be a value greater than or equal to `1`")
        if 'page_size' in params and params['page_size'] > 128:
            raise ValueError("Invalid value for parameter `page_size` when calling `get_storage_profiles`, must be a value less than or equal to `128`")
        if 'page_size' in params and params['page_size'] < 0:
            raise ValueError("Invalid value for parameter `page_size` when calling `get_storage_profiles`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}
        if 'vc_urn' in params:
            path_params['vcUrn'] = params['vc_urn']

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'sort_asc' in params:
            query_params.append(('sortAsc', params['sort_asc']))
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/virtualCenters/{vcUrn}/storageProfiles', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='StorageProfiles',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_supported_hardware_versions(self, vc_urn, moref, **kwargs):
        """
        Get supported hardware versions of a resource pool
        Get a set of all supported hardware versions by the ESXi hosts in the resource pool. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_supported_hardware_versions(vc_urn, moref, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :param str moref: (required)
        :return: HardwareVersions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_supported_hardware_versions_with_http_info(vc_urn, moref, **kwargs)
        else:
            (data) = self.get_supported_hardware_versions_with_http_info(vc_urn, moref, **kwargs)
            return data

    def get_supported_hardware_versions_with_http_info(self, vc_urn, moref, **kwargs):
        """
        Get supported hardware versions of a resource pool
        Get a set of all supported hardware versions by the ESXi hosts in the resource pool. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_supported_hardware_versions_with_http_info(vc_urn, moref, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :param str moref: (required)
        :return: HardwareVersions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vc_urn', 'moref']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_supported_hardware_versions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vc_urn' is set
        if ('vc_urn' not in params) or (params['vc_urn'] is None):
            raise ValueError("Missing the required parameter `vc_urn` when calling `get_supported_hardware_versions`")
        # verify the required parameter 'moref' is set
        if ('moref' not in params) or (params['moref'] is None):
            raise ValueError("Missing the required parameter `moref` when calling `get_supported_hardware_versions`")


        collection_formats = {}

        path_params = {}
        if 'vc_urn' in params:
            path_params['vcUrn'] = params['vc_urn']
        if 'moref' in params:
            path_params['moref'] = params['moref']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/virtualCenters/{vcUrn}/resourcePools/{moref}/hwv', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='HardwareVersions',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_unmanaged_virtual_machines(self, vc_urn, page, page_size, **kwargs):
        """
        Get a list of unmanaged virtual machines from vCenter Server
        Get a list of unmanaged virtual machines from vCenter Server 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_unmanaged_virtual_machines(vc_urn, page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: UnmanagedVirtualMachines
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_unmanaged_virtual_machines_with_http_info(vc_urn, page, page_size, **kwargs)
        else:
            (data) = self.get_unmanaged_virtual_machines_with_http_info(vc_urn, page, page_size, **kwargs)
            return data

    def get_unmanaged_virtual_machines_with_http_info(self, vc_urn, page, page_size, **kwargs):
        """
        Get a list of unmanaged virtual machines from vCenter Server
        Get a list of unmanaged virtual machines from vCenter Server 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_unmanaged_virtual_machines_with_http_info(vc_urn, page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: UnmanagedVirtualMachines
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vc_urn', 'page', 'page_size', 'filter', 'sort_asc', 'sort_desc']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_unmanaged_virtual_machines" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vc_urn' is set
        if ('vc_urn' not in params) or (params['vc_urn'] is None):
            raise ValueError("Missing the required parameter `vc_urn` when calling `get_unmanaged_virtual_machines`")
        # verify the required parameter 'page' is set
        if ('page' not in params) or (params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_unmanaged_virtual_machines`")
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params) or (params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_unmanaged_virtual_machines`")

        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `get_unmanaged_virtual_machines`, must be a value greater than or equal to `1`")
        if 'page_size' in params and params['page_size'] > 128:
            raise ValueError("Invalid value for parameter `page_size` when calling `get_unmanaged_virtual_machines`, must be a value less than or equal to `128`")
        if 'page_size' in params and params['page_size'] < 0:
            raise ValueError("Invalid value for parameter `page_size` when calling `get_unmanaged_virtual_machines`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}
        if 'vc_urn' in params:
            path_params['vcUrn'] = params['vc_urn']

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'sort_asc' in params:
            query_params.append(('sortAsc', params['sort_asc']))
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/virtualCenters/{vcUrn}/unmanagedVirtualMachines', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='UnmanagedVirtualMachines',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_vc_storage_policy_capabilities(self, vc_urn, moref, **kwargs):
        """
        Retrieves capabilities of a specific Virtual Center storage policy.
        Retrieves the current capabilities configured on a specific Virtual Center storage policy. These cannot be edited. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_vc_storage_policy_capabilities(vc_urn, moref, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :param str moref: (required)
        :return: Capabilities
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_vc_storage_policy_capabilities_with_http_info(vc_urn, moref, **kwargs)
        else:
            (data) = self.get_vc_storage_policy_capabilities_with_http_info(vc_urn, moref, **kwargs)
            return data

    def get_vc_storage_policy_capabilities_with_http_info(self, vc_urn, moref, **kwargs):
        """
        Retrieves capabilities of a specific Virtual Center storage policy.
        Retrieves the current capabilities configured on a specific Virtual Center storage policy. These cannot be edited. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_vc_storage_policy_capabilities_with_http_info(vc_urn, moref, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :param str moref: (required)
        :return: Capabilities
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vc_urn', 'moref']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vc_storage_policy_capabilities" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vc_urn' is set
        if ('vc_urn' not in params) or (params['vc_urn'] is None):
            raise ValueError("Missing the required parameter `vc_urn` when calling `get_vc_storage_policy_capabilities`")
        # verify the required parameter 'moref' is set
        if ('moref' not in params) or (params['moref'] is None):
            raise ValueError("Missing the required parameter `moref` when calling `get_vc_storage_policy_capabilities`")


        collection_formats = {}

        path_params = {}
        if 'vc_urn' in params:
            path_params['vcUrn'] = params['vc_urn']
        if 'moref' in params:
            path_params['moref'] = params['moref']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/virtualCenters/{vcUrn}/storageProfiles/{moref}/capabilities', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Capabilities',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_virtual_center(self, vc_urn, **kwargs):
        """
        Get Virtual Center server
        Retrieve the representation of a vCenter server registered and managed by vCD. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_virtual_center(vc_urn, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :return: VCenterServer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_virtual_center_with_http_info(vc_urn, **kwargs)
        else:
            (data) = self.get_virtual_center_with_http_info(vc_urn, **kwargs)
            return data

    def get_virtual_center_with_http_info(self, vc_urn, **kwargs):
        """
        Get Virtual Center server
        Retrieve the representation of a vCenter server registered and managed by vCD. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_virtual_center_with_http_info(vc_urn, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :return: VCenterServer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vc_urn']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_virtual_center" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vc_urn' is set
        if ('vc_urn' not in params) or (params['vc_urn'] is None):
            raise ValueError("Missing the required parameter `vc_urn` when calling `get_virtual_center`")


        collection_formats = {}

        path_params = {}
        if 'vc_urn' in params:
            path_params['vcUrn'] = params['vc_urn']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/virtualCenters/{vcUrn}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VCenterServer',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_virtual_center_metrics(self, vc_urn, **kwargs):
        """
        Get Virtual Center server metrics
        Retrieve the metrics of a registered vCenter server. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_virtual_center_metrics(vc_urn, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :return: VCenterServerMetrics
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_virtual_center_metrics_with_http_info(vc_urn, **kwargs)
        else:
            (data) = self.get_virtual_center_metrics_with_http_info(vc_urn, **kwargs)
            return data

    def get_virtual_center_metrics_with_http_info(self, vc_urn, **kwargs):
        """
        Get Virtual Center server metrics
        Retrieve the metrics of a registered vCenter server. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_virtual_center_metrics_with_http_info(vc_urn, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :return: VCenterServerMetrics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vc_urn']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_virtual_center_metrics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vc_urn' is set
        if ('vc_urn' not in params) or (params['vc_urn'] is None):
            raise ValueError("Missing the required parameter `vc_urn` when calling `get_virtual_center_metrics`")


        collection_formats = {}

        path_params = {}
        if 'vc_urn' in params:
            path_params['vcUrn'] = params['vc_urn']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/virtualCenters/{vcUrn}/metrics', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VCenterServerMetrics',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def query_virtual_centers(self, page, page_size, **kwargs):
        """
        Gets a paged list of Virtual Center servers.
        Retrieves a paged list of all Virtual Center servers in the system. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_virtual_centers(page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: VCenterServers
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.query_virtual_centers_with_http_info(page, page_size, **kwargs)
        else:
            (data) = self.query_virtual_centers_with_http_info(page, page_size, **kwargs)
            return data

    def query_virtual_centers_with_http_info(self, page, page_size, **kwargs):
        """
        Gets a paged list of Virtual Center servers.
        Retrieves a paged list of all Virtual Center servers in the system. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_virtual_centers_with_http_info(page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: VCenterServers
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'page_size', 'filter', 'sort_asc', 'sort_desc']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_virtual_centers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page' is set
        if ('page' not in params) or (params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `query_virtual_centers`")
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params) or (params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `query_virtual_centers`")

        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `query_virtual_centers`, must be a value greater than or equal to `1`")
        if 'page_size' in params and params['page_size'] > 128:
            raise ValueError("Invalid value for parameter `page_size` when calling `query_virtual_centers`, must be a value less than or equal to `128`")
        if 'page_size' in params and params['page_size'] < 0:
            raise ValueError("Invalid value for parameter `page_size` when calling `query_virtual_centers`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'sort_asc' in params:
            query_params.append(('sortAsc', params['sort_asc']))
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/virtualCenters', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VCenterServers',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def query_virtual_machine_classes(self, vc_urn, moref, page, page_size, **kwargs):
        """
        Get a list of Virtual Machine Classes associated with this resource pool.
        Get a list of Virtual Machine Classes associated with this resource pool. This API throws 400 BadRequestException if called against a resource pool which is not Kubernetes enabled. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_virtual_machine_classes(vc_urn, moref, page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :param str moref: (required)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: VirtualMachineClasses
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.query_virtual_machine_classes_with_http_info(vc_urn, moref, page, page_size, **kwargs)
        else:
            (data) = self.query_virtual_machine_classes_with_http_info(vc_urn, moref, page, page_size, **kwargs)
            return data

    def query_virtual_machine_classes_with_http_info(self, vc_urn, moref, page, page_size, **kwargs):
        """
        Get a list of Virtual Machine Classes associated with this resource pool.
        Get a list of Virtual Machine Classes associated with this resource pool. This API throws 400 BadRequestException if called against a resource pool which is not Kubernetes enabled. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_virtual_machine_classes_with_http_info(vc_urn, moref, page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :param str moref: (required)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: VirtualMachineClasses
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vc_urn', 'moref', 'page', 'page_size', 'filter', 'sort_asc', 'sort_desc']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_virtual_machine_classes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vc_urn' is set
        if ('vc_urn' not in params) or (params['vc_urn'] is None):
            raise ValueError("Missing the required parameter `vc_urn` when calling `query_virtual_machine_classes`")
        # verify the required parameter 'moref' is set
        if ('moref' not in params) or (params['moref'] is None):
            raise ValueError("Missing the required parameter `moref` when calling `query_virtual_machine_classes`")
        # verify the required parameter 'page' is set
        if ('page' not in params) or (params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `query_virtual_machine_classes`")
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params) or (params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `query_virtual_machine_classes`")

        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `query_virtual_machine_classes`, must be a value greater than or equal to `1`")
        if 'page_size' in params and params['page_size'] > 128:
            raise ValueError("Invalid value for parameter `page_size` when calling `query_virtual_machine_classes`, must be a value less than or equal to `128`")
        if 'page_size' in params and params['page_size'] < 0:
            raise ValueError("Invalid value for parameter `page_size` when calling `query_virtual_machine_classes`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}
        if 'vc_urn' in params:
            path_params['vcUrn'] = params['vc_urn']
        if 'moref' in params:
            path_params['moref'] = params['moref']

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'sort_asc' in params:
            query_params.append(('sortAsc', params['sort_asc']))
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/virtualCenters/{vcUrn}/resourcePools/{moref}/virtualMachineClasses', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VirtualMachineClasses',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_nsx_v_manager_settings(self, vc_urn, update_v_center_server_params, **kwargs):
        """
        Update specified Virtual Center server network settings
        Update the network settings of a registered vCenter server. This operation is asynchronous and returns a task that you can monitor to track the progress of the request. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_nsx_v_manager_settings(vc_urn, update_v_center_server_params, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :param NsxVManagerSettings update_v_center_server_params: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_nsx_v_manager_settings_with_http_info(vc_urn, update_v_center_server_params, **kwargs)
        else:
            (data) = self.update_nsx_v_manager_settings_with_http_info(vc_urn, update_v_center_server_params, **kwargs)
            return data

    def update_nsx_v_manager_settings_with_http_info(self, vc_urn, update_v_center_server_params, **kwargs):
        """
        Update specified Virtual Center server network settings
        Update the network settings of a registered vCenter server. This operation is asynchronous and returns a task that you can monitor to track the progress of the request. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_nsx_v_manager_settings_with_http_info(vc_urn, update_v_center_server_params, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :param NsxVManagerSettings update_v_center_server_params: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vc_urn', 'update_v_center_server_params']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_nsx_v_manager_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vc_urn' is set
        if ('vc_urn' not in params) or (params['vc_urn'] is None):
            raise ValueError("Missing the required parameter `vc_urn` when calling `update_nsx_v_manager_settings`")
        # verify the required parameter 'update_v_center_server_params' is set
        if ('update_v_center_server_params' not in params) or (params['update_v_center_server_params'] is None):
            raise ValueError("Missing the required parameter `update_v_center_server_params` when calling `update_nsx_v_manager_settings`")


        collection_formats = {}

        path_params = {}
        if 'vc_urn' in params:
            path_params['vcUrn'] = params['vc_urn']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_v_center_server_params' in params:
            body_params = params['update_v_center_server_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/virtualCenters/{vcUrn}/nsxVSettings', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_virtual_center(self, vc_urn, update_v_center_server_params, **kwargs):
        """
        Update specified Virtual Center server
        Update the representation of a registered vCenter server. This operation is asynchronous and returns a task that you can monitor to track the progress of the request. Starting with API version 36.0, a null nsxVManager will attempt to remove the NSX-V Manager from the vCenter, and a non-null nsxVManager will attempt to add the NSX-V Manager to the vCenter if there is none registered or update the NSX-V Manager if there is one already registered to the vCenter. If you don't want to update the NSX-V Manager, provide the same NSX-V Manager settings as the existing one. For API versions before 36.0, no changes or updates to the nsxVManager will be made, regardless of whether an nsxVManger is provided or if it's different than the existing one. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_virtual_center(vc_urn, update_v_center_server_params, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :param VCenterServer update_v_center_server_params: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_virtual_center_with_http_info(vc_urn, update_v_center_server_params, **kwargs)
        else:
            (data) = self.update_virtual_center_with_http_info(vc_urn, update_v_center_server_params, **kwargs)
            return data

    def update_virtual_center_with_http_info(self, vc_urn, update_v_center_server_params, **kwargs):
        """
        Update specified Virtual Center server
        Update the representation of a registered vCenter server. This operation is asynchronous and returns a task that you can monitor to track the progress of the request. Starting with API version 36.0, a null nsxVManager will attempt to remove the NSX-V Manager from the vCenter, and a non-null nsxVManager will attempt to add the NSX-V Manager to the vCenter if there is none registered or update the NSX-V Manager if there is one already registered to the vCenter. If you don't want to update the NSX-V Manager, provide the same NSX-V Manager settings as the existing one. For API versions before 36.0, no changes or updates to the nsxVManager will be made, regardless of whether an nsxVManger is provided or if it's different than the existing one. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_virtual_center_with_http_info(vc_urn, update_v_center_server_params, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vc_urn: (required)
        :param VCenterServer update_v_center_server_params: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vc_urn', 'update_v_center_server_params']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_virtual_center" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vc_urn' is set
        if ('vc_urn' not in params) or (params['vc_urn'] is None):
            raise ValueError("Missing the required parameter `vc_urn` when calling `update_virtual_center`")
        # verify the required parameter 'update_v_center_server_params' is set
        if ('update_v_center_server_params' not in params) or (params['update_v_center_server_params'] is None):
            raise ValueError("Missing the required parameter `update_v_center_server_params` when calling `update_virtual_center`")


        collection_formats = {}

        path_params = {}
        if 'vc_urn' in params:
            path_params['vcUrn'] = params['vc_urn']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_v_center_server_params' in params:
            body_params = params['update_v_center_server_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/virtualCenters/{vcUrn}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
