# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class LogicalVmGroupsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def add_named_vm_groups_to_logical_vm_group(self, named_vm_group_refs, logical_vm_group_id, **kwargs):
        """
        Assign named vm groups to logical vm group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_named_vm_groups_to_logical_vm_group(named_vm_group_refs, logical_vm_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[EntityReference] named_vm_group_refs: (required)
        :param str logical_vm_group_id: (required)
        :return: list[EntityReference]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_named_vm_groups_to_logical_vm_group_with_http_info(named_vm_group_refs, logical_vm_group_id, **kwargs)
        else:
            (data) = self.add_named_vm_groups_to_logical_vm_group_with_http_info(named_vm_group_refs, logical_vm_group_id, **kwargs)
            return data

    def add_named_vm_groups_to_logical_vm_group_with_http_info(self, named_vm_group_refs, logical_vm_group_id, **kwargs):
        """
        Assign named vm groups to logical vm group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_named_vm_groups_to_logical_vm_group_with_http_info(named_vm_group_refs, logical_vm_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[EntityReference] named_vm_group_refs: (required)
        :param str logical_vm_group_id: (required)
        :return: list[EntityReference]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['named_vm_group_refs', 'logical_vm_group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_named_vm_groups_to_logical_vm_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'named_vm_group_refs' is set
        if ('named_vm_group_refs' not in params) or (params['named_vm_group_refs'] is None):
            raise ValueError("Missing the required parameter `named_vm_group_refs` when calling `add_named_vm_groups_to_logical_vm_group`")
        # verify the required parameter 'logical_vm_group_id' is set
        if ('logical_vm_group_id' not in params) or (params['logical_vm_group_id'] is None):
            raise ValueError("Missing the required parameter `logical_vm_group_id` when calling `add_named_vm_groups_to_logical_vm_group`")


        collection_formats = {}

        path_params = {}
        if 'logical_vm_group_id' in params:
            path_params['logicalVmGroupId'] = params['logical_vm_group_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'named_vm_group_refs' in params:
            body_params = params['named_vm_group_refs']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/logicalVmGroups/{logicalVmGroupId}/namedVmGroups', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[EntityReference]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_logical_vm_group(self, new_logical_vm_group_params, **kwargs):
        """
        Creates a new logical vm group
        Creates a new logical vm group 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_logical_vm_group(new_logical_vm_group_params, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param LogicalVmGroup new_logical_vm_group_params: (required)
        :return: LogicalVmGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_logical_vm_group_with_http_info(new_logical_vm_group_params, **kwargs)
        else:
            (data) = self.create_logical_vm_group_with_http_info(new_logical_vm_group_params, **kwargs)
            return data

    def create_logical_vm_group_with_http_info(self, new_logical_vm_group_params, **kwargs):
        """
        Creates a new logical vm group
        Creates a new logical vm group 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_logical_vm_group_with_http_info(new_logical_vm_group_params, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param LogicalVmGroup new_logical_vm_group_params: (required)
        :return: LogicalVmGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['new_logical_vm_group_params']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_logical_vm_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'new_logical_vm_group_params' is set
        if ('new_logical_vm_group_params' not in params) or (params['new_logical_vm_group_params'] is None):
            raise ValueError("Missing the required parameter `new_logical_vm_group_params` when calling `create_logical_vm_group`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'new_logical_vm_group_params' in params:
            body_params = params['new_logical_vm_group_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/logicalVmGroups', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LogicalVmGroup',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_logical_vm_group(self, logical_vm_group_id, **kwargs):
        """
        Delete specified logical vm group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_logical_vm_group(logical_vm_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str logical_vm_group_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_logical_vm_group_with_http_info(logical_vm_group_id, **kwargs)
        else:
            (data) = self.delete_logical_vm_group_with_http_info(logical_vm_group_id, **kwargs)
            return data

    def delete_logical_vm_group_with_http_info(self, logical_vm_group_id, **kwargs):
        """
        Delete specified logical vm group.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_logical_vm_group_with_http_info(logical_vm_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str logical_vm_group_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['logical_vm_group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_logical_vm_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'logical_vm_group_id' is set
        if ('logical_vm_group_id' not in params) or (params['logical_vm_group_id'] is None):
            raise ValueError("Missing the required parameter `logical_vm_group_id` when calling `delete_logical_vm_group`")


        collection_formats = {}

        path_params = {}
        if 'logical_vm_group_id' in params:
            path_params['logicalVmGroupId'] = params['logical_vm_group_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/logicalVmGroups/{logicalVmGroupId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_logical_vm_group(self, logical_vm_group_id, **kwargs):
        """
        Get specified logical vm group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_logical_vm_group(logical_vm_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str logical_vm_group_id: (required)
        :return: LogicalVmGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_logical_vm_group_with_http_info(logical_vm_group_id, **kwargs)
        else:
            (data) = self.get_logical_vm_group_with_http_info(logical_vm_group_id, **kwargs)
            return data

    def get_logical_vm_group_with_http_info(self, logical_vm_group_id, **kwargs):
        """
        Get specified logical vm group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_logical_vm_group_with_http_info(logical_vm_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str logical_vm_group_id: (required)
        :return: LogicalVmGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['logical_vm_group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_logical_vm_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'logical_vm_group_id' is set
        if ('logical_vm_group_id' not in params) or (params['logical_vm_group_id'] is None):
            raise ValueError("Missing the required parameter `logical_vm_group_id` when calling `get_logical_vm_group`")


        collection_formats = {}

        path_params = {}
        if 'logical_vm_group_id' in params:
            path_params['logicalVmGroupId'] = params['logical_vm_group_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/logicalVmGroups/{logicalVmGroupId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LogicalVmGroup',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_logical_vm_group_named_vm_groups(self, page, page_size, logical_vm_group_id, **kwargs):
        """
        Get all named vm groups associated with logical vm group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_logical_vm_group_named_vm_groups(page, page_size, logical_vm_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str logical_vm_group_id: (required)
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: EntityReferences
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_logical_vm_group_named_vm_groups_with_http_info(page, page_size, logical_vm_group_id, **kwargs)
        else:
            (data) = self.get_logical_vm_group_named_vm_groups_with_http_info(page, page_size, logical_vm_group_id, **kwargs)
            return data

    def get_logical_vm_group_named_vm_groups_with_http_info(self, page, page_size, logical_vm_group_id, **kwargs):
        """
        Get all named vm groups associated with logical vm group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_logical_vm_group_named_vm_groups_with_http_info(page, page_size, logical_vm_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str logical_vm_group_id: (required)
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: EntityReferences
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'page_size', 'logical_vm_group_id', 'sort_asc', 'sort_desc']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_logical_vm_group_named_vm_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page' is set
        if ('page' not in params) or (params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_logical_vm_group_named_vm_groups`")
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params) or (params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_logical_vm_group_named_vm_groups`")
        # verify the required parameter 'logical_vm_group_id' is set
        if ('logical_vm_group_id' not in params) or (params['logical_vm_group_id'] is None):
            raise ValueError("Missing the required parameter `logical_vm_group_id` when calling `get_logical_vm_group_named_vm_groups`")

        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `get_logical_vm_group_named_vm_groups`, must be a value greater than or equal to `1`")
        if 'page_size' in params and params['page_size'] > 128:
            raise ValueError("Invalid value for parameter `page_size` when calling `get_logical_vm_group_named_vm_groups`, must be a value less than or equal to `128`")
        if 'page_size' in params and params['page_size'] < 0:
            raise ValueError("Invalid value for parameter `page_size` when calling `get_logical_vm_group_named_vm_groups`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}
        if 'logical_vm_group_id' in params:
            path_params['logicalVmGroupId'] = params['logical_vm_group_id']

        query_params = []
        if 'sort_asc' in params:
            query_params.append(('sortAsc', params['sort_asc']))
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/logicalVmGroups/{logicalVmGroupId}/namedVmGroups', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EntityReferences',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pvdc_policies_for_logical_vm_group(self, page, page_size, logical_vm_group_id, **kwargs):
        """
        Get all pvdc policies associated with logical vm group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pvdc_policies_for_logical_vm_group(page, page_size, logical_vm_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str logical_vm_group_id: (required)
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: EntityReferences
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pvdc_policies_for_logical_vm_group_with_http_info(page, page_size, logical_vm_group_id, **kwargs)
        else:
            (data) = self.get_pvdc_policies_for_logical_vm_group_with_http_info(page, page_size, logical_vm_group_id, **kwargs)
            return data

    def get_pvdc_policies_for_logical_vm_group_with_http_info(self, page, page_size, logical_vm_group_id, **kwargs):
        """
        Get all pvdc policies associated with logical vm group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pvdc_policies_for_logical_vm_group_with_http_info(page, page_size, logical_vm_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str logical_vm_group_id: (required)
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: EntityReferences
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'page_size', 'logical_vm_group_id', 'sort_asc', 'sort_desc']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pvdc_policies_for_logical_vm_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page' is set
        if ('page' not in params) or (params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_pvdc_policies_for_logical_vm_group`")
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params) or (params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_pvdc_policies_for_logical_vm_group`")
        # verify the required parameter 'logical_vm_group_id' is set
        if ('logical_vm_group_id' not in params) or (params['logical_vm_group_id'] is None):
            raise ValueError("Missing the required parameter `logical_vm_group_id` when calling `get_pvdc_policies_for_logical_vm_group`")

        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `get_pvdc_policies_for_logical_vm_group`, must be a value greater than or equal to `1`")
        if 'page_size' in params and params['page_size'] > 128:
            raise ValueError("Invalid value for parameter `page_size` when calling `get_pvdc_policies_for_logical_vm_group`, must be a value less than or equal to `128`")
        if 'page_size' in params and params['page_size'] < 0:
            raise ValueError("Invalid value for parameter `page_size` when calling `get_pvdc_policies_for_logical_vm_group`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}
        if 'logical_vm_group_id' in params:
            path_params['logicalVmGroupId'] = params['logical_vm_group_id']

        query_params = []
        if 'sort_asc' in params:
            query_params.append(('sortAsc', params['sort_asc']))
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/logicalVmGroups/{logicalVmGroupId}/pvdcPolicies', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EntityReferences',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def query_logical_vm_groups(self, page, page_size, **kwargs):
        """
        Get list of logical vm groups.
        Get list of logical vm groups. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_logical_vm_groups(page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: LogicalVmGroups
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.query_logical_vm_groups_with_http_info(page, page_size, **kwargs)
        else:
            (data) = self.query_logical_vm_groups_with_http_info(page, page_size, **kwargs)
            return data

    def query_logical_vm_groups_with_http_info(self, page, page_size, **kwargs):
        """
        Get list of logical vm groups.
        Get list of logical vm groups. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_logical_vm_groups_with_http_info(page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: LogicalVmGroups
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'page_size', 'filter', 'sort_asc', 'sort_desc']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_logical_vm_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page' is set
        if ('page' not in params) or (params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `query_logical_vm_groups`")
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params) or (params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `query_logical_vm_groups`")

        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `query_logical_vm_groups`, must be a value greater than or equal to `1`")
        if 'page_size' in params and params['page_size'] > 128:
            raise ValueError("Invalid value for parameter `page_size` when calling `query_logical_vm_groups`, must be a value less than or equal to `128`")
        if 'page_size' in params and params['page_size'] < 0:
            raise ValueError("Invalid value for parameter `page_size` when calling `query_logical_vm_groups`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'sort_asc' in params:
            query_params.append(('sortAsc', params['sort_asc']))
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/logicalVmGroups', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LogicalVmGroups',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_logical_vm_group(self, update_logical_vm_group_params, logical_vm_group_id, **kwargs):
        """
        Update specified logical vm group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_logical_vm_group(update_logical_vm_group_params, logical_vm_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param LogicalVmGroup update_logical_vm_group_params: (required)
        :param str logical_vm_group_id: (required)
        :return: LogicalVmGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_logical_vm_group_with_http_info(update_logical_vm_group_params, logical_vm_group_id, **kwargs)
        else:
            (data) = self.update_logical_vm_group_with_http_info(update_logical_vm_group_params, logical_vm_group_id, **kwargs)
            return data

    def update_logical_vm_group_with_http_info(self, update_logical_vm_group_params, logical_vm_group_id, **kwargs):
        """
        Update specified logical vm group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_logical_vm_group_with_http_info(update_logical_vm_group_params, logical_vm_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param LogicalVmGroup update_logical_vm_group_params: (required)
        :param str logical_vm_group_id: (required)
        :return: LogicalVmGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['update_logical_vm_group_params', 'logical_vm_group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_logical_vm_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'update_logical_vm_group_params' is set
        if ('update_logical_vm_group_params' not in params) or (params['update_logical_vm_group_params'] is None):
            raise ValueError("Missing the required parameter `update_logical_vm_group_params` when calling `update_logical_vm_group`")
        # verify the required parameter 'logical_vm_group_id' is set
        if ('logical_vm_group_id' not in params) or (params['logical_vm_group_id'] is None):
            raise ValueError("Missing the required parameter `logical_vm_group_id` when calling `update_logical_vm_group`")


        collection_formats = {}

        path_params = {}
        if 'logical_vm_group_id' in params:
            path_params['logicalVmGroupId'] = params['logical_vm_group_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_logical_vm_group_params' in params:
            body_params = params['update_logical_vm_group_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/logicalVmGroups/{logicalVmGroupId}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LogicalVmGroup',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
