# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class CertificateLibraryApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def add_certificate_library_item(self, new_certificate_library_item, **kwargs):
        """
        Add an item to the certificate library
        Add an item to the certificate library 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_certificate_library_item(new_certificate_library_item, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CertificateLibraryItem new_certificate_library_item: (required)
        :return: CertificateLibraryItem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_certificate_library_item_with_http_info(new_certificate_library_item, **kwargs)
        else:
            (data) = self.add_certificate_library_item_with_http_info(new_certificate_library_item, **kwargs)
            return data

    def add_certificate_library_item_with_http_info(self, new_certificate_library_item, **kwargs):
        """
        Add an item to the certificate library
        Add an item to the certificate library 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_certificate_library_item_with_http_info(new_certificate_library_item, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CertificateLibraryItem new_certificate_library_item: (required)
        :return: CertificateLibraryItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['new_certificate_library_item']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_certificate_library_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'new_certificate_library_item' is set
        if ('new_certificate_library_item' not in params) or (params['new_certificate_library_item'] is None):
            raise ValueError("Missing the required parameter `new_certificate_library_item` when calling `add_certificate_library_item`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'new_certificate_library_item' in params:
            body_params = params['new_certificate_library_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/ssl/certificateLibrary', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CertificateLibraryItem',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def add_consumer_ref_to_cert_library_item(self, consumer_reference, cert_library_item_id, **kwargs):
        """
        Adds the specified consumer reference to a library item.
        Adds the specified consumer reference to a library item. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_consumer_ref_to_cert_library_item(consumer_reference, cert_library_item_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param EntityReference consumer_reference: (required)
        :param str cert_library_item_id: (required)
        :return: EntityReference
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_consumer_ref_to_cert_library_item_with_http_info(consumer_reference, cert_library_item_id, **kwargs)
        else:
            (data) = self.add_consumer_ref_to_cert_library_item_with_http_info(consumer_reference, cert_library_item_id, **kwargs)
            return data

    def add_consumer_ref_to_cert_library_item_with_http_info(self, consumer_reference, cert_library_item_id, **kwargs):
        """
        Adds the specified consumer reference to a library item.
        Adds the specified consumer reference to a library item. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_consumer_ref_to_cert_library_item_with_http_info(consumer_reference, cert_library_item_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param EntityReference consumer_reference: (required)
        :param str cert_library_item_id: (required)
        :return: EntityReference
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['consumer_reference', 'cert_library_item_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_consumer_ref_to_cert_library_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'consumer_reference' is set
        if ('consumer_reference' not in params) or (params['consumer_reference'] is None):
            raise ValueError("Missing the required parameter `consumer_reference` when calling `add_consumer_ref_to_cert_library_item`")
        # verify the required parameter 'cert_library_item_id' is set
        if ('cert_library_item_id' not in params) or (params['cert_library_item_id'] is None):
            raise ValueError("Missing the required parameter `cert_library_item_id` when calling `add_consumer_ref_to_cert_library_item`")


        collection_formats = {}

        path_params = {}
        if 'cert_library_item_id' in params:
            path_params['certLibraryItemId'] = params['cert_library_item_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'consumer_reference' in params:
            body_params = params['consumer_reference']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/ssl/certificateLibrary/{certLibraryItemId}/consumers', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EntityReference',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_certificate_library_item(self, id, **kwargs):
        """
        Remove certificate library item.
        Delete the specified certificate library item. Only items that are not in use can be deleted. Note: This API also supports a former (erroneously spelt) alternate path /cetificateLibrary/{id} as a Deprecated API (deprecated-in and removed after API version 36.0) 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_certificate_library_item(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_certificate_library_item_with_http_info(id, **kwargs)
        else:
            (data) = self.delete_certificate_library_item_with_http_info(id, **kwargs)
            return data

    def delete_certificate_library_item_with_http_info(self, id, **kwargs):
        """
        Remove certificate library item.
        Delete the specified certificate library item. Only items that are not in use can be deleted. Note: This API also supports a former (erroneously spelt) alternate path /cetificateLibrary/{id} as a Deprecated API (deprecated-in and removed after API version 36.0) 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_certificate_library_item_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_certificate_library_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_certificate_library_item`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/ssl/certificateLibrary/{id}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_certificate_library_item(self, id, **kwargs):
        """
        Get the specified certificate library item
        Retrieves the specified certificate library item. Note: This API also supports a former (erroneously spelt) alternate path /cetificateLibrary/{id} as a Deprecated API (deprecated-in and removed after API version 36.0) 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_certificate_library_item(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: (required)
        :return: CertificateLibraryItem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_certificate_library_item_with_http_info(id, **kwargs)
        else:
            (data) = self.get_certificate_library_item_with_http_info(id, **kwargs)
            return data

    def get_certificate_library_item_with_http_info(self, id, **kwargs):
        """
        Get the specified certificate library item
        Retrieves the specified certificate library item. Note: This API also supports a former (erroneously spelt) alternate path /cetificateLibrary/{id} as a Deprecated API (deprecated-in and removed after API version 36.0) 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_certificate_library_item_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: (required)
        :return: CertificateLibraryItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_certificate_library_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_certificate_library_item`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/ssl/certificateLibrary/{id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CertificateLibraryItem',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def query_cert_library_item_consumer_refs(self, page, page_size, cert_library_item_id, **kwargs):
        """
        Gets a paged list of consumers (as references) of a particular certificate library item
        Get list of consumers (as references) of a particular certificate library item 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_cert_library_item_consumer_refs(page, page_size, cert_library_item_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str cert_library_item_id: (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: EntityReferences
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.query_cert_library_item_consumer_refs_with_http_info(page, page_size, cert_library_item_id, **kwargs)
        else:
            (data) = self.query_cert_library_item_consumer_refs_with_http_info(page, page_size, cert_library_item_id, **kwargs)
            return data

    def query_cert_library_item_consumer_refs_with_http_info(self, page, page_size, cert_library_item_id, **kwargs):
        """
        Gets a paged list of consumers (as references) of a particular certificate library item
        Get list of consumers (as references) of a particular certificate library item 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_cert_library_item_consumer_refs_with_http_info(page, page_size, cert_library_item_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str cert_library_item_id: (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: EntityReferences
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'page_size', 'cert_library_item_id', 'filter', 'sort_asc', 'sort_desc']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_cert_library_item_consumer_refs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page' is set
        if ('page' not in params) or (params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `query_cert_library_item_consumer_refs`")
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params) or (params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `query_cert_library_item_consumer_refs`")
        # verify the required parameter 'cert_library_item_id' is set
        if ('cert_library_item_id' not in params) or (params['cert_library_item_id'] is None):
            raise ValueError("Missing the required parameter `cert_library_item_id` when calling `query_cert_library_item_consumer_refs`")

        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `query_cert_library_item_consumer_refs`, must be a value greater than or equal to `1`")
        if 'page_size' in params and params['page_size'] > 128:
            raise ValueError("Invalid value for parameter `page_size` when calling `query_cert_library_item_consumer_refs`, must be a value less than or equal to `128`")
        if 'page_size' in params and params['page_size'] < 0:
            raise ValueError("Invalid value for parameter `page_size` when calling `query_cert_library_item_consumer_refs`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}
        if 'cert_library_item_id' in params:
            path_params['certLibraryItemId'] = params['cert_library_item_id']

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'sort_asc' in params:
            query_params.append(('sortAsc', params['sort_asc']))
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/ssl/certificateLibrary/{certLibraryItemId}/consumers', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EntityReferences',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def query_certificate_library(self, page, page_size, **kwargs):
        """
        Get the certificate libray items
        Get a list of the certificate library items 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_certificate_library(page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: CertificateLibraryItems
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.query_certificate_library_with_http_info(page, page_size, **kwargs)
        else:
            (data) = self.query_certificate_library_with_http_info(page, page_size, **kwargs)
            return data

    def query_certificate_library_with_http_info(self, page, page_size, **kwargs):
        """
        Get the certificate libray items
        Get a list of the certificate library items 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_certificate_library_with_http_info(page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: CertificateLibraryItems
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'page_size', 'filter', 'sort_asc', 'sort_desc']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_certificate_library" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page' is set
        if ('page' not in params) or (params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `query_certificate_library`")
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params) or (params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `query_certificate_library`")

        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `query_certificate_library`, must be a value greater than or equal to `1`")
        if 'page_size' in params and params['page_size'] > 128:
            raise ValueError("Invalid value for parameter `page_size` when calling `query_certificate_library`, must be a value less than or equal to `128`")
        if 'page_size' in params and params['page_size'] < 0:
            raise ValueError("Invalid value for parameter `page_size` when calling `query_certificate_library`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'sort_asc' in params:
            query_params.append(('sortAsc', params['sort_asc']))
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/ssl/certificateLibrary', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CertificateLibraryItems',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_cert_library_item_consumer_refs(self, consumer_refs, cert_library_item_id, **kwargs):
        """
        Replaces the existing consumer refs with the used by references supplied.
        Replaces the existing consumer refs with the consumer references supplied. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_cert_library_item_consumer_refs(consumer_refs, cert_library_item_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param EntityReferences consumer_refs: (required)
        :param str cert_library_item_id: (required)
        :return: EntityReferences
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.replace_cert_library_item_consumer_refs_with_http_info(consumer_refs, cert_library_item_id, **kwargs)
        else:
            (data) = self.replace_cert_library_item_consumer_refs_with_http_info(consumer_refs, cert_library_item_id, **kwargs)
            return data

    def replace_cert_library_item_consumer_refs_with_http_info(self, consumer_refs, cert_library_item_id, **kwargs):
        """
        Replaces the existing consumer refs with the used by references supplied.
        Replaces the existing consumer refs with the consumer references supplied. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_cert_library_item_consumer_refs_with_http_info(consumer_refs, cert_library_item_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param EntityReferences consumer_refs: (required)
        :param str cert_library_item_id: (required)
        :return: EntityReferences
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['consumer_refs', 'cert_library_item_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_cert_library_item_consumer_refs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'consumer_refs' is set
        if ('consumer_refs' not in params) or (params['consumer_refs'] is None):
            raise ValueError("Missing the required parameter `consumer_refs` when calling `replace_cert_library_item_consumer_refs`")
        # verify the required parameter 'cert_library_item_id' is set
        if ('cert_library_item_id' not in params) or (params['cert_library_item_id'] is None):
            raise ValueError("Missing the required parameter `cert_library_item_id` when calling `replace_cert_library_item_consumer_refs`")


        collection_formats = {}

        path_params = {}
        if 'cert_library_item_id' in params:
            path_params['certLibraryItemId'] = params['cert_library_item_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'consumer_refs' in params:
            body_params = params['consumer_refs']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/ssl/certificateLibrary/{certLibraryItemId}/consumers', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EntityReferences',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_certificate_library_item(self, modified_certificat_library_item, id, **kwargs):
        """
        Update the specified certificate library item.
        Updates the specified certificate library item. Only the alias and description fields may be edited Note: This API also supports a former (erroneously spelt) alternate path /cetificateLibrary/{id} as a Deprecated API (deprecated-in and removed after API version 36.0) 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_certificate_library_item(modified_certificat_library_item, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CertificateLibraryItem modified_certificat_library_item: (required)
        :param str id: (required)
        :return: CertificateLibraryItem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_certificate_library_item_with_http_info(modified_certificat_library_item, id, **kwargs)
        else:
            (data) = self.update_certificate_library_item_with_http_info(modified_certificat_library_item, id, **kwargs)
            return data

    def update_certificate_library_item_with_http_info(self, modified_certificat_library_item, id, **kwargs):
        """
        Update the specified certificate library item.
        Updates the specified certificate library item. Only the alias and description fields may be edited Note: This API also supports a former (erroneously spelt) alternate path /cetificateLibrary/{id} as a Deprecated API (deprecated-in and removed after API version 36.0) 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_certificate_library_item_with_http_info(modified_certificat_library_item, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CertificateLibraryItem modified_certificat_library_item: (required)
        :param str id: (required)
        :return: CertificateLibraryItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['modified_certificat_library_item', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_certificate_library_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'modified_certificat_library_item' is set
        if ('modified_certificat_library_item' not in params) or (params['modified_certificat_library_item'] is None):
            raise ValueError("Missing the required parameter `modified_certificat_library_item` when calling `update_certificate_library_item`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_certificate_library_item`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'modified_certificat_library_item' in params:
            body_params = params['modified_certificat_library_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/ssl/certificateLibrary/{id}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CertificateLibraryItem',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
