# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class AdvisoryApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_advisory_definition(self, new_advisory_definition, **kwargs):
        """
        Create a new advisory definition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_advisory_definition(new_advisory_definition, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AdvisoryDefinition new_advisory_definition: (required)
        :return: AdvisoryDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_advisory_definition_with_http_info(new_advisory_definition, **kwargs)
        else:
            (data) = self.create_advisory_definition_with_http_info(new_advisory_definition, **kwargs)
            return data

    def create_advisory_definition_with_http_info(self, new_advisory_definition, **kwargs):
        """
        Create a new advisory definition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_advisory_definition_with_http_info(new_advisory_definition, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AdvisoryDefinition new_advisory_definition: (required)
        :return: AdvisoryDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['new_advisory_definition']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_advisory_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'new_advisory_definition' is set
        if ('new_advisory_definition' not in params) or (params['new_advisory_definition'] is None):
            raise ValueError("Missing the required parameter `new_advisory_definition` when calling `create_advisory_definition`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'new_advisory_definition' in params:
            body_params = params['new_advisory_definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/definitions/advisories', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AdvisoryDefinition',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_advisory_definition(self, advisory_id, **kwargs):
        """
        Delete the advisory with the associated specified id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_advisory_definition(advisory_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str advisory_id: advisory URN (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_advisory_definition_with_http_info(advisory_id, **kwargs)
        else:
            (data) = self.delete_advisory_definition_with_http_info(advisory_id, **kwargs)
            return data

    def delete_advisory_definition_with_http_info(self, advisory_id, **kwargs):
        """
        Delete the advisory with the associated specified id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_advisory_definition_with_http_info(advisory_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str advisory_id: advisory URN (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['advisory_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_advisory_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'advisory_id' is set
        if ('advisory_id' not in params) or (params['advisory_id'] is None):
            raise ValueError("Missing the required parameter `advisory_id` when calling `delete_advisory_definition`")


        collection_formats = {}

        path_params = {}
        if 'advisory_id' in params:
            path_params['advisoryId'] = params['advisory_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/definitions/advisories/{advisoryId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_advisory(self, advisory_id, **kwargs):
        """
        Get the advisory with the specified id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_advisory(advisory_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str advisory_id: advisory URN (required)
        :return: Advisory
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_advisory_with_http_info(advisory_id, **kwargs)
        else:
            (data) = self.get_advisory_with_http_info(advisory_id, **kwargs)
            return data

    def get_advisory_with_http_info(self, advisory_id, **kwargs):
        """
        Get the advisory with the specified id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_advisory_with_http_info(advisory_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str advisory_id: advisory URN (required)
        :return: Advisory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['advisory_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_advisory" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'advisory_id' is set
        if ('advisory_id' not in params) or (params['advisory_id'] is None):
            raise ValueError("Missing the required parameter `advisory_id` when calling `get_advisory`")


        collection_formats = {}

        path_params = {}
        if 'advisory_id' in params:
            path_params['advisoryId'] = params['advisory_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/advisories/{advisoryId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Advisory',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_advisory_definition(self, advisory_id, **kwargs):
        """
        Get the advisory definition with the specified id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_advisory_definition(advisory_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str advisory_id: advisory URN (required)
        :return: AdvisoryDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_advisory_definition_with_http_info(advisory_id, **kwargs)
        else:
            (data) = self.get_advisory_definition_with_http_info(advisory_id, **kwargs)
            return data

    def get_advisory_definition_with_http_info(self, advisory_id, **kwargs):
        """
        Get the advisory definition with the specified id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_advisory_definition_with_http_info(advisory_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str advisory_id: advisory URN (required)
        :return: AdvisoryDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['advisory_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_advisory_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'advisory_id' is set
        if ('advisory_id' not in params) or (params['advisory_id'] is None):
            raise ValueError("Missing the required parameter `advisory_id` when calling `get_advisory_definition`")


        collection_formats = {}

        path_params = {}
        if 'advisory_id' in params:
            path_params['advisoryId'] = params['advisory_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/definitions/advisories/{advisoryId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AdvisoryDefinition',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def query_advisories(self, page, page_size, **kwargs):
        """
        Get a list of all advisories accessible to the user.
        Get a list of all advisories accessible to the user. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_advisories(page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: Advisories
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.query_advisories_with_http_info(page, page_size, **kwargs)
        else:
            (data) = self.query_advisories_with_http_info(page, page_size, **kwargs)
            return data

    def query_advisories_with_http_info(self, page, page_size, **kwargs):
        """
        Get a list of all advisories accessible to the user.
        Get a list of all advisories accessible to the user. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_advisories_with_http_info(page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: Advisories
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'page_size', 'filter', 'sort_asc', 'sort_desc']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_advisories" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page' is set
        if ('page' not in params) or (params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `query_advisories`")
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params) or (params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `query_advisories`")

        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `query_advisories`, must be a value greater than or equal to `1`")
        if 'page_size' in params and params['page_size'] > 128:
            raise ValueError("Invalid value for parameter `page_size` when calling `query_advisories`, must be a value less than or equal to `128`")
        if 'page_size' in params and params['page_size'] < 0:
            raise ValueError("Invalid value for parameter `page_size` when calling `query_advisories`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'sort_asc' in params:
            query_params.append(('sortAsc', params['sort_asc']))
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/advisories', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Advisories',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def query_advisory_definitions(self, page, page_size, **kwargs):
        """
        Get a list of all advisory definitions.
        Get a list of all advisory definitions. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_advisory_definitions(page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: AdvisoryDefinitions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.query_advisory_definitions_with_http_info(page, page_size, **kwargs)
        else:
            (data) = self.query_advisory_definitions_with_http_info(page, page_size, **kwargs)
            return data

    def query_advisory_definitions_with_http_info(self, page, page_size, **kwargs):
        """
        Get a list of all advisory definitions.
        Get a list of all advisory definitions. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_advisory_definitions_with_http_info(page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: AdvisoryDefinitions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'page_size', 'filter', 'sort_asc', 'sort_desc']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_advisory_definitions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page' is set
        if ('page' not in params) or (params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `query_advisory_definitions`")
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params) or (params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `query_advisory_definitions`")

        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `query_advisory_definitions`, must be a value greater than or equal to `1`")
        if 'page_size' in params and params['page_size'] > 128:
            raise ValueError("Invalid value for parameter `page_size` when calling `query_advisory_definitions`, must be a value less than or equal to `128`")
        if 'page_size' in params and params['page_size'] < 0:
            raise ValueError("Invalid value for parameter `page_size` when calling `query_advisory_definitions`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'sort_asc' in params:
            query_params.append(('sortAsc', params['sort_asc']))
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/definitions/advisories', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AdvisoryDefinitions',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_advisory(self, modified_advisory, advisory_id, **kwargs):
        """
        Updates an advisory.
        Updates an advisory for the active session using a specified id. Advisories that have a MANDATORY priority may not be updated. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_advisory(modified_advisory, advisory_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Advisory modified_advisory: (required)
        :param str advisory_id: advisory URN (required)
        :return: Advisory
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_advisory_with_http_info(modified_advisory, advisory_id, **kwargs)
        else:
            (data) = self.update_advisory_with_http_info(modified_advisory, advisory_id, **kwargs)
            return data

    def update_advisory_with_http_info(self, modified_advisory, advisory_id, **kwargs):
        """
        Updates an advisory.
        Updates an advisory for the active session using a specified id. Advisories that have a MANDATORY priority may not be updated. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_advisory_with_http_info(modified_advisory, advisory_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Advisory modified_advisory: (required)
        :param str advisory_id: advisory URN (required)
        :return: Advisory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['modified_advisory', 'advisory_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_advisory" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'modified_advisory' is set
        if ('modified_advisory' not in params) or (params['modified_advisory'] is None):
            raise ValueError("Missing the required parameter `modified_advisory` when calling `update_advisory`")
        # verify the required parameter 'advisory_id' is set
        if ('advisory_id' not in params) or (params['advisory_id'] is None):
            raise ValueError("Missing the required parameter `advisory_id` when calling `update_advisory`")


        collection_formats = {}

        path_params = {}
        if 'advisory_id' in params:
            path_params['advisoryId'] = params['advisory_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'modified_advisory' in params:
            body_params = params['modified_advisory']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/advisories/{advisoryId}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Advisory',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
