"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .identifiable_resource_type import IdentifiableResourceType


class VirtualHardwareVersionType(IdentifiableResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'max_cores_per_socket': 'int',
        'supported_operating_systems': 'SupportedOperatingSystemsInfoType',
        'max_memory_size_mb': 'int',
        'max_cp_us': 'int',
        'max_ni_cs': 'int',
        'supports_nested_hv': 'bool',
        'supports_hot_plug_pci': 'bool',
        'supports_hot_add': 'bool',
        'supported_memory_size_gb': 'list[int]',
        'supported_cores_per_socket': 'list[int]',
        'hard_disk_adapter': 'list[HardDiskAdapterType]'
    }

    attribute_map = {
        'name': 'name',
        'max_cores_per_socket': 'maxCoresPerSocket',
        'supported_operating_systems': 'supportedOperatingSystems',
        'max_memory_size_mb': 'maxMemorySizeMb',
        'max_cp_us': 'maxCPUs',
        'max_ni_cs': 'maxNICs',
        'supports_nested_hv': 'supportsNestedHV',
        'supports_hot_plug_pci': 'supportsHotPlugPCI',
        'supports_hot_add': 'supportsHotAdd',
        'supported_memory_size_gb': 'supportedMemorySizeGb',
        'supported_cores_per_socket': 'supportedCoresPerSocket',
        'hard_disk_adapter': 'hardDiskAdapter'
    }

    def __init__(self, name=None,max_cores_per_socket=None,supported_operating_systems=None,max_memory_size_mb=None,max_cp_us=None,max_ni_cs=None,supports_nested_hv=None,supports_hot_plug_pci=None,supports_hot_add=None,supported_memory_size_gb=None,supported_cores_per_socket=None,hard_disk_adapter=None):
        self._name = None
        self._max_cores_per_socket = None
        self._supported_operating_systems = None
        self._max_memory_size_mb = None
        self._max_cp_us = None
        self._max_ni_cs = None
        self._supports_nested_hv = None
        self._supports_hot_plug_pci = None
        self._supports_hot_add = None
        self._supported_memory_size_gb = None
        self._supported_cores_per_socket = None
        self._hard_disk_adapter = None

        if name is not None:
            self.name = name
        if max_cores_per_socket is not None:
            self.max_cores_per_socket = max_cores_per_socket
        if supported_operating_systems is not None:
            self.supported_operating_systems = supported_operating_systems
        if max_memory_size_mb is not None:
            self.max_memory_size_mb = max_memory_size_mb
        if max_cp_us is not None:
            self.max_cp_us = max_cp_us
        if max_ni_cs is not None:
            self.max_ni_cs = max_ni_cs
        if supports_nested_hv is not None:
            self.supports_nested_hv = supports_nested_hv
        if supports_hot_plug_pci is not None:
            self.supports_hot_plug_pci = supports_hot_plug_pci
        if supports_hot_add is not None:
            self.supports_hot_add = supports_hot_add
        if supported_memory_size_gb is not None:
            self.supported_memory_size_gb = supported_memory_size_gb
        if supported_cores_per_socket is not None:
            self.supported_cores_per_socket = supported_cores_per_socket
        if hard_disk_adapter is not None:
            self.hard_disk_adapter = hard_disk_adapter

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def max_cores_per_socket(self):
        return self._max_cores_per_socket
    
    @max_cores_per_socket.setter
    def max_cores_per_socket(self, max_cores_per_socket):
        self._max_cores_per_socket = max_cores_per_socket

    @property
    def supported_operating_systems(self):
        return self._supported_operating_systems
    
    @supported_operating_systems.setter
    def supported_operating_systems(self, supported_operating_systems):
        self._supported_operating_systems = supported_operating_systems

    @property
    def max_memory_size_mb(self):
        return self._max_memory_size_mb
    
    @max_memory_size_mb.setter
    def max_memory_size_mb(self, max_memory_size_mb):
        self._max_memory_size_mb = max_memory_size_mb

    @property
    def max_cp_us(self):
        return self._max_cp_us
    
    @max_cp_us.setter
    def max_cp_us(self, max_cp_us):
        self._max_cp_us = max_cp_us

    @property
    def max_ni_cs(self):
        return self._max_ni_cs
    
    @max_ni_cs.setter
    def max_ni_cs(self, max_ni_cs):
        self._max_ni_cs = max_ni_cs

    @property
    def supports_nested_hv(self):
        return self._supports_nested_hv
    
    @supports_nested_hv.setter
    def supports_nested_hv(self, supports_nested_hv):
        self._supports_nested_hv = supports_nested_hv

    @property
    def supports_hot_plug_pci(self):
        return self._supports_hot_plug_pci
    
    @supports_hot_plug_pci.setter
    def supports_hot_plug_pci(self, supports_hot_plug_pci):
        self._supports_hot_plug_pci = supports_hot_plug_pci

    @property
    def supports_hot_add(self):
        return self._supports_hot_add
    
    @supports_hot_add.setter
    def supports_hot_add(self, supports_hot_add):
        self._supports_hot_add = supports_hot_add

    @property
    def supported_memory_size_gb(self):
        return self._supported_memory_size_gb
    
    @supported_memory_size_gb.setter
    def supported_memory_size_gb(self, supported_memory_size_gb):
        self._supported_memory_size_gb = supported_memory_size_gb

    @property
    def supported_cores_per_socket(self):
        return self._supported_cores_per_socket
    
    @supported_cores_per_socket.setter
    def supported_cores_per_socket(self, supported_cores_per_socket):
        self._supported_cores_per_socket = supported_cores_per_socket

    @property
    def hard_disk_adapter(self):
        return self._hard_disk_adapter
    
    @hard_disk_adapter.setter
    def hard_disk_adapter(self, hard_disk_adapter):
        self._hard_disk_adapter = hard_disk_adapter


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualHardwareVersionType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
