"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re


class VdcStorageProfileIopsSettingsType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'enabled': 'bool',
        'disk_iops_max': 'int',
        'disk_iops_default': 'int',
        'storage_profile_iops_limit': 'int',
        'disk_iops_per_gb_max': 'int',
        'ignore_iops_placement': 'bool'
    }

    attribute_map = {
        'enabled': 'enabled',
        'disk_iops_max': 'diskIopsMax',
        'disk_iops_default': 'diskIopsDefault',
        'storage_profile_iops_limit': 'storageProfileIopsLimit',
        'disk_iops_per_gb_max': 'diskIopsPerGbMax',
        'ignore_iops_placement': 'ignoreIopsPlacement'
    }

    def __init__(self, enabled=None,disk_iops_max=None,disk_iops_default=None,storage_profile_iops_limit=None,disk_iops_per_gb_max=None,ignore_iops_placement=None):
        self._enabled = None
        self._disk_iops_max = None
        self._disk_iops_default = None
        self._storage_profile_iops_limit = None
        self._disk_iops_per_gb_max = None
        self._ignore_iops_placement = None

        if enabled is not None:
            self.enabled = enabled
        if disk_iops_max is not None:
            self.disk_iops_max = disk_iops_max
        if disk_iops_default is not None:
            self.disk_iops_default = disk_iops_default
        if storage_profile_iops_limit is not None:
            self.storage_profile_iops_limit = storage_profile_iops_limit
        if disk_iops_per_gb_max is not None:
            self.disk_iops_per_gb_max = disk_iops_per_gb_max
        if ignore_iops_placement is not None:
            self.ignore_iops_placement = ignore_iops_placement

    @property
    def enabled(self):
        return self._enabled
    
    @enabled.setter
    def enabled(self, enabled):
        self._enabled = enabled

    @property
    def disk_iops_max(self):
        return self._disk_iops_max
    
    @disk_iops_max.setter
    def disk_iops_max(self, disk_iops_max):
        self._disk_iops_max = disk_iops_max

    @property
    def disk_iops_default(self):
        return self._disk_iops_default
    
    @disk_iops_default.setter
    def disk_iops_default(self, disk_iops_default):
        self._disk_iops_default = disk_iops_default

    @property
    def storage_profile_iops_limit(self):
        return self._storage_profile_iops_limit
    
    @storage_profile_iops_limit.setter
    def storage_profile_iops_limit(self, storage_profile_iops_limit):
        self._storage_profile_iops_limit = storage_profile_iops_limit

    @property
    def disk_iops_per_gb_max(self):
        return self._disk_iops_per_gb_max
    
    @disk_iops_per_gb_max.setter
    def disk_iops_per_gb_max(self, disk_iops_per_gb_max):
        self._disk_iops_per_gb_max = disk_iops_per_gb_max

    @property
    def ignore_iops_placement(self):
        return self._ignore_iops_placement
    
    @ignore_iops_placement.setter
    def ignore_iops_placement(self, ignore_iops_placement):
        self._ignore_iops_placement = ignore_iops_placement


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VdcStorageProfileIopsSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
