"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .entity_type import EntityType


class UserType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'full_name': 'str',
        'email_address': 'str',
        'telephone': 'str',
        'is_enabled': 'bool',
        'is_locked': 'bool',
        'im': 'str',
        'name_in_source': 'str',
        'is_external': 'bool',
        'provider_type': 'str',
        'is_group_role': 'bool',
        'stored_vm_quota': 'int',
        'deployed_vm_quota': 'int',
        'role': 'ReferenceType',
        'password': 'str',
        'group_references': 'GroupsListType'
    }

    attribute_map = {
        'full_name': 'fullName',
        'email_address': 'emailAddress',
        'telephone': 'telephone',
        'is_enabled': 'isEnabled',
        'is_locked': 'isLocked',
        'im': 'im',
        'name_in_source': 'nameInSource',
        'is_external': 'isExternal',
        'provider_type': 'providerType',
        'is_group_role': 'isGroupRole',
        'stored_vm_quota': 'storedVmQuota',
        'deployed_vm_quota': 'deployedVmQuota',
        'role': 'role',
        'password': 'password',
        'group_references': 'groupReferences'
    }

    def __init__(self, full_name=None,email_address=None,telephone=None,is_enabled=None,is_locked=None,im=None,name_in_source=None,is_external=None,provider_type=None,is_group_role=None,stored_vm_quota=None,deployed_vm_quota=None,role=None,password=None,group_references=None):
        self._full_name = None
        self._email_address = None
        self._telephone = None
        self._is_enabled = None
        self._is_locked = None
        self._im = None
        self._name_in_source = None
        self._is_external = None
        self._provider_type = None
        self._is_group_role = None
        self._stored_vm_quota = None
        self._deployed_vm_quota = None
        self._role = None
        self._password = None
        self._group_references = None

        if full_name is not None:
            self.full_name = full_name
        if email_address is not None:
            self.email_address = email_address
        if telephone is not None:
            self.telephone = telephone
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if is_locked is not None:
            self.is_locked = is_locked
        if im is not None:
            self.im = im
        if name_in_source is not None:
            self.name_in_source = name_in_source
        if is_external is not None:
            self.is_external = is_external
        if provider_type is not None:
            self.provider_type = provider_type
        if is_group_role is not None:
            self.is_group_role = is_group_role
        if stored_vm_quota is not None:
            self.stored_vm_quota = stored_vm_quota
        if deployed_vm_quota is not None:
            self.deployed_vm_quota = deployed_vm_quota
        if role is not None:
            self.role = role
        if password is not None:
            self.password = password
        if group_references is not None:
            self.group_references = group_references

    @property
    def full_name(self):
        return self._full_name
    
    @full_name.setter
    def full_name(self, full_name):
        self._full_name = full_name

    @property
    def email_address(self):
        return self._email_address
    
    @email_address.setter
    def email_address(self, email_address):
        self._email_address = email_address

    @property
    def telephone(self):
        return self._telephone
    
    @telephone.setter
    def telephone(self, telephone):
        self._telephone = telephone

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def is_locked(self):
        return self._is_locked
    
    @is_locked.setter
    def is_locked(self, is_locked):
        self._is_locked = is_locked

    @property
    def im(self):
        return self._im
    
    @im.setter
    def im(self, im):
        self._im = im

    @property
    def name_in_source(self):
        return self._name_in_source
    
    @name_in_source.setter
    def name_in_source(self, name_in_source):
        self._name_in_source = name_in_source

    @property
    def is_external(self):
        return self._is_external
    
    @is_external.setter
    def is_external(self, is_external):
        self._is_external = is_external

    @property
    def provider_type(self):
        return self._provider_type
    
    @provider_type.setter
    def provider_type(self, provider_type):
        self._provider_type = provider_type

    @property
    def is_group_role(self):
        return self._is_group_role
    
    @is_group_role.setter
    def is_group_role(self, is_group_role):
        self._is_group_role = is_group_role

    @property
    def stored_vm_quota(self):
        return self._stored_vm_quota
    
    @stored_vm_quota.setter
    def stored_vm_quota(self, stored_vm_quota):
        self._stored_vm_quota = stored_vm_quota

    @property
    def deployed_vm_quota(self):
        return self._deployed_vm_quota
    
    @deployed_vm_quota.setter
    def deployed_vm_quota(self, deployed_vm_quota):
        self._deployed_vm_quota = deployed_vm_quota

    @property
    def role(self):
        return self._role
    
    @role.setter
    def role(self, role):
        self._role = role

    @property
    def password(self):
        return self._password
    
    @password.setter
    def password(self, password):
        self._password = password

    @property
    def group_references(self):
        return self._group_references
    
    @group_references.setter
    def group_references(self, group_references):
        self._group_references = group_references


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
