"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class SubnetParticipationType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gateway': 'str',
        'netmask': 'str',
        'subnet_prefix_length': 'int',
        'ip_address': 'str',
        'ip_ranges': 'IpRangesType',
        'use_for_default_route': 'bool',
        'total_ip_count': 'int',
        'auto_allocate_ip_ranges': 'bool'
    }

    attribute_map = {
        'gateway': 'gateway',
        'netmask': 'netmask',
        'subnet_prefix_length': 'subnetPrefixLength',
        'ip_address': 'ipAddress',
        'ip_ranges': 'ipRanges',
        'use_for_default_route': 'useForDefaultRoute',
        'total_ip_count': 'totalIpCount',
        'auto_allocate_ip_ranges': 'autoAllocateIpRanges'
    }

    def __init__(self, gateway=None,netmask=None,subnet_prefix_length=None,ip_address=None,ip_ranges=None,use_for_default_route=None,total_ip_count=None,auto_allocate_ip_ranges=None):
        self._gateway = None
        self._netmask = None
        self._subnet_prefix_length = None
        self._ip_address = None
        self._ip_ranges = None
        self._use_for_default_route = None
        self._total_ip_count = None
        self._auto_allocate_ip_ranges = None

        if gateway is not None:
            self.gateway = gateway
        if netmask is not None:
            self.netmask = netmask
        if subnet_prefix_length is not None:
            self.subnet_prefix_length = subnet_prefix_length
        if ip_address is not None:
            self.ip_address = ip_address
        if ip_ranges is not None:
            self.ip_ranges = ip_ranges
        if use_for_default_route is not None:
            self.use_for_default_route = use_for_default_route
        if total_ip_count is not None:
            self.total_ip_count = total_ip_count
        if auto_allocate_ip_ranges is not None:
            self.auto_allocate_ip_ranges = auto_allocate_ip_ranges

    @property
    def gateway(self):
        return self._gateway
    
    @gateway.setter
    def gateway(self, gateway):
        self._gateway = gateway

    @property
    def netmask(self):
        return self._netmask
    
    @netmask.setter
    def netmask(self, netmask):
        self._netmask = netmask

    @property
    def subnet_prefix_length(self):
        return self._subnet_prefix_length
    
    @subnet_prefix_length.setter
    def subnet_prefix_length(self, subnet_prefix_length):
        self._subnet_prefix_length = subnet_prefix_length

    @property
    def ip_address(self):
        return self._ip_address
    
    @ip_address.setter
    def ip_address(self, ip_address):
        self._ip_address = ip_address

    @property
    def ip_ranges(self):
        return self._ip_ranges
    
    @ip_ranges.setter
    def ip_ranges(self, ip_ranges):
        self._ip_ranges = ip_ranges

    @property
    def use_for_default_route(self):
        return self._use_for_default_route
    
    @use_for_default_route.setter
    def use_for_default_route(self, use_for_default_route):
        self._use_for_default_route = use_for_default_route

    @property
    def total_ip_count(self):
        return self._total_ip_count
    
    @total_ip_count.setter
    def total_ip_count(self, total_ip_count):
        self._total_ip_count = total_ip_count

    @property
    def auto_allocate_ip_ranges(self):
        return self._auto_allocate_ip_ranges
    
    @auto_allocate_ip_ranges.setter
    def auto_allocate_ip_ranges(self, auto_allocate_ip_ranges):
        self._auto_allocate_ip_ranges = auto_allocate_ip_ranges


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SubnetParticipationType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
