"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class SubAllocationType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'edge_gateway': 'ReferenceType',
        'ip_ranges': 'IpRangesType'
    }

    attribute_map = {
        'edge_gateway': 'edgeGateway',
        'ip_ranges': 'ipRanges'
    }

    def __init__(self, edge_gateway=None,ip_ranges=None):
        self._edge_gateway = None
        self._ip_ranges = None

        if edge_gateway is not None:
            self.edge_gateway = edge_gateway
        if ip_ranges is not None:
            self.ip_ranges = ip_ranges

    @property
    def edge_gateway(self):
        return self._edge_gateway
    
    @edge_gateway.setter
    def edge_gateway(self, edge_gateway):
        self._edge_gateway = edge_gateway

    @property
    def ip_ranges(self):
        return self._ip_ranges
    
    @ip_ranges.setter
    def ip_ranges(self, ip_ranges):
        self._ip_ranges = ip_ranges


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SubAllocationType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
