"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .file_upload_params_type import FileUploadParamsType


class SspiKeytabUpdateParamsType(FileUploadParamsType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'sspi_service_provider_name': 'str'
    }

    attribute_map = {
        'sspi_service_provider_name': 'sspiServiceProviderName'
    }

    def __init__(self, sspi_service_provider_name=None):
        self._sspi_service_provider_name = None

        if sspi_service_provider_name is not None:
            self.sspi_service_provider_name = sspi_service_provider_name

    @property
    def sspi_service_provider_name(self):
        return self._sspi_service_provider_name
    
    @sspi_service_provider_name.setter
    def sspi_service_provider_name(self, sspi_service_provider_name):
        self._sspi_service_provider_name = sspi_service_provider_name


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SspiKeytabUpdateParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
