"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .identifiable_resource_type import IdentifiableResourceType


class SelectorExtensionType(IdentifiableResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'enabled': 'bool',
        'priority': 'int',
        'object_extension_id': 'str',
        'phases': 'PhasesType'
    }

    attribute_map = {
        'enabled': 'enabled',
        'priority': 'priority',
        'object_extension_id': 'objectExtensionId',
        'phases': 'phases'
    }

    def __init__(self, enabled=None,priority=None,object_extension_id=None,phases=None):
        self._enabled = None
        self._priority = None
        self._object_extension_id = None
        self._phases = None

        if enabled is not None:
            self.enabled = enabled
        if priority is not None:
            self.priority = priority
        if object_extension_id is not None:
            self.object_extension_id = object_extension_id
        if phases is not None:
            self.phases = phases

    @property
    def enabled(self):
        return self._enabled
    
    @enabled.setter
    def enabled(self, enabled):
        self._enabled = enabled

    @property
    def priority(self):
        return self._priority
    
    @priority.setter
    def priority(self, priority):
        self._priority = priority

    @property
    def object_extension_id(self):
        return self._object_extension_id
    
    @object_extension_id.setter
    def object_extension_id(self, object_extension_id):
        self._object_extension_id = object_extension_id

    @property
    def phases(self):
        return self._phases
    
    @phases.setter
    def phases(self, phases):
        self._phases = phases


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SelectorExtensionType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
