"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_type import ResourceType


class SamlAttributeMappingType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'email_attribute_name': 'str',
        'user_name_attribute_name': 'str',
        'first_name_attribute_name': 'str',
        'surname_attribute_name': 'str',
        'full_name_attribute_name': 'str',
        'group_attribute_name': 'str',
        'role_attribute_name': 'str'
    }

    attribute_map = {
        'email_attribute_name': 'emailAttributeName',
        'user_name_attribute_name': 'userNameAttributeName',
        'first_name_attribute_name': 'firstNameAttributeName',
        'surname_attribute_name': 'surnameAttributeName',
        'full_name_attribute_name': 'fullNameAttributeName',
        'group_attribute_name': 'groupAttributeName',
        'role_attribute_name': 'roleAttributeName'
    }

    def __init__(self, email_attribute_name=None,user_name_attribute_name=None,first_name_attribute_name=None,surname_attribute_name=None,full_name_attribute_name=None,group_attribute_name=None,role_attribute_name=None):
        self._email_attribute_name = None
        self._user_name_attribute_name = None
        self._first_name_attribute_name = None
        self._surname_attribute_name = None
        self._full_name_attribute_name = None
        self._group_attribute_name = None
        self._role_attribute_name = None

        if email_attribute_name is not None:
            self.email_attribute_name = email_attribute_name
        if user_name_attribute_name is not None:
            self.user_name_attribute_name = user_name_attribute_name
        if first_name_attribute_name is not None:
            self.first_name_attribute_name = first_name_attribute_name
        if surname_attribute_name is not None:
            self.surname_attribute_name = surname_attribute_name
        if full_name_attribute_name is not None:
            self.full_name_attribute_name = full_name_attribute_name
        if group_attribute_name is not None:
            self.group_attribute_name = group_attribute_name
        if role_attribute_name is not None:
            self.role_attribute_name = role_attribute_name

    @property
    def email_attribute_name(self):
        return self._email_attribute_name
    
    @email_attribute_name.setter
    def email_attribute_name(self, email_attribute_name):
        self._email_attribute_name = email_attribute_name

    @property
    def user_name_attribute_name(self):
        return self._user_name_attribute_name
    
    @user_name_attribute_name.setter
    def user_name_attribute_name(self, user_name_attribute_name):
        self._user_name_attribute_name = user_name_attribute_name

    @property
    def first_name_attribute_name(self):
        return self._first_name_attribute_name
    
    @first_name_attribute_name.setter
    def first_name_attribute_name(self, first_name_attribute_name):
        self._first_name_attribute_name = first_name_attribute_name

    @property
    def surname_attribute_name(self):
        return self._surname_attribute_name
    
    @surname_attribute_name.setter
    def surname_attribute_name(self, surname_attribute_name):
        self._surname_attribute_name = surname_attribute_name

    @property
    def full_name_attribute_name(self):
        return self._full_name_attribute_name
    
    @full_name_attribute_name.setter
    def full_name_attribute_name(self, full_name_attribute_name):
        self._full_name_attribute_name = full_name_attribute_name

    @property
    def group_attribute_name(self):
        return self._group_attribute_name
    
    @group_attribute_name.setter
    def group_attribute_name(self, group_attribute_name):
        self._group_attribute_name = group_attribute_name

    @property
    def role_attribute_name(self):
        return self._role_attribute_name
    
    @role_attribute_name.setter
    def role_attribute_name(self, role_attribute_name):
        self._role_attribute_name = role_attribute_name


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SamlAttributeMappingType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
