"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultVAppTemplateRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'owner_name': 'str',
        'catalog_name': 'str',
        'is_published': 'bool',
        'name': 'str',
        'description': 'str',
        'vdc': 'str',
        'vdc_name': 'str',
        'org': 'str',
        'creation_date': 'str',
        'is_busy': 'bool',
        'is_gold_master': 'bool',
        'is_enabled': 'bool',
        'status': 'str',
        'is_deployed': 'bool',
        'is_expired': 'bool',
        'storage_profile_name': 'str',
        'publish_subscription_type': 'str',
        'version': 'int',
        'last_successful_sync': 'str'
    }

    attribute_map = {
        'owner_name': 'ownerName',
        'catalog_name': 'catalogName',
        'is_published': 'isPublished',
        'name': 'name',
        'description': 'description',
        'vdc': 'vdc',
        'vdc_name': 'vdcName',
        'org': 'org',
        'creation_date': 'creationDate',
        'is_busy': 'isBusy',
        'is_gold_master': 'isGoldMaster',
        'is_enabled': 'isEnabled',
        'status': 'status',
        'is_deployed': 'isDeployed',
        'is_expired': 'isExpired',
        'storage_profile_name': 'storageProfileName',
        'publish_subscription_type': 'publishSubscriptionType',
        'version': 'version',
        'last_successful_sync': 'lastSuccessfulSync'
    }

    def __init__(self, owner_name=None,catalog_name=None,is_published=None,name=None,description=None,vdc=None,vdc_name=None,org=None,creation_date=None,is_busy=None,is_gold_master=None,is_enabled=None,status=None,is_deployed=None,is_expired=None,storage_profile_name=None,publish_subscription_type=None,version=None,last_successful_sync=None):
        self._owner_name = None
        self._catalog_name = None
        self._is_published = None
        self._name = None
        self._description = None
        self._vdc = None
        self._vdc_name = None
        self._org = None
        self._creation_date = None
        self._is_busy = None
        self._is_gold_master = None
        self._is_enabled = None
        self._status = None
        self._is_deployed = None
        self._is_expired = None
        self._storage_profile_name = None
        self._publish_subscription_type = None
        self._version = None
        self._last_successful_sync = None

        if owner_name is not None:
            self.owner_name = owner_name
        if catalog_name is not None:
            self.catalog_name = catalog_name
        if is_published is not None:
            self.is_published = is_published
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if vdc is not None:
            self.vdc = vdc
        if vdc_name is not None:
            self.vdc_name = vdc_name
        if org is not None:
            self.org = org
        if creation_date is not None:
            self.creation_date = creation_date
        if is_busy is not None:
            self.is_busy = is_busy
        if is_gold_master is not None:
            self.is_gold_master = is_gold_master
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if status is not None:
            self.status = status
        if is_deployed is not None:
            self.is_deployed = is_deployed
        if is_expired is not None:
            self.is_expired = is_expired
        if storage_profile_name is not None:
            self.storage_profile_name = storage_profile_name
        if publish_subscription_type is not None:
            self.publish_subscription_type = publish_subscription_type
        if version is not None:
            self.version = version
        if last_successful_sync is not None:
            self.last_successful_sync = last_successful_sync

    @property
    def owner_name(self):
        return self._owner_name
    
    @owner_name.setter
    def owner_name(self, owner_name):
        self._owner_name = owner_name

    @property
    def catalog_name(self):
        return self._catalog_name
    
    @catalog_name.setter
    def catalog_name(self, catalog_name):
        self._catalog_name = catalog_name

    @property
    def is_published(self):
        return self._is_published
    
    @is_published.setter
    def is_published(self, is_published):
        self._is_published = is_published

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def description(self):
        return self._description
    
    @description.setter
    def description(self, description):
        self._description = description

    @property
    def vdc(self):
        return self._vdc
    
    @vdc.setter
    def vdc(self, vdc):
        self._vdc = vdc

    @property
    def vdc_name(self):
        return self._vdc_name
    
    @vdc_name.setter
    def vdc_name(self, vdc_name):
        self._vdc_name = vdc_name

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org

    @property
    def creation_date(self):
        return self._creation_date
    
    @creation_date.setter
    def creation_date(self, creation_date):
        self._creation_date = creation_date

    @property
    def is_busy(self):
        return self._is_busy
    
    @is_busy.setter
    def is_busy(self, is_busy):
        self._is_busy = is_busy

    @property
    def is_gold_master(self):
        return self._is_gold_master
    
    @is_gold_master.setter
    def is_gold_master(self, is_gold_master):
        self._is_gold_master = is_gold_master

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status

    @property
    def is_deployed(self):
        return self._is_deployed
    
    @is_deployed.setter
    def is_deployed(self, is_deployed):
        self._is_deployed = is_deployed

    @property
    def is_expired(self):
        return self._is_expired
    
    @is_expired.setter
    def is_expired(self, is_expired):
        self._is_expired = is_expired

    @property
    def storage_profile_name(self):
        return self._storage_profile_name
    
    @storage_profile_name.setter
    def storage_profile_name(self, storage_profile_name):
        self._storage_profile_name = storage_profile_name

    @property
    def publish_subscription_type(self):
        return self._publish_subscription_type
    
    @publish_subscription_type.setter
    def publish_subscription_type(self, publish_subscription_type):
        self._publish_subscription_type = publish_subscription_type

    @property
    def version(self):
        return self._version
    
    @version.setter
    def version(self, version):
        self._version = version

    @property
    def last_successful_sync(self):
        return self._last_successful_sync
    
    @last_successful_sync.setter
    def last_successful_sync(self, last_successful_sync):
        self._last_successful_sync = last_successful_sync


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultVAppTemplateRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
