"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultStrandedUserRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'full_name': 'str',
        'is_in_sync': 'bool',
        'number_of_deployed_v_ms': 'int',
        'number_of_stored_v_ms': 'int',
        'org': 'str'
    }

    attribute_map = {
        'name': 'name',
        'full_name': 'fullName',
        'is_in_sync': 'isInSync',
        'number_of_deployed_v_ms': 'numberOfDeployedVMs',
        'number_of_stored_v_ms': 'numberOfStoredVMs',
        'org': 'org'
    }

    def __init__(self, name=None,full_name=None,is_in_sync=None,number_of_deployed_v_ms=None,number_of_stored_v_ms=None,org=None):
        self._name = None
        self._full_name = None
        self._is_in_sync = None
        self._number_of_deployed_v_ms = None
        self._number_of_stored_v_ms = None
        self._org = None

        if name is not None:
            self.name = name
        if full_name is not None:
            self.full_name = full_name
        if is_in_sync is not None:
            self.is_in_sync = is_in_sync
        if number_of_deployed_v_ms is not None:
            self.number_of_deployed_v_ms = number_of_deployed_v_ms
        if number_of_stored_v_ms is not None:
            self.number_of_stored_v_ms = number_of_stored_v_ms
        if org is not None:
            self.org = org

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def full_name(self):
        return self._full_name
    
    @full_name.setter
    def full_name(self, full_name):
        self._full_name = full_name

    @property
    def is_in_sync(self):
        return self._is_in_sync
    
    @is_in_sync.setter
    def is_in_sync(self, is_in_sync):
        self._is_in_sync = is_in_sync

    @property
    def number_of_deployed_v_ms(self):
        return self._number_of_deployed_v_ms
    
    @number_of_deployed_v_ms.setter
    def number_of_deployed_v_ms(self, number_of_deployed_v_ms):
        self._number_of_deployed_v_ms = number_of_deployed_v_ms

    @property
    def number_of_stored_v_ms(self):
        return self._number_of_stored_v_ms
    
    @number_of_stored_v_ms.setter
    def number_of_stored_v_ms(self, number_of_stored_v_ms):
        self._number_of_stored_v_ms = number_of_stored_v_ms

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultStrandedUserRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
