"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultStrandedItemRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'vim_object_type': 'str',
        'parent_name': 'str',
        'deletion_date': 'str',
        'message': 'str',
        'parent': 'str',
        'number_of_purge_attempts': 'int'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'vim_object_type': 'vimObjectType',
        'parent_name': 'parentName',
        'deletion_date': 'deletionDate',
        'message': 'message',
        'parent': 'parent',
        'number_of_purge_attempts': 'numberOfPurgeAttempts'
    }

    def __init__(self, name=None,description=None,vim_object_type=None,parent_name=None,deletion_date=None,message=None,parent=None,number_of_purge_attempts=None):
        self._name = None
        self._description = None
        self._vim_object_type = None
        self._parent_name = None
        self._deletion_date = None
        self._message = None
        self._parent = None
        self._number_of_purge_attempts = None

        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if vim_object_type is not None:
            self.vim_object_type = vim_object_type
        if parent_name is not None:
            self.parent_name = parent_name
        if deletion_date is not None:
            self.deletion_date = deletion_date
        if message is not None:
            self.message = message
        if parent is not None:
            self.parent = parent
        if number_of_purge_attempts is not None:
            self.number_of_purge_attempts = number_of_purge_attempts

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def description(self):
        return self._description
    
    @description.setter
    def description(self, description):
        self._description = description

    @property
    def vim_object_type(self):
        return self._vim_object_type
    
    @vim_object_type.setter
    def vim_object_type(self, vim_object_type):
        self._vim_object_type = vim_object_type

    @property
    def parent_name(self):
        return self._parent_name
    
    @parent_name.setter
    def parent_name(self, parent_name):
        self._parent_name = parent_name

    @property
    def deletion_date(self):
        return self._deletion_date
    
    @deletion_date.setter
    def deletion_date(self, deletion_date):
        self._deletion_date = deletion_date

    @property
    def message(self):
        return self._message
    
    @message.setter
    def message(self, message):
        self._message = message

    @property
    def parent(self):
        return self._parent
    
    @parent.setter
    def parent(self, parent):
        self._parent = parent

    @property
    def number_of_purge_attempts(self):
        return self._number_of_purge_attempts
    
    @number_of_purge_attempts.setter
    def number_of_purge_attempts(self, number_of_purge_attempts):
        self._number_of_purge_attempts = number_of_purge_attempts


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultStrandedItemRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
