"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultSiteRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'rest_api_endpoint': 'str',
        'ui_endpoint': 'str'
    }

    attribute_map = {
        'name': 'name',
        'rest_api_endpoint': 'restApiEndpoint',
        'ui_endpoint': 'uiEndpoint'
    }

    def __init__(self, name=None,rest_api_endpoint=None,ui_endpoint=None):
        self._name = None
        self._rest_api_endpoint = None
        self._ui_endpoint = None

        if name is not None:
            self.name = name
        if rest_api_endpoint is not None:
            self.rest_api_endpoint = rest_api_endpoint
        if ui_endpoint is not None:
            self.ui_endpoint = ui_endpoint

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def rest_api_endpoint(self):
        return self._rest_api_endpoint
    
    @rest_api_endpoint.setter
    def rest_api_endpoint(self, rest_api_endpoint):
        self._rest_api_endpoint = rest_api_endpoint

    @property
    def ui_endpoint(self):
        return self._ui_endpoint
    
    @ui_endpoint.setter
    def ui_endpoint(self, ui_endpoint):
        self._ui_endpoint = ui_endpoint


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultSiteRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
