"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultServiceResourceRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'org': 'str',
        'resource_class': 'str',
        'external_object_id': 'str'
    }

    attribute_map = {
        'name': 'name',
        'org': 'org',
        'resource_class': 'resourceClass',
        'external_object_id': 'externalObjectId'
    }

    def __init__(self, name=None,org=None,resource_class=None,external_object_id=None):
        self._name = None
        self._org = None
        self._resource_class = None
        self._external_object_id = None

        if name is not None:
            self.name = name
        if org is not None:
            self.org = org
        if resource_class is not None:
            self.resource_class = resource_class
        if external_object_id is not None:
            self.external_object_id = external_object_id

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org

    @property
    def resource_class(self):
        return self._resource_class
    
    @resource_class.setter
    def resource_class(self, resource_class):
        self._resource_class = resource_class

    @property
    def external_object_id(self):
        return self._external_object_id
    
    @external_object_id.setter
    def external_object_id(self, external_object_id):
        self._external_object_id = external_object_id


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultServiceResourceRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
