"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultResourcePoolVMRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'status': 'str',
        'container_name': 'str',
        'guest_os': 'str',
        'is_deployed': 'bool',
        'is_busy': 'bool',
        'hardware_version': 'int'
    }

    attribute_map = {
        'name': 'name',
        'status': 'status',
        'container_name': 'containerName',
        'guest_os': 'guestOs',
        'is_deployed': 'isDeployed',
        'is_busy': 'isBusy',
        'hardware_version': 'hardwareVersion'
    }

    def __init__(self, name=None,status=None,container_name=None,guest_os=None,is_deployed=None,is_busy=None,hardware_version=None):
        self._name = None
        self._status = None
        self._container_name = None
        self._guest_os = None
        self._is_deployed = None
        self._is_busy = None
        self._hardware_version = None

        if name is not None:
            self.name = name
        if status is not None:
            self.status = status
        if container_name is not None:
            self.container_name = container_name
        if guest_os is not None:
            self.guest_os = guest_os
        if is_deployed is not None:
            self.is_deployed = is_deployed
        if is_busy is not None:
            self.is_busy = is_busy
        if hardware_version is not None:
            self.hardware_version = hardware_version

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status

    @property
    def container_name(self):
        return self._container_name
    
    @container_name.setter
    def container_name(self, container_name):
        self._container_name = container_name

    @property
    def guest_os(self):
        return self._guest_os
    
    @guest_os.setter
    def guest_os(self, guest_os):
        self._guest_os = guest_os

    @property
    def is_deployed(self):
        return self._is_deployed
    
    @is_deployed.setter
    def is_deployed(self, is_deployed):
        self._is_deployed = is_deployed

    @property
    def is_busy(self):
        return self._is_busy
    
    @is_busy.setter
    def is_busy(self, is_busy):
        self._is_busy = is_busy

    @property
    def hardware_version(self):
        return self._hardware_version
    
    @hardware_version.setter
    def hardware_version(self, hardware_version):
        self._hardware_version = hardware_version


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultResourcePoolVMRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
