"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultResourcePoolRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'moref': 'str',
        'is_deleted': 'bool',
        'vc': 'str',
        'vc_name': 'str',
        'provider_vdc': 'str',
        'provider_name': 'str',
        'is_enabled': 'bool',
        'is_primary': 'bool',
        'cluster_moref': 'str',
        'is_kubernetes_enabled': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'moref': 'moref',
        'is_deleted': 'isDeleted',
        'vc': 'vc',
        'vc_name': 'vcName',
        'provider_vdc': 'providerVdc',
        'provider_name': 'providerName',
        'is_enabled': 'isEnabled',
        'is_primary': 'isPrimary',
        'cluster_moref': 'clusterMoref',
        'is_kubernetes_enabled': 'isKubernetesEnabled'
    }

    def __init__(self, name=None,moref=None,is_deleted=None,vc=None,vc_name=None,provider_vdc=None,provider_name=None,is_enabled=None,is_primary=None,cluster_moref=None,is_kubernetes_enabled=None):
        self._name = None
        self._moref = None
        self._is_deleted = None
        self._vc = None
        self._vc_name = None
        self._provider_vdc = None
        self._provider_name = None
        self._is_enabled = None
        self._is_primary = None
        self._cluster_moref = None
        self._is_kubernetes_enabled = None

        if name is not None:
            self.name = name
        if moref is not None:
            self.moref = moref
        if is_deleted is not None:
            self.is_deleted = is_deleted
        if vc is not None:
            self.vc = vc
        if vc_name is not None:
            self.vc_name = vc_name
        if provider_vdc is not None:
            self.provider_vdc = provider_vdc
        if provider_name is not None:
            self.provider_name = provider_name
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if is_primary is not None:
            self.is_primary = is_primary
        if cluster_moref is not None:
            self.cluster_moref = cluster_moref
        if is_kubernetes_enabled is not None:
            self.is_kubernetes_enabled = is_kubernetes_enabled

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def moref(self):
        return self._moref
    
    @moref.setter
    def moref(self, moref):
        self._moref = moref

    @property
    def is_deleted(self):
        return self._is_deleted
    
    @is_deleted.setter
    def is_deleted(self, is_deleted):
        self._is_deleted = is_deleted

    @property
    def vc(self):
        return self._vc
    
    @vc.setter
    def vc(self, vc):
        self._vc = vc

    @property
    def vc_name(self):
        return self._vc_name
    
    @vc_name.setter
    def vc_name(self, vc_name):
        self._vc_name = vc_name

    @property
    def provider_vdc(self):
        return self._provider_vdc
    
    @provider_vdc.setter
    def provider_vdc(self, provider_vdc):
        self._provider_vdc = provider_vdc

    @property
    def provider_name(self):
        return self._provider_name
    
    @provider_name.setter
    def provider_name(self, provider_name):
        self._provider_name = provider_name

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def is_primary(self):
        return self._is_primary
    
    @is_primary.setter
    def is_primary(self, is_primary):
        self._is_primary = is_primary

    @property
    def cluster_moref(self):
        return self._cluster_moref
    
    @cluster_moref.setter
    def cluster_moref(self, cluster_moref):
        self._cluster_moref = cluster_moref

    @property
    def is_kubernetes_enabled(self):
        return self._is_kubernetes_enabled
    
    @is_kubernetes_enabled.setter
    def is_kubernetes_enabled(self, is_kubernetes_enabled):
        self._is_kubernetes_enabled = is_kubernetes_enabled


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultResourcePoolRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
