"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultOrgVdcStorageProfileRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'is_enabled': 'bool',
        'is_default_storage_profile': 'bool',
        'storage_used_mb': 'int',
        'storage_limit_mb': 'int',
        'iops_allocated': 'int',
        'iops_limit': 'int',
        'number_of_conditions': 'int',
        'vdc': 'str',
        'vdc_name': 'str',
        'is_vdc_busy': 'bool',
        'disk_iops_enabled': 'bool',
        'disk_iops_default': 'int',
        'disk_iops_max': 'int',
        'disk_iops_per_gb_max': 'int',
        'ignore_iops_placement': 'bool',
        'number_of_capabilities': 'int',
        'inherit_pvdc_default_settings': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'is_enabled': 'isEnabled',
        'is_default_storage_profile': 'isDefaultStorageProfile',
        'storage_used_mb': 'storageUsedMB',
        'storage_limit_mb': 'storageLimitMB',
        'iops_allocated': 'iopsAllocated',
        'iops_limit': 'iopsLimit',
        'number_of_conditions': 'numberOfConditions',
        'vdc': 'vdc',
        'vdc_name': 'vdcName',
        'is_vdc_busy': 'isVdcBusy',
        'disk_iops_enabled': 'diskIopsEnabled',
        'disk_iops_default': 'diskIopsDefault',
        'disk_iops_max': 'diskIopsMax',
        'disk_iops_per_gb_max': 'diskIopsPerGbMax',
        'ignore_iops_placement': 'ignoreIopsPlacement',
        'number_of_capabilities': 'numberOfCapabilities',
        'inherit_pvdc_default_settings': 'inheritPvdcDefaultSettings'
    }

    def __init__(self, name=None,is_enabled=None,is_default_storage_profile=None,storage_used_mb=None,storage_limit_mb=None,iops_allocated=None,iops_limit=None,number_of_conditions=None,vdc=None,vdc_name=None,is_vdc_busy=None,disk_iops_enabled=None,disk_iops_default=None,disk_iops_max=None,disk_iops_per_gb_max=None,ignore_iops_placement=None,number_of_capabilities=None,inherit_pvdc_default_settings=None):
        self._name = None
        self._is_enabled = None
        self._is_default_storage_profile = None
        self._storage_used_mb = None
        self._storage_limit_mb = None
        self._iops_allocated = None
        self._iops_limit = None
        self._number_of_conditions = None
        self._vdc = None
        self._vdc_name = None
        self._is_vdc_busy = None
        self._disk_iops_enabled = None
        self._disk_iops_default = None
        self._disk_iops_max = None
        self._disk_iops_per_gb_max = None
        self._ignore_iops_placement = None
        self._number_of_capabilities = None
        self._inherit_pvdc_default_settings = None

        if name is not None:
            self.name = name
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if is_default_storage_profile is not None:
            self.is_default_storage_profile = is_default_storage_profile
        if storage_used_mb is not None:
            self.storage_used_mb = storage_used_mb
        if storage_limit_mb is not None:
            self.storage_limit_mb = storage_limit_mb
        if iops_allocated is not None:
            self.iops_allocated = iops_allocated
        if iops_limit is not None:
            self.iops_limit = iops_limit
        if number_of_conditions is not None:
            self.number_of_conditions = number_of_conditions
        if vdc is not None:
            self.vdc = vdc
        if vdc_name is not None:
            self.vdc_name = vdc_name
        if is_vdc_busy is not None:
            self.is_vdc_busy = is_vdc_busy
        if disk_iops_enabled is not None:
            self.disk_iops_enabled = disk_iops_enabled
        if disk_iops_default is not None:
            self.disk_iops_default = disk_iops_default
        if disk_iops_max is not None:
            self.disk_iops_max = disk_iops_max
        if disk_iops_per_gb_max is not None:
            self.disk_iops_per_gb_max = disk_iops_per_gb_max
        if ignore_iops_placement is not None:
            self.ignore_iops_placement = ignore_iops_placement
        if number_of_capabilities is not None:
            self.number_of_capabilities = number_of_capabilities
        if inherit_pvdc_default_settings is not None:
            self.inherit_pvdc_default_settings = inherit_pvdc_default_settings

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def is_default_storage_profile(self):
        return self._is_default_storage_profile
    
    @is_default_storage_profile.setter
    def is_default_storage_profile(self, is_default_storage_profile):
        self._is_default_storage_profile = is_default_storage_profile

    @property
    def storage_used_mb(self):
        return self._storage_used_mb
    
    @storage_used_mb.setter
    def storage_used_mb(self, storage_used_mb):
        self._storage_used_mb = storage_used_mb

    @property
    def storage_limit_mb(self):
        return self._storage_limit_mb
    
    @storage_limit_mb.setter
    def storage_limit_mb(self, storage_limit_mb):
        self._storage_limit_mb = storage_limit_mb

    @property
    def iops_allocated(self):
        return self._iops_allocated
    
    @iops_allocated.setter
    def iops_allocated(self, iops_allocated):
        self._iops_allocated = iops_allocated

    @property
    def iops_limit(self):
        return self._iops_limit
    
    @iops_limit.setter
    def iops_limit(self, iops_limit):
        self._iops_limit = iops_limit

    @property
    def number_of_conditions(self):
        return self._number_of_conditions
    
    @number_of_conditions.setter
    def number_of_conditions(self, number_of_conditions):
        self._number_of_conditions = number_of_conditions

    @property
    def vdc(self):
        return self._vdc
    
    @vdc.setter
    def vdc(self, vdc):
        self._vdc = vdc

    @property
    def vdc_name(self):
        return self._vdc_name
    
    @vdc_name.setter
    def vdc_name(self, vdc_name):
        self._vdc_name = vdc_name

    @property
    def is_vdc_busy(self):
        return self._is_vdc_busy
    
    @is_vdc_busy.setter
    def is_vdc_busy(self, is_vdc_busy):
        self._is_vdc_busy = is_vdc_busy

    @property
    def disk_iops_enabled(self):
        return self._disk_iops_enabled
    
    @disk_iops_enabled.setter
    def disk_iops_enabled(self, disk_iops_enabled):
        self._disk_iops_enabled = disk_iops_enabled

    @property
    def disk_iops_default(self):
        return self._disk_iops_default
    
    @disk_iops_default.setter
    def disk_iops_default(self, disk_iops_default):
        self._disk_iops_default = disk_iops_default

    @property
    def disk_iops_max(self):
        return self._disk_iops_max
    
    @disk_iops_max.setter
    def disk_iops_max(self, disk_iops_max):
        self._disk_iops_max = disk_iops_max

    @property
    def disk_iops_per_gb_max(self):
        return self._disk_iops_per_gb_max
    
    @disk_iops_per_gb_max.setter
    def disk_iops_per_gb_max(self, disk_iops_per_gb_max):
        self._disk_iops_per_gb_max = disk_iops_per_gb_max

    @property
    def ignore_iops_placement(self):
        return self._ignore_iops_placement
    
    @ignore_iops_placement.setter
    def ignore_iops_placement(self, ignore_iops_placement):
        self._ignore_iops_placement = ignore_iops_placement

    @property
    def number_of_capabilities(self):
        return self._number_of_capabilities
    
    @number_of_capabilities.setter
    def number_of_capabilities(self, number_of_capabilities):
        self._number_of_capabilities = number_of_capabilities

    @property
    def inherit_pvdc_default_settings(self):
        return self._inherit_pvdc_default_settings
    
    @inherit_pvdc_default_settings.setter
    def inherit_pvdc_default_settings(self, inherit_pvdc_default_settings):
        self._inherit_pvdc_default_settings = inherit_pvdc_default_settings


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultOrgVdcStorageProfileRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
