"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultOrgVdcNetworkRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'default_gateway': 'str',
        'netmask': 'str',
        'subnet_prefix_length': 'int',
        'dns1': 'str',
        'dns2': 'str',
        'dns_suffix': 'str',
        'link_type': 'int',
        'connected_to': 'str',
        'vdc': 'str',
        'is_busy': 'bool',
        'is_shared': 'bool',
        'vdc_name': 'str',
        'is_ip_scope_inherited': 'bool',
        'used_ip_count': 'int',
        'total_ip_count': 'int',
        'interface_type': 'int',
        'cross_vdc_network_id': 'str',
        'vdc_group_id': 'str',
        'cross_vdc_network_location_id': 'str'
    }

    attribute_map = {
        'name': 'name',
        'default_gateway': 'defaultGateway',
        'netmask': 'netmask',
        'subnet_prefix_length': 'subnetPrefixLength',
        'dns1': 'dns1',
        'dns2': 'dns2',
        'dns_suffix': 'dnsSuffix',
        'link_type': 'linkType',
        'connected_to': 'connectedTo',
        'vdc': 'vdc',
        'is_busy': 'isBusy',
        'is_shared': 'isShared',
        'vdc_name': 'vdcName',
        'is_ip_scope_inherited': 'isIpScopeInherited',
        'used_ip_count': 'usedIpCount',
        'total_ip_count': 'totalIpCount',
        'interface_type': 'interfaceType',
        'cross_vdc_network_id': 'crossVdcNetworkId',
        'vdc_group_id': 'vdcGroupId',
        'cross_vdc_network_location_id': 'crossVdcNetworkLocationId'
    }

    def __init__(self, name=None,default_gateway=None,netmask=None,subnet_prefix_length=None,dns1=None,dns2=None,dns_suffix=None,link_type=None,connected_to=None,vdc=None,is_busy=None,is_shared=None,vdc_name=None,is_ip_scope_inherited=None,used_ip_count=None,total_ip_count=None,interface_type=None,cross_vdc_network_id=None,vdc_group_id=None,cross_vdc_network_location_id=None):
        self._name = None
        self._default_gateway = None
        self._netmask = None
        self._subnet_prefix_length = None
        self._dns1 = None
        self._dns2 = None
        self._dns_suffix = None
        self._link_type = None
        self._connected_to = None
        self._vdc = None
        self._is_busy = None
        self._is_shared = None
        self._vdc_name = None
        self._is_ip_scope_inherited = None
        self._used_ip_count = None
        self._total_ip_count = None
        self._interface_type = None
        self._cross_vdc_network_id = None
        self._vdc_group_id = None
        self._cross_vdc_network_location_id = None

        if name is not None:
            self.name = name
        if default_gateway is not None:
            self.default_gateway = default_gateway
        if netmask is not None:
            self.netmask = netmask
        if subnet_prefix_length is not None:
            self.subnet_prefix_length = subnet_prefix_length
        if dns1 is not None:
            self.dns1 = dns1
        if dns2 is not None:
            self.dns2 = dns2
        if dns_suffix is not None:
            self.dns_suffix = dns_suffix
        if link_type is not None:
            self.link_type = link_type
        if connected_to is not None:
            self.connected_to = connected_to
        if vdc is not None:
            self.vdc = vdc
        if is_busy is not None:
            self.is_busy = is_busy
        if is_shared is not None:
            self.is_shared = is_shared
        if vdc_name is not None:
            self.vdc_name = vdc_name
        if is_ip_scope_inherited is not None:
            self.is_ip_scope_inherited = is_ip_scope_inherited
        if used_ip_count is not None:
            self.used_ip_count = used_ip_count
        if total_ip_count is not None:
            self.total_ip_count = total_ip_count
        if interface_type is not None:
            self.interface_type = interface_type
        if cross_vdc_network_id is not None:
            self.cross_vdc_network_id = cross_vdc_network_id
        if vdc_group_id is not None:
            self.vdc_group_id = vdc_group_id
        if cross_vdc_network_location_id is not None:
            self.cross_vdc_network_location_id = cross_vdc_network_location_id

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def default_gateway(self):
        return self._default_gateway
    
    @default_gateway.setter
    def default_gateway(self, default_gateway):
        self._default_gateway = default_gateway

    @property
    def netmask(self):
        return self._netmask
    
    @netmask.setter
    def netmask(self, netmask):
        self._netmask = netmask

    @property
    def subnet_prefix_length(self):
        return self._subnet_prefix_length
    
    @subnet_prefix_length.setter
    def subnet_prefix_length(self, subnet_prefix_length):
        self._subnet_prefix_length = subnet_prefix_length

    @property
    def dns1(self):
        return self._dns1
    
    @dns1.setter
    def dns1(self, dns1):
        self._dns1 = dns1

    @property
    def dns2(self):
        return self._dns2
    
    @dns2.setter
    def dns2(self, dns2):
        self._dns2 = dns2

    @property
    def dns_suffix(self):
        return self._dns_suffix
    
    @dns_suffix.setter
    def dns_suffix(self, dns_suffix):
        self._dns_suffix = dns_suffix

    @property
    def link_type(self):
        return self._link_type
    
    @link_type.setter
    def link_type(self, link_type):
        self._link_type = link_type

    @property
    def connected_to(self):
        return self._connected_to
    
    @connected_to.setter
    def connected_to(self, connected_to):
        self._connected_to = connected_to

    @property
    def vdc(self):
        return self._vdc
    
    @vdc.setter
    def vdc(self, vdc):
        self._vdc = vdc

    @property
    def is_busy(self):
        return self._is_busy
    
    @is_busy.setter
    def is_busy(self, is_busy):
        self._is_busy = is_busy

    @property
    def is_shared(self):
        return self._is_shared
    
    @is_shared.setter
    def is_shared(self, is_shared):
        self._is_shared = is_shared

    @property
    def vdc_name(self):
        return self._vdc_name
    
    @vdc_name.setter
    def vdc_name(self, vdc_name):
        self._vdc_name = vdc_name

    @property
    def is_ip_scope_inherited(self):
        return self._is_ip_scope_inherited
    
    @is_ip_scope_inherited.setter
    def is_ip_scope_inherited(self, is_ip_scope_inherited):
        self._is_ip_scope_inherited = is_ip_scope_inherited

    @property
    def used_ip_count(self):
        return self._used_ip_count
    
    @used_ip_count.setter
    def used_ip_count(self, used_ip_count):
        self._used_ip_count = used_ip_count

    @property
    def total_ip_count(self):
        return self._total_ip_count
    
    @total_ip_count.setter
    def total_ip_count(self, total_ip_count):
        self._total_ip_count = total_ip_count

    @property
    def interface_type(self):
        return self._interface_type
    
    @interface_type.setter
    def interface_type(self, interface_type):
        self._interface_type = interface_type

    @property
    def cross_vdc_network_id(self):
        return self._cross_vdc_network_id
    
    @cross_vdc_network_id.setter
    def cross_vdc_network_id(self, cross_vdc_network_id):
        self._cross_vdc_network_id = cross_vdc_network_id

    @property
    def vdc_group_id(self):
        return self._vdc_group_id
    
    @vdc_group_id.setter
    def vdc_group_id(self, vdc_group_id):
        self._vdc_group_id = vdc_group_id

    @property
    def cross_vdc_network_location_id(self):
        return self._cross_vdc_network_location_id
    
    @cross_vdc_network_location_id.setter
    def cross_vdc_network_location_id(self, cross_vdc_network_location_id):
        self._cross_vdc_network_location_id = cross_vdc_network_location_id


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultOrgVdcNetworkRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
