"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultOrgAssociationRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'site_id': 'str',
        'local_org_id': 'str',
        'org_id': 'str',
        'site_name': 'str',
        'org_name': 'str',
        'status': 'str'
    }

    attribute_map = {
        'site_id': 'siteId',
        'local_org_id': 'localOrgId',
        'org_id': 'orgId',
        'site_name': 'siteName',
        'org_name': 'orgName',
        'status': 'status'
    }

    def __init__(self, site_id=None,local_org_id=None,org_id=None,site_name=None,org_name=None,status=None):
        self._site_id = None
        self._local_org_id = None
        self._org_id = None
        self._site_name = None
        self._org_name = None
        self._status = None

        if site_id is not None:
            self.site_id = site_id
        if local_org_id is not None:
            self.local_org_id = local_org_id
        if org_id is not None:
            self.org_id = org_id
        if site_name is not None:
            self.site_name = site_name
        if org_name is not None:
            self.org_name = org_name
        if status is not None:
            self.status = status

    @property
    def site_id(self):
        return self._site_id
    
    @site_id.setter
    def site_id(self, site_id):
        self._site_id = site_id

    @property
    def local_org_id(self):
        return self._local_org_id
    
    @local_org_id.setter
    def local_org_id(self, local_org_id):
        self._local_org_id = local_org_id

    @property
    def org_id(self):
        return self._org_id
    
    @org_id.setter
    def org_id(self, org_id):
        self._org_id = org_id

    @property
    def site_name(self):
        return self._site_name
    
    @site_name.setter
    def site_name(self, site_name):
        self._site_name = site_name

    @property
    def org_name(self):
        return self._org_name
    
    @org_name.setter
    def org_name(self, org_name):
        self._org_name = org_name

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultOrgAssociationRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
