"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultLicensingManagedServerRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'parent_sample_id': 'str',
        'virtual_center_id': 'str',
        'managed_object_reference': 'str',
        'memory_used': 'int',
        'memory_installed': 'int',
        'socket_count': 'int',
        'name': 'str',
        'observation_date': 'str'
    }

    attribute_map = {
        'parent_sample_id': 'parentSampleId',
        'virtual_center_id': 'virtualCenterId',
        'managed_object_reference': 'managedObjectReference',
        'memory_used': 'memoryUsed',
        'memory_installed': 'memoryInstalled',
        'socket_count': 'socketCount',
        'name': 'name',
        'observation_date': 'observationDate'
    }

    def __init__(self, parent_sample_id=None,virtual_center_id=None,managed_object_reference=None,memory_used=None,memory_installed=None,socket_count=None,name=None,observation_date=None):
        self._parent_sample_id = None
        self._virtual_center_id = None
        self._managed_object_reference = None
        self._memory_used = None
        self._memory_installed = None
        self._socket_count = None
        self._name = None
        self._observation_date = None

        if parent_sample_id is not None:
            self.parent_sample_id = parent_sample_id
        if virtual_center_id is not None:
            self.virtual_center_id = virtual_center_id
        if managed_object_reference is not None:
            self.managed_object_reference = managed_object_reference
        if memory_used is not None:
            self.memory_used = memory_used
        if memory_installed is not None:
            self.memory_installed = memory_installed
        if socket_count is not None:
            self.socket_count = socket_count
        if name is not None:
            self.name = name
        if observation_date is not None:
            self.observation_date = observation_date

    @property
    def parent_sample_id(self):
        return self._parent_sample_id
    
    @parent_sample_id.setter
    def parent_sample_id(self, parent_sample_id):
        self._parent_sample_id = parent_sample_id

    @property
    def virtual_center_id(self):
        return self._virtual_center_id
    
    @virtual_center_id.setter
    def virtual_center_id(self, virtual_center_id):
        self._virtual_center_id = virtual_center_id

    @property
    def managed_object_reference(self):
        return self._managed_object_reference
    
    @managed_object_reference.setter
    def managed_object_reference(self, managed_object_reference):
        self._managed_object_reference = managed_object_reference

    @property
    def memory_used(self):
        return self._memory_used
    
    @memory_used.setter
    def memory_used(self, memory_used):
        self._memory_used = memory_used

    @property
    def memory_installed(self):
        return self._memory_installed
    
    @memory_installed.setter
    def memory_installed(self, memory_installed):
        self._memory_installed = memory_installed

    @property
    def socket_count(self):
        return self._socket_count
    
    @socket_count.setter
    def socket_count(self, socket_count):
        self._socket_count = socket_count

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def observation_date(self):
        return self._observation_date
    
    @observation_date.setter
    def observation_date(self, observation_date):
        self._observation_date = observation_date


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultLicensingManagedServerRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
