"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultDatastoreRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'datastore_type': 'str',
        'is_enabled': 'bool',
        'is_deleted': 'bool',
        'storage_used_mb': 'int',
        'storage_mb': 'int',
        'provisioned_storage_mb': 'int',
        'requested_storage_mb': 'int',
        'vc': 'str',
        'vc_name': 'str',
        'moref': 'str',
        'number_of_provider_vdcs': 'int',
        'datastore_cluster': 'bool',
        'iops_capacity': 'int',
        'iops_allocated': 'int'
    }

    attribute_map = {
        'name': 'name',
        'datastore_type': 'datastoreType',
        'is_enabled': 'isEnabled',
        'is_deleted': 'isDeleted',
        'storage_used_mb': 'storageUsedMB',
        'storage_mb': 'storageMB',
        'provisioned_storage_mb': 'provisionedStorageMB',
        'requested_storage_mb': 'requestedStorageMB',
        'vc': 'vc',
        'vc_name': 'vcName',
        'moref': 'moref',
        'number_of_provider_vdcs': 'numberOfProviderVdcs',
        'datastore_cluster': 'datastoreCluster',
        'iops_capacity': 'iopsCapacity',
        'iops_allocated': 'iopsAllocated'
    }

    def __init__(self, name=None,datastore_type=None,is_enabled=None,is_deleted=None,storage_used_mb=None,storage_mb=None,provisioned_storage_mb=None,requested_storage_mb=None,vc=None,vc_name=None,moref=None,number_of_provider_vdcs=None,datastore_cluster=None,iops_capacity=None,iops_allocated=None):
        self._name = None
        self._datastore_type = None
        self._is_enabled = None
        self._is_deleted = None
        self._storage_used_mb = None
        self._storage_mb = None
        self._provisioned_storage_mb = None
        self._requested_storage_mb = None
        self._vc = None
        self._vc_name = None
        self._moref = None
        self._number_of_provider_vdcs = None
        self._datastore_cluster = None
        self._iops_capacity = None
        self._iops_allocated = None

        if name is not None:
            self.name = name
        if datastore_type is not None:
            self.datastore_type = datastore_type
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if is_deleted is not None:
            self.is_deleted = is_deleted
        if storage_used_mb is not None:
            self.storage_used_mb = storage_used_mb
        if storage_mb is not None:
            self.storage_mb = storage_mb
        if provisioned_storage_mb is not None:
            self.provisioned_storage_mb = provisioned_storage_mb
        if requested_storage_mb is not None:
            self.requested_storage_mb = requested_storage_mb
        if vc is not None:
            self.vc = vc
        if vc_name is not None:
            self.vc_name = vc_name
        if moref is not None:
            self.moref = moref
        if number_of_provider_vdcs is not None:
            self.number_of_provider_vdcs = number_of_provider_vdcs
        if datastore_cluster is not None:
            self.datastore_cluster = datastore_cluster
        if iops_capacity is not None:
            self.iops_capacity = iops_capacity
        if iops_allocated is not None:
            self.iops_allocated = iops_allocated

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def datastore_type(self):
        return self._datastore_type
    
    @datastore_type.setter
    def datastore_type(self, datastore_type):
        self._datastore_type = datastore_type

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def is_deleted(self):
        return self._is_deleted
    
    @is_deleted.setter
    def is_deleted(self, is_deleted):
        self._is_deleted = is_deleted

    @property
    def storage_used_mb(self):
        return self._storage_used_mb
    
    @storage_used_mb.setter
    def storage_used_mb(self, storage_used_mb):
        self._storage_used_mb = storage_used_mb

    @property
    def storage_mb(self):
        return self._storage_mb
    
    @storage_mb.setter
    def storage_mb(self, storage_mb):
        self._storage_mb = storage_mb

    @property
    def provisioned_storage_mb(self):
        return self._provisioned_storage_mb
    
    @provisioned_storage_mb.setter
    def provisioned_storage_mb(self, provisioned_storage_mb):
        self._provisioned_storage_mb = provisioned_storage_mb

    @property
    def requested_storage_mb(self):
        return self._requested_storage_mb
    
    @requested_storage_mb.setter
    def requested_storage_mb(self, requested_storage_mb):
        self._requested_storage_mb = requested_storage_mb

    @property
    def vc(self):
        return self._vc
    
    @vc.setter
    def vc(self, vc):
        self._vc = vc

    @property
    def vc_name(self):
        return self._vc_name
    
    @vc_name.setter
    def vc_name(self, vc_name):
        self._vc_name = vc_name

    @property
    def moref(self):
        return self._moref
    
    @moref.setter
    def moref(self, moref):
        self._moref = moref

    @property
    def number_of_provider_vdcs(self):
        return self._number_of_provider_vdcs
    
    @number_of_provider_vdcs.setter
    def number_of_provider_vdcs(self, number_of_provider_vdcs):
        self._number_of_provider_vdcs = number_of_provider_vdcs

    @property
    def datastore_cluster(self):
        return self._datastore_cluster
    
    @datastore_cluster.setter
    def datastore_cluster(self, datastore_cluster):
        self._datastore_cluster = datastore_cluster

    @property
    def iops_capacity(self):
        return self._iops_capacity
    
    @iops_capacity.setter
    def iops_capacity(self, iops_capacity):
        self._iops_capacity = iops_capacity

    @property
    def iops_allocated(self):
        return self._iops_allocated
    
    @iops_allocated.setter
    def iops_allocated(self, iops_allocated):
        self._iops_allocated = iops_allocated


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultDatastoreRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
