"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultCatalogItemRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'entity': 'str',
        'entity_name': 'str',
        'entity_type': 'str',
        'catalog': 'str',
        'catalog_name': 'str',
        'owner_name': 'str',
        'owner': 'str',
        'is_published': 'bool',
        'vdc': 'str',
        'vdc_name': 'str',
        'is_vdc_enabled': 'bool',
        'creation_date': 'str',
        'is_expired': 'bool',
        'status': 'str',
        'name': 'str'
    }

    attribute_map = {
        'entity': 'entity',
        'entity_name': 'entityName',
        'entity_type': 'entityType',
        'catalog': 'catalog',
        'catalog_name': 'catalogName',
        'owner_name': 'ownerName',
        'owner': 'owner',
        'is_published': 'isPublished',
        'vdc': 'vdc',
        'vdc_name': 'vdcName',
        'is_vdc_enabled': 'isVdcEnabled',
        'creation_date': 'creationDate',
        'is_expired': 'isExpired',
        'status': 'status',
        'name': 'name'
    }

    def __init__(self, entity=None,entity_name=None,entity_type=None,catalog=None,catalog_name=None,owner_name=None,owner=None,is_published=None,vdc=None,vdc_name=None,is_vdc_enabled=None,creation_date=None,is_expired=None,status=None,name=None):
        self._entity = None
        self._entity_name = None
        self._entity_type = None
        self._catalog = None
        self._catalog_name = None
        self._owner_name = None
        self._owner = None
        self._is_published = None
        self._vdc = None
        self._vdc_name = None
        self._is_vdc_enabled = None
        self._creation_date = None
        self._is_expired = None
        self._status = None
        self._name = None

        if entity is not None:
            self.entity = entity
        if entity_name is not None:
            self.entity_name = entity_name
        if entity_type is not None:
            self.entity_type = entity_type
        if catalog is not None:
            self.catalog = catalog
        if catalog_name is not None:
            self.catalog_name = catalog_name
        if owner_name is not None:
            self.owner_name = owner_name
        if owner is not None:
            self.owner = owner
        if is_published is not None:
            self.is_published = is_published
        if vdc is not None:
            self.vdc = vdc
        if vdc_name is not None:
            self.vdc_name = vdc_name
        if is_vdc_enabled is not None:
            self.is_vdc_enabled = is_vdc_enabled
        if creation_date is not None:
            self.creation_date = creation_date
        if is_expired is not None:
            self.is_expired = is_expired
        if status is not None:
            self.status = status
        if name is not None:
            self.name = name

    @property
    def entity(self):
        return self._entity
    
    @entity.setter
    def entity(self, entity):
        self._entity = entity

    @property
    def entity_name(self):
        return self._entity_name
    
    @entity_name.setter
    def entity_name(self, entity_name):
        self._entity_name = entity_name

    @property
    def entity_type(self):
        return self._entity_type
    
    @entity_type.setter
    def entity_type(self, entity_type):
        self._entity_type = entity_type

    @property
    def catalog(self):
        return self._catalog
    
    @catalog.setter
    def catalog(self, catalog):
        self._catalog = catalog

    @property
    def catalog_name(self):
        return self._catalog_name
    
    @catalog_name.setter
    def catalog_name(self, catalog_name):
        self._catalog_name = catalog_name

    @property
    def owner_name(self):
        return self._owner_name
    
    @owner_name.setter
    def owner_name(self, owner_name):
        self._owner_name = owner_name

    @property
    def owner(self):
        return self._owner
    
    @owner.setter
    def owner(self, owner):
        self._owner = owner

    @property
    def is_published(self):
        return self._is_published
    
    @is_published.setter
    def is_published(self, is_published):
        self._is_published = is_published

    @property
    def vdc(self):
        return self._vdc
    
    @vdc.setter
    def vdc(self, vdc):
        self._vdc = vdc

    @property
    def vdc_name(self):
        return self._vdc_name
    
    @vdc_name.setter
    def vdc_name(self, vdc_name):
        self._vdc_name = vdc_name

    @property
    def is_vdc_enabled(self):
        return self._is_vdc_enabled
    
    @is_vdc_enabled.setter
    def is_vdc_enabled(self, is_vdc_enabled):
        self._is_vdc_enabled = is_vdc_enabled

    @property
    def creation_date(self):
        return self._creation_date
    
    @creation_date.setter
    def creation_date(self, creation_date):
        self._creation_date = creation_date

    @property
    def is_expired(self):
        return self._is_expired
    
    @is_expired.setter
    def is_expired(self, is_expired):
        self._is_expired = is_expired

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultCatalogItemRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
