"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultAdminTaskRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'org': 'str',
        'org_name': 'str',
        'name': 'str',
        'operation_full': 'str',
        'start_date': 'str',
        'end_date': 'str',
        'status': 'str',
        'progress': 'int',
        'owner': 'str',
        'owner_name': 'str',
        'object': 'str',
        'object_type': 'str',
        'object_name': 'str',
        'cell_name': 'str',
        'service_namespace': 'str',
        'has_owner': 'bool'
    }

    attribute_map = {
        'org': 'org',
        'org_name': 'orgName',
        'name': 'name',
        'operation_full': 'operationFull',
        'start_date': 'startDate',
        'end_date': 'endDate',
        'status': 'status',
        'progress': 'progress',
        'owner': 'owner',
        'owner_name': 'ownerName',
        'object': 'object',
        'object_type': 'objectType',
        'object_name': 'objectName',
        'cell_name': 'cellName',
        'service_namespace': 'serviceNamespace',
        'has_owner': 'hasOwner'
    }

    def __init__(self, org=None,org_name=None,name=None,operation_full=None,start_date=None,end_date=None,status=None,progress=None,owner=None,owner_name=None,object=None,object_type=None,object_name=None,cell_name=None,service_namespace=None,has_owner=None):
        self._org = None
        self._org_name = None
        self._name = None
        self._operation_full = None
        self._start_date = None
        self._end_date = None
        self._status = None
        self._progress = None
        self._owner = None
        self._owner_name = None
        self._object = None
        self._object_type = None
        self._object_name = None
        self._cell_name = None
        self._service_namespace = None
        self._has_owner = None

        if org is not None:
            self.org = org
        if org_name is not None:
            self.org_name = org_name
        if name is not None:
            self.name = name
        if operation_full is not None:
            self.operation_full = operation_full
        if start_date is not None:
            self.start_date = start_date
        if end_date is not None:
            self.end_date = end_date
        if status is not None:
            self.status = status
        if progress is not None:
            self.progress = progress
        if owner is not None:
            self.owner = owner
        if owner_name is not None:
            self.owner_name = owner_name
        if object is not None:
            self.object = object
        if object_type is not None:
            self.object_type = object_type
        if object_name is not None:
            self.object_name = object_name
        if cell_name is not None:
            self.cell_name = cell_name
        if service_namespace is not None:
            self.service_namespace = service_namespace
        if has_owner is not None:
            self.has_owner = has_owner

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org

    @property
    def org_name(self):
        return self._org_name
    
    @org_name.setter
    def org_name(self, org_name):
        self._org_name = org_name

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def operation_full(self):
        return self._operation_full
    
    @operation_full.setter
    def operation_full(self, operation_full):
        self._operation_full = operation_full

    @property
    def start_date(self):
        return self._start_date
    
    @start_date.setter
    def start_date(self, start_date):
        self._start_date = start_date

    @property
    def end_date(self):
        return self._end_date
    
    @end_date.setter
    def end_date(self, end_date):
        self._end_date = end_date

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status

    @property
    def progress(self):
        return self._progress
    
    @progress.setter
    def progress(self, progress):
        self._progress = progress

    @property
    def owner(self):
        return self._owner
    
    @owner.setter
    def owner(self, owner):
        self._owner = owner

    @property
    def owner_name(self):
        return self._owner_name
    
    @owner_name.setter
    def owner_name(self, owner_name):
        self._owner_name = owner_name

    @property
    def object(self):
        return self._object
    
    @object.setter
    def object(self, object):
        self._object = object

    @property
    def object_type(self):
        return self._object_type
    
    @object_type.setter
    def object_type(self, object_type):
        self._object_type = object_type

    @property
    def object_name(self):
        return self._object_name
    
    @object_name.setter
    def object_name(self, object_name):
        self._object_name = object_name

    @property
    def cell_name(self):
        return self._cell_name
    
    @cell_name.setter
    def cell_name(self, cell_name):
        self._cell_name = cell_name

    @property
    def service_namespace(self):
        return self._service_namespace
    
    @service_namespace.setter
    def service_namespace(self, service_namespace):
        self._service_namespace = service_namespace

    @property
    def has_owner(self):
        return self._has_owner
    
    @has_owner.setter
    def has_owner(self, has_owner):
        self._has_owner = has_owner


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultAdminTaskRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
