"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultAdminShadowVMRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'is_published': 'bool',
        'name': 'str',
        'primary_vm_name': 'str',
        'shadow_v_app': 'str',
        'primary_v_app_template': 'str',
        'primary_v_app_name': 'str',
        'datastore_name': 'str',
        'vc_name': 'str',
        'is_deleted': 'bool',
        'status': 'str',
        'is_busy': 'bool',
        'primary_vm_owner': 'str',
        'primary_vm': 'str',
        'primary_vm_catalog': 'str',
        'org': 'str'
    }

    attribute_map = {
        'is_published': 'isPublished',
        'name': 'name',
        'primary_vm_name': 'primaryVmName',
        'shadow_v_app': 'shadowVApp',
        'primary_v_app_template': 'primaryVAppTemplate',
        'primary_v_app_name': 'primaryVAppName',
        'datastore_name': 'datastoreName',
        'vc_name': 'vcName',
        'is_deleted': 'isDeleted',
        'status': 'status',
        'is_busy': 'isBusy',
        'primary_vm_owner': 'primaryVMOwner',
        'primary_vm': 'primaryVM',
        'primary_vm_catalog': 'primaryVMCatalog',
        'org': 'org'
    }

    def __init__(self, is_published=None,name=None,primary_vm_name=None,shadow_v_app=None,primary_v_app_template=None,primary_v_app_name=None,datastore_name=None,vc_name=None,is_deleted=None,status=None,is_busy=None,primary_vm_owner=None,primary_vm=None,primary_vm_catalog=None,org=None):
        self._is_published = None
        self._name = None
        self._primary_vm_name = None
        self._shadow_v_app = None
        self._primary_v_app_template = None
        self._primary_v_app_name = None
        self._datastore_name = None
        self._vc_name = None
        self._is_deleted = None
        self._status = None
        self._is_busy = None
        self._primary_vm_owner = None
        self._primary_vm = None
        self._primary_vm_catalog = None
        self._org = None

        if is_published is not None:
            self.is_published = is_published
        if name is not None:
            self.name = name
        if primary_vm_name is not None:
            self.primary_vm_name = primary_vm_name
        if shadow_v_app is not None:
            self.shadow_v_app = shadow_v_app
        if primary_v_app_template is not None:
            self.primary_v_app_template = primary_v_app_template
        if primary_v_app_name is not None:
            self.primary_v_app_name = primary_v_app_name
        if datastore_name is not None:
            self.datastore_name = datastore_name
        if vc_name is not None:
            self.vc_name = vc_name
        if is_deleted is not None:
            self.is_deleted = is_deleted
        if status is not None:
            self.status = status
        if is_busy is not None:
            self.is_busy = is_busy
        if primary_vm_owner is not None:
            self.primary_vm_owner = primary_vm_owner
        if primary_vm is not None:
            self.primary_vm = primary_vm
        if primary_vm_catalog is not None:
            self.primary_vm_catalog = primary_vm_catalog
        if org is not None:
            self.org = org

    @property
    def is_published(self):
        return self._is_published
    
    @is_published.setter
    def is_published(self, is_published):
        self._is_published = is_published

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def primary_vm_name(self):
        return self._primary_vm_name
    
    @primary_vm_name.setter
    def primary_vm_name(self, primary_vm_name):
        self._primary_vm_name = primary_vm_name

    @property
    def shadow_v_app(self):
        return self._shadow_v_app
    
    @shadow_v_app.setter
    def shadow_v_app(self, shadow_v_app):
        self._shadow_v_app = shadow_v_app

    @property
    def primary_v_app_template(self):
        return self._primary_v_app_template
    
    @primary_v_app_template.setter
    def primary_v_app_template(self, primary_v_app_template):
        self._primary_v_app_template = primary_v_app_template

    @property
    def primary_v_app_name(self):
        return self._primary_v_app_name
    
    @primary_v_app_name.setter
    def primary_v_app_name(self, primary_v_app_name):
        self._primary_v_app_name = primary_v_app_name

    @property
    def datastore_name(self):
        return self._datastore_name
    
    @datastore_name.setter
    def datastore_name(self, datastore_name):
        self._datastore_name = datastore_name

    @property
    def vc_name(self):
        return self._vc_name
    
    @vc_name.setter
    def vc_name(self, vc_name):
        self._vc_name = vc_name

    @property
    def is_deleted(self):
        return self._is_deleted
    
    @is_deleted.setter
    def is_deleted(self, is_deleted):
        self._is_deleted = is_deleted

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status

    @property
    def is_busy(self):
        return self._is_busy
    
    @is_busy.setter
    def is_busy(self, is_busy):
        self._is_busy = is_busy

    @property
    def primary_vm_owner(self):
        return self._primary_vm_owner
    
    @primary_vm_owner.setter
    def primary_vm_owner(self, primary_vm_owner):
        self._primary_vm_owner = primary_vm_owner

    @property
    def primary_vm(self):
        return self._primary_vm
    
    @primary_vm.setter
    def primary_vm(self, primary_vm):
        self._primary_vm = primary_vm

    @property
    def primary_vm_catalog(self):
        return self._primary_vm_catalog
    
    @primary_vm_catalog.setter
    def primary_vm_catalog(self, primary_vm_catalog):
        self._primary_vm_catalog = primary_vm_catalog

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultAdminShadowVMRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
