"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultAdminOrgVdcTemplateRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'tenant_visible_name': 'str',
        'tenant_visible_description': 'str',
        'network_backing_type': 'str'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'tenant_visible_name': 'tenantVisibleName',
        'tenant_visible_description': 'tenantVisibleDescription',
        'network_backing_type': 'networkBackingType'
    }

    def __init__(self, name=None,description=None,tenant_visible_name=None,tenant_visible_description=None,network_backing_type=None):
        self._name = None
        self._description = None
        self._tenant_visible_name = None
        self._tenant_visible_description = None
        self._network_backing_type = None

        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if tenant_visible_name is not None:
            self.tenant_visible_name = tenant_visible_name
        if tenant_visible_description is not None:
            self.tenant_visible_description = tenant_visible_description
        if network_backing_type is not None:
            self.network_backing_type = network_backing_type

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def description(self):
        return self._description
    
    @description.setter
    def description(self, description):
        self._description = description

    @property
    def tenant_visible_name(self):
        return self._tenant_visible_name
    
    @tenant_visible_name.setter
    def tenant_visible_name(self, tenant_visible_name):
        self._tenant_visible_name = tenant_visible_name

    @property
    def tenant_visible_description(self):
        return self._tenant_visible_description
    
    @tenant_visible_description.setter
    def tenant_visible_description(self, tenant_visible_description):
        self._tenant_visible_description = tenant_visible_description

    @property
    def network_backing_type(self):
        return self._network_backing_type
    
    @network_backing_type.setter
    def network_backing_type(self, network_backing_type):
        self._network_backing_type = network_backing_type


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultAdminOrgVdcTemplateRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
