"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultAdminCatalogRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'org': 'str',
        'name': 'str',
        'is_published': 'bool',
        'is_shared': 'bool',
        'creation_date': 'str',
        'org_name': 'str',
        'owner_name': 'str',
        'number_of_templates': 'int',
        'number_of_media': 'int',
        'owner': 'str',
        'is_local': 'bool'
    }

    attribute_map = {
        'org': 'org',
        'name': 'name',
        'is_published': 'isPublished',
        'is_shared': 'isShared',
        'creation_date': 'creationDate',
        'org_name': 'orgName',
        'owner_name': 'ownerName',
        'number_of_templates': 'numberOfTemplates',
        'number_of_media': 'numberOfMedia',
        'owner': 'owner',
        'is_local': 'isLocal'
    }

    def __init__(self, org=None,name=None,is_published=None,is_shared=None,creation_date=None,org_name=None,owner_name=None,number_of_templates=None,number_of_media=None,owner=None,is_local=None):
        self._org = None
        self._name = None
        self._is_published = None
        self._is_shared = None
        self._creation_date = None
        self._org_name = None
        self._owner_name = None
        self._number_of_templates = None
        self._number_of_media = None
        self._owner = None
        self._is_local = None

        if org is not None:
            self.org = org
        if name is not None:
            self.name = name
        if is_published is not None:
            self.is_published = is_published
        if is_shared is not None:
            self.is_shared = is_shared
        if creation_date is not None:
            self.creation_date = creation_date
        if org_name is not None:
            self.org_name = org_name
        if owner_name is not None:
            self.owner_name = owner_name
        if number_of_templates is not None:
            self.number_of_templates = number_of_templates
        if number_of_media is not None:
            self.number_of_media = number_of_media
        if owner is not None:
            self.owner = owner
        if is_local is not None:
            self.is_local = is_local

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def is_published(self):
        return self._is_published
    
    @is_published.setter
    def is_published(self, is_published):
        self._is_published = is_published

    @property
    def is_shared(self):
        return self._is_shared
    
    @is_shared.setter
    def is_shared(self, is_shared):
        self._is_shared = is_shared

    @property
    def creation_date(self):
        return self._creation_date
    
    @creation_date.setter
    def creation_date(self, creation_date):
        self._creation_date = creation_date

    @property
    def org_name(self):
        return self._org_name
    
    @org_name.setter
    def org_name(self, org_name):
        self._org_name = org_name

    @property
    def owner_name(self):
        return self._owner_name
    
    @owner_name.setter
    def owner_name(self, owner_name):
        self._owner_name = owner_name

    @property
    def number_of_templates(self):
        return self._number_of_templates
    
    @number_of_templates.setter
    def number_of_templates(self, number_of_templates):
        self._number_of_templates = number_of_templates

    @property
    def number_of_media(self):
        return self._number_of_media
    
    @number_of_media.setter
    def number_of_media(self, number_of_media):
        self._number_of_media = number_of_media

    @property
    def owner(self):
        return self._owner
    
    @owner.setter
    def owner(self, owner):
        self._owner = owner

    @property
    def is_local(self):
        return self._is_local
    
    @is_local.setter
    def is_local(self, is_local):
        self._is_local = is_local


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultAdminCatalogRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
