"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .entity_type import EntityType


class PvdcComputePolicyType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'policy_description': 'str',
        'named_vm_group_references': 'VMWVmGroupReferencesType'
    }

    attribute_map = {
        'policy_description': 'policyDescription',
        'named_vm_group_references': 'namedVmGroupReferences'
    }

    def __init__(self, policy_description=None,named_vm_group_references=None):
        self._policy_description = None
        self._named_vm_group_references = None

        if policy_description is not None:
            self.policy_description = policy_description
        if named_vm_group_references is not None:
            self.named_vm_group_references = named_vm_group_references

    @property
    def policy_description(self):
        return self._policy_description
    
    @policy_description.setter
    def policy_description(self, policy_description):
        self._policy_description = policy_description

    @property
    def named_vm_group_references(self):
        return self._named_vm_group_references
    
    @named_vm_group_references.setter
    def named_vm_group_references(self, named_vm_group_references):
        self._named_vm_group_references = named_vm_group_references


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PvdcComputePolicyType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
