"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .entity_type import EntityType


class ProviderVdcType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'compute_capacity': 'RootComputeCapacityType',
        'storage_capacity': 'ProviderVdcCapacityType',
        'available_networks': 'AvailableNetworksType',
        'storage_profiles': 'ProviderVdcStorageProfilesType',
        'capabilities': 'CapabilitiesType',
        'vdcs': 'VdcsType',
        'is_enabled': 'bool',
        'network_pool_references': 'NetworkPoolReferencesType',
        'status': 'int'
    }

    attribute_map = {
        'compute_capacity': 'computeCapacity',
        'storage_capacity': 'storageCapacity',
        'available_networks': 'availableNetworks',
        'storage_profiles': 'storageProfiles',
        'capabilities': 'capabilities',
        'vdcs': 'vdcs',
        'is_enabled': 'isEnabled',
        'network_pool_references': 'networkPoolReferences',
        'status': 'status'
    }

    def __init__(self, compute_capacity=None,storage_capacity=None,available_networks=None,storage_profiles=None,capabilities=None,vdcs=None,is_enabled=None,network_pool_references=None,status=None):
        self._compute_capacity = None
        self._storage_capacity = None
        self._available_networks = None
        self._storage_profiles = None
        self._capabilities = None
        self._vdcs = None
        self._is_enabled = None
        self._network_pool_references = None
        self._status = None

        if compute_capacity is not None:
            self.compute_capacity = compute_capacity
        if storage_capacity is not None:
            self.storage_capacity = storage_capacity
        if available_networks is not None:
            self.available_networks = available_networks
        if storage_profiles is not None:
            self.storage_profiles = storage_profiles
        if capabilities is not None:
            self.capabilities = capabilities
        if vdcs is not None:
            self.vdcs = vdcs
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if network_pool_references is not None:
            self.network_pool_references = network_pool_references
        if status is not None:
            self.status = status

    @property
    def compute_capacity(self):
        return self._compute_capacity
    
    @compute_capacity.setter
    def compute_capacity(self, compute_capacity):
        self._compute_capacity = compute_capacity

    @property
    def storage_capacity(self):
        return self._storage_capacity
    
    @storage_capacity.setter
    def storage_capacity(self, storage_capacity):
        self._storage_capacity = storage_capacity

    @property
    def available_networks(self):
        return self._available_networks
    
    @available_networks.setter
    def available_networks(self, available_networks):
        self._available_networks = available_networks

    @property
    def storage_profiles(self):
        return self._storage_profiles
    
    @storage_profiles.setter
    def storage_profiles(self, storage_profiles):
        self._storage_profiles = storage_profiles

    @property
    def capabilities(self):
        return self._capabilities
    
    @capabilities.setter
    def capabilities(self, capabilities):
        self._capabilities = capabilities

    @property
    def vdcs(self):
        return self._vdcs
    
    @vdcs.setter
    def vdcs(self, vdcs):
        self._vdcs = vdcs

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def network_pool_references(self):
        return self._network_pool_references
    
    @network_pool_references.setter
    def network_pool_references(self, network_pool_references):
        self._network_pool_references = network_pool_references

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProviderVdcType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
