"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .entity_type import EntityType


class ProviderVdcStorageProfileType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'enabled': 'bool',
        'units': 'str',
        'capacity_total': 'int',
        'capacity_used': 'int',
        'iops_capacity': 'int',
        'iops_allocated': 'int'
    }

    attribute_map = {
        'enabled': 'enabled',
        'units': 'units',
        'capacity_total': 'capacityTotal',
        'capacity_used': 'capacityUsed',
        'iops_capacity': 'iopsCapacity',
        'iops_allocated': 'iopsAllocated'
    }

    def __init__(self, enabled=None,units=None,capacity_total=None,capacity_used=None,iops_capacity=None,iops_allocated=None):
        self._enabled = None
        self._units = None
        self._capacity_total = None
        self._capacity_used = None
        self._iops_capacity = None
        self._iops_allocated = None

        if enabled is not None:
            self.enabled = enabled
        if units is not None:
            self.units = units
        if capacity_total is not None:
            self.capacity_total = capacity_total
        if capacity_used is not None:
            self.capacity_used = capacity_used
        if iops_capacity is not None:
            self.iops_capacity = iops_capacity
        if iops_allocated is not None:
            self.iops_allocated = iops_allocated

    @property
    def enabled(self):
        return self._enabled
    
    @enabled.setter
    def enabled(self, enabled):
        self._enabled = enabled

    @property
    def units(self):
        return self._units
    
    @units.setter
    def units(self, units):
        self._units = units

    @property
    def capacity_total(self):
        return self._capacity_total
    
    @capacity_total.setter
    def capacity_total(self, capacity_total):
        self._capacity_total = capacity_total

    @property
    def capacity_used(self):
        return self._capacity_used
    
    @capacity_used.setter
    def capacity_used(self, capacity_used):
        self._capacity_used = capacity_used

    @property
    def iops_capacity(self):
        return self._iops_capacity
    
    @iops_capacity.setter
    def iops_capacity(self, iops_capacity):
        self._iops_capacity = iops_capacity

    @property
    def iops_allocated(self):
        return self._iops_allocated
    
    @iops_allocated.setter
    def iops_allocated(self, iops_allocated):
        self._iops_allocated = iops_allocated


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProviderVdcStorageProfileType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
