"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class ProviderVdcCapacityType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'units': 'str',
        'allocation': 'int',
        'reserved': 'int',
        'total': 'int',
        'used': 'int',
        'overhead': 'int'
    }

    attribute_map = {
        'units': 'units',
        'allocation': 'allocation',
        'reserved': 'reserved',
        'total': 'total',
        'used': 'used',
        'overhead': 'overhead'
    }

    def __init__(self, units=None,allocation=None,reserved=None,total=None,used=None,overhead=None):
        self._units = None
        self._allocation = None
        self._reserved = None
        self._total = None
        self._used = None
        self._overhead = None

        if units is not None:
            self.units = units
        if allocation is not None:
            self.allocation = allocation
        if reserved is not None:
            self.reserved = reserved
        if total is not None:
            self.total = total
        if used is not None:
            self.used = used
        if overhead is not None:
            self.overhead = overhead

    @property
    def units(self):
        return self._units
    
    @units.setter
    def units(self, units):
        self._units = units

    @property
    def allocation(self):
        return self._allocation
    
    @allocation.setter
    def allocation(self, allocation):
        self._allocation = allocation

    @property
    def reserved(self):
        return self._reserved
    
    @reserved.setter
    def reserved(self, reserved):
        self._reserved = reserved

    @property
    def total(self):
        return self._total
    
    @total.setter
    def total(self, total):
        self._total = total

    @property
    def used(self):
        return self._used
    
    @used.setter
    def used(self, used):
        self._used = used

    @property
    def overhead(self):
        return self._overhead
    
    @overhead.setter
    def overhead(self, overhead):
        self._overhead = overhead


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProviderVdcCapacityType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
