"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class OrgVdcRollupType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'site_reference': 'list[ReferenceType]',
        'org_reference': 'list[ReferenceType]',
        'org_vdc_reference': 'list[ReferenceType]',
        'number_of_orgs': 'int',
        'number_of_powered_on_vms': 'int',
        'number_of_deployed_v_apps': 'int',
        'number_of_deployed_unmanaged_v_apps': 'int',
        'reservation_pool_vdc_summary': 'ReservationPoolVdcSummaryType',
        'allocation_pool_vdc_summary': 'AllocationPoolVdcSummaryType',
        'pay_go_vdc_summary': 'PayGoVdcSummaryType',
        'flex_vdc_summary': 'FlexVdcSummaryType'
    }

    attribute_map = {
        'site_reference': 'siteReference',
        'org_reference': 'orgReference',
        'org_vdc_reference': 'orgVdcReference',
        'number_of_orgs': 'numberOfOrgs',
        'number_of_powered_on_vms': 'numberOfPoweredOnVms',
        'number_of_deployed_v_apps': 'numberOfDeployedVApps',
        'number_of_deployed_unmanaged_v_apps': 'numberOfDeployedUnmanagedVApps',
        'reservation_pool_vdc_summary': 'reservationPoolVdcSummary',
        'allocation_pool_vdc_summary': 'allocationPoolVdcSummary',
        'pay_go_vdc_summary': 'payGoVdcSummary',
        'flex_vdc_summary': 'flexVdcSummary'
    }

    def __init__(self, site_reference=None,org_reference=None,org_vdc_reference=None,number_of_orgs=None,number_of_powered_on_vms=None,number_of_deployed_v_apps=None,number_of_deployed_unmanaged_v_apps=None,reservation_pool_vdc_summary=None,allocation_pool_vdc_summary=None,pay_go_vdc_summary=None,flex_vdc_summary=None):
        self._site_reference = None
        self._org_reference = None
        self._org_vdc_reference = None
        self._number_of_orgs = None
        self._number_of_powered_on_vms = None
        self._number_of_deployed_v_apps = None
        self._number_of_deployed_unmanaged_v_apps = None
        self._reservation_pool_vdc_summary = None
        self._allocation_pool_vdc_summary = None
        self._pay_go_vdc_summary = None
        self._flex_vdc_summary = None

        if site_reference is not None:
            self.site_reference = site_reference
        if org_reference is not None:
            self.org_reference = org_reference
        if org_vdc_reference is not None:
            self.org_vdc_reference = org_vdc_reference
        if number_of_orgs is not None:
            self.number_of_orgs = number_of_orgs
        if number_of_powered_on_vms is not None:
            self.number_of_powered_on_vms = number_of_powered_on_vms
        if number_of_deployed_v_apps is not None:
            self.number_of_deployed_v_apps = number_of_deployed_v_apps
        if number_of_deployed_unmanaged_v_apps is not None:
            self.number_of_deployed_unmanaged_v_apps = number_of_deployed_unmanaged_v_apps
        if reservation_pool_vdc_summary is not None:
            self.reservation_pool_vdc_summary = reservation_pool_vdc_summary
        if allocation_pool_vdc_summary is not None:
            self.allocation_pool_vdc_summary = allocation_pool_vdc_summary
        if pay_go_vdc_summary is not None:
            self.pay_go_vdc_summary = pay_go_vdc_summary
        if flex_vdc_summary is not None:
            self.flex_vdc_summary = flex_vdc_summary

    @property
    def site_reference(self):
        return self._site_reference
    
    @site_reference.setter
    def site_reference(self, site_reference):
        self._site_reference = site_reference

    @property
    def org_reference(self):
        return self._org_reference
    
    @org_reference.setter
    def org_reference(self, org_reference):
        self._org_reference = org_reference

    @property
    def org_vdc_reference(self):
        return self._org_vdc_reference
    
    @org_vdc_reference.setter
    def org_vdc_reference(self, org_vdc_reference):
        self._org_vdc_reference = org_vdc_reference

    @property
    def number_of_orgs(self):
        return self._number_of_orgs
    
    @number_of_orgs.setter
    def number_of_orgs(self, number_of_orgs):
        self._number_of_orgs = number_of_orgs

    @property
    def number_of_powered_on_vms(self):
        return self._number_of_powered_on_vms
    
    @number_of_powered_on_vms.setter
    def number_of_powered_on_vms(self, number_of_powered_on_vms):
        self._number_of_powered_on_vms = number_of_powered_on_vms

    @property
    def number_of_deployed_v_apps(self):
        return self._number_of_deployed_v_apps
    
    @number_of_deployed_v_apps.setter
    def number_of_deployed_v_apps(self, number_of_deployed_v_apps):
        self._number_of_deployed_v_apps = number_of_deployed_v_apps

    @property
    def number_of_deployed_unmanaged_v_apps(self):
        return self._number_of_deployed_unmanaged_v_apps
    
    @number_of_deployed_unmanaged_v_apps.setter
    def number_of_deployed_unmanaged_v_apps(self, number_of_deployed_unmanaged_v_apps):
        self._number_of_deployed_unmanaged_v_apps = number_of_deployed_unmanaged_v_apps

    @property
    def reservation_pool_vdc_summary(self):
        return self._reservation_pool_vdc_summary
    
    @reservation_pool_vdc_summary.setter
    def reservation_pool_vdc_summary(self, reservation_pool_vdc_summary):
        self._reservation_pool_vdc_summary = reservation_pool_vdc_summary

    @property
    def allocation_pool_vdc_summary(self):
        return self._allocation_pool_vdc_summary
    
    @allocation_pool_vdc_summary.setter
    def allocation_pool_vdc_summary(self, allocation_pool_vdc_summary):
        self._allocation_pool_vdc_summary = allocation_pool_vdc_summary

    @property
    def pay_go_vdc_summary(self):
        return self._pay_go_vdc_summary
    
    @pay_go_vdc_summary.setter
    def pay_go_vdc_summary(self, pay_go_vdc_summary):
        self._pay_go_vdc_summary = pay_go_vdc_summary

    @property
    def flex_vdc_summary(self):
        return self._flex_vdc_summary
    
    @flex_vdc_summary.setter
    def flex_vdc_summary(self, flex_vdc_summary):
        self._flex_vdc_summary = flex_vdc_summary


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrgVdcRollupType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
