"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_type import ResourceType


class OrgPasswordPolicySettingsType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'account_lockout_enabled': 'bool',
        'invalid_logins_before_lockout': 'int',
        'account_lockout_interval_minutes': 'int'
    }

    attribute_map = {
        'account_lockout_enabled': 'accountLockoutEnabled',
        'invalid_logins_before_lockout': 'invalidLoginsBeforeLockout',
        'account_lockout_interval_minutes': 'accountLockoutIntervalMinutes'
    }

    def __init__(self, account_lockout_enabled=None,invalid_logins_before_lockout=None,account_lockout_interval_minutes=None):
        self._account_lockout_enabled = None
        self._invalid_logins_before_lockout = None
        self._account_lockout_interval_minutes = None

        if account_lockout_enabled is not None:
            self.account_lockout_enabled = account_lockout_enabled
        if invalid_logins_before_lockout is not None:
            self.invalid_logins_before_lockout = invalid_logins_before_lockout
        if account_lockout_interval_minutes is not None:
            self.account_lockout_interval_minutes = account_lockout_interval_minutes

    @property
    def account_lockout_enabled(self):
        return self._account_lockout_enabled
    
    @account_lockout_enabled.setter
    def account_lockout_enabled(self, account_lockout_enabled):
        self._account_lockout_enabled = account_lockout_enabled

    @property
    def invalid_logins_before_lockout(self):
        return self._invalid_logins_before_lockout
    
    @invalid_logins_before_lockout.setter
    def invalid_logins_before_lockout(self, invalid_logins_before_lockout):
        self._invalid_logins_before_lockout = invalid_logins_before_lockout

    @property
    def account_lockout_interval_minutes(self):
        return self._account_lockout_interval_minutes
    
    @account_lockout_interval_minutes.setter
    def account_lockout_interval_minutes(self, account_lockout_interval_minutes):
        self._account_lockout_interval_minutes = account_lockout_interval_minutes


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrgPasswordPolicySettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
